/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.filters;

import com.google.common.base.Predicate;
import java.text.MessageFormat;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DecoratingDebugFilter<T>
implements Predicate<T> {
    private static final int DEBUG_STATUS_SEVERITY = 1;
    private static final String DEBUG_STATUS_PLUGIN_ID = "org.eclipse.epp.logging.aeri.core";
    private Predicate<T> predicate;
    private ILog log;

    public static <T> Predicate<? super T>[] decorate(Predicate<? super T> ... components) {
        ILog log = Platform.getLog((Bundle)FrameworkUtil.getBundle(DecoratingDebugFilter.class));
        Predicate[] predicates = new Predicate[components.length];
        int i = 0;
        while (i < components.length) {
            predicates[i] = new DecoratingDebugFilter<T>(components[i], log);
            ++i;
        }
        return predicates;
    }

    public DecoratingDebugFilter(Predicate<T> predicate, ILog log) {
        this.predicate = predicate;
        this.log = log;
    }

    public boolean apply(@Nullable T input) {
        boolean apply = this.predicate.apply(input);
        if (!apply && SystemControl.isDebug()) {
            if (input instanceof IStatus) {
                this.debugStatus((IStatus)input);
            } else if (input instanceof IReport) {
                this.debugReport((IReport)input);
            }
        }
        return apply;
    }

    private void debugStatus(IStatus inputStatus) {
        if (inputStatus.getSeverity() == 1 && inputStatus.getPlugin().equals(DEBUG_STATUS_PLUGIN_ID)) {
            return;
        }
        String message = MessageFormat.format("Debug: predicate {0} filtered status: {1}", this.predicate.getClass().getSimpleName(), inputStatus.getMessage());
        this.logDebugMessageStatus(message);
    }

    private void debugReport(IReport report) {
        String message = MessageFormat.format("Debug: predicate {0} filtered report: {1}", this.predicate.getClass().getSimpleName(), report.getStatus().getMessage());
        this.logDebugMessageStatus(message);
    }

    private void logDebugMessageStatus(String message) {
        Status status = new Status(1, DEBUG_STATUS_PLUGIN_ID, message);
        this.log.log((IStatus)status);
    }

    public boolean equals(@Nullable Object object) {
        return this.predicate.equals(object);
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }

    public String toString() {
        return this.predicate.toString();
    }
}

