/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateCountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SimpleMapPersistable;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IElementFormatProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.ElementFormatEvent;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class ElementNumberFormatProvider
implements IElementFormatProvider {
    private static final String ELEMENT_FORMAT_PERSISTABLE_PROPERTY = "org.eclipse.cdt.dsf.ui.elementFormatPersistable";
    private static final String FILTER_PROVIDER_ID = String.valueOf(ElementNumberFormatProvider.class.getName()) + ".eventFilter";
    private final IVMProvider fVMProvider;
    private final DsfSession fSession;
    private final Dictionary<String, String> fFilterProperties = new Hashtable<String, String>();

    public ElementNumberFormatProvider(IVMProvider vmProvider, DsfSession session) {
        this.fVMProvider = vmProvider;
        this.fSession = session;
        this.initialize();
    }

    protected void initialize() {
        IPresentationContext presentationCtx = this.getVMProvider().getPresentationContext();
        IWorkbenchPart part = presentationCtx.getPart();
        String provider = part != null ? part.getTitle() : this.getVMProvider().getPresentationContext().getId();
        this.fFilterProperties.put(FILTER_PROVIDER_ID, provider);
        String filterStr = "(&(" + FILTER_PROVIDER_ID + "=" + provider + "))";
        try {
            final Filter filter = DsfUIPlugin.getBundleContext().createFilter(filterStr);
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    ElementNumberFormatProvider.this.fSession.addServiceEventListener((Object)ElementNumberFormatProvider.this, filter);
                }
            });
        }
        catch (InvalidSyntaxException e) {
            assert (false) : e.getMessage();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    ElementNumberFormatProvider.this.fSession.removeServiceEventListener((Object)ElementNumberFormatProvider.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @DsfServiceEventHandler
    public final void eventDispatched(ElementFormatEvent event) {
        if (this.getVMProvider() instanceof AbstractVMProvider) {
            ((AbstractVMProvider)this.getVMProvider()).handleEvent(event);
        }
    }

    private IVMProvider getVMProvider() {
        return this.fVMProvider;
    }

    @Override
    public void getActiveFormat(IPresentationContext context, IVMNode node, Object viewerInput, TreePath elementPath, final DataRequestMonitor<String> rm) {
        this.getElementKey(viewerInput, elementPath, (DataRequestMonitor<String>)new ImmediateDataRequestMonitor<String>(rm){

            protected void handleSuccess() {
                SimpleMapPersistable<String> persistable = ElementNumberFormatProvider.this.getPersistable();
                rm.done((Object)persistable.getValue((String)this.getData()));
            }
        });
    }

    @Override
    public void setActiveFormat(IPresentationContext context, IVMNode[] node, Object viewerInput, TreePath[] elementPaths, final String format) {
        final HashSet elementsToRefresh = new HashSet();
        ImmediateCountingRequestMonitor crm = new ImmediateCountingRequestMonitor(){

            protected void handleCompleted() {
                if (!elementsToRefresh.isEmpty()) {
                    DsfSession[] dsfSessionArray = DsfSession.getActiveSessions();
                    int n = dsfSessionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DsfSession session = dsfSessionArray[n2];
                        session.dispatchEvent((Object)new ElementFormatEvent(elementsToRefresh, 1), ElementNumberFormatProvider.this.fFilterProperties);
                        ++n2;
                    }
                }
            }
        };
        TreePath[] treePathArray = elementPaths;
        int n = elementPaths.length;
        int n2 = 0;
        while (n2 < n) {
            final TreePath path = treePathArray[n2];
            this.getElementKey(viewerInput, path, (DataRequestMonitor<String>)new ImmediateDataRequestMonitor<String>((RequestMonitor)crm, (CountingRequestMonitor)crm){
                private final /* synthetic */ CountingRequestMonitor val$crm;
                {
                    this.val$crm = countingRequestMonitor;
                    super($anonymous0);
                }

                protected void handleSuccess() {
                    SimpleMapPersistable<String> persistable = ElementNumberFormatProvider.this.getPersistable();
                    persistable.setValue((String)this.getData(), format);
                    elementsToRefresh.add(path.getLastSegment());
                    this.val$crm.done();
                }
            });
            ++n2;
        }
        crm.setDoneCount(elementPaths.length);
    }

    @Override
    public boolean supportFormat(IVMContext context) {
        if (context instanceof IDMVMContext && ((IDMVMContext)context).getDMContext() instanceof IExpressions.IExpressionGroupDMContext) {
            return false;
        }
        return context instanceof IFormattedValueVMContext;
    }

    protected void getElementKey(Object viewerInput, TreePath elementPath, final DataRequestMonitor<String> rm) {
        Object element = elementPath.getLastSegment();
        if (element instanceof IDMVMContext) {
            final IDMContext dmc = ((IDMVMContext)element).getDMContext();
            if (dmc instanceof IExpressions.IExpressionDMContext) {
                rm.done((Object)((IExpressions.IExpressionDMContext)dmc).getExpression());
                return;
            }
            if (dmc instanceof IRegisters.IRegisterDMContext) {
                this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), ElementNumberFormatProvider.this.fSession.getId());
                        IRegisters regService = (IRegisters)tracker.getService(IRegisters.class);
                        tracker.dispose();
                        regService.getRegisterData((IRegisters.IRegisterDMContext)dmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<IRegisters.IRegisterDMData>((RequestMonitor)rm){

                            protected void handleSuccess() {
                                rm.done((Object)((IRegisters.IRegisterDMData)this.getData()).getName());
                            }
                        });
                    }
                });
                return;
            }
        }
        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, "Cannot calculate peristable key for element: " + element, null));
    }

    protected SimpleMapPersistable<String> getPersistable() {
        Object p = this.getVMProvider().getPresentationContext().getProperty(ELEMENT_FORMAT_PERSISTABLE_PROPERTY);
        if (p instanceof SimpleMapPersistable) {
            return (SimpleMapPersistable)p;
        }
        SimpleMapPersistable<String> persistable = new SimpleMapPersistable<String>(String.class);
        this.getVMProvider().getPresentationContext().setProperty(ELEMENT_FORMAT_PERSISTABLE_PROPERTY, persistable);
        return persistable;
    }
}

