/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

@ConfinedToDsfExecutor(value="#getExecutor()")
public final class SteppingController {
    public static final int STEPPING_TIMEOUT = 500;
    public static final int STEP_QUEUE_DEPTH = 2;
    public static final int MAX_STEP_DELAY = 5000;
    private static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.ui/debug/stepping"));
    private final DsfSession fSession;
    private final DsfServicesTracker fServicesTracker;
    private IRunControl fRunControl;
    private int fQueueDepth = 2;
    private final Map<IRunControl.IExecutionDMContext, List<StepRequest>> fStepQueues = new HashMap<IRunControl.IExecutionDMContext, List<StepRequest>>();
    private final Map<IRunControl.IExecutionDMContext, Boolean> fTimedOutFlags = new HashMap<IRunControl.IExecutionDMContext, Boolean>();
    private final Map<IRunControl.IExecutionDMContext, ScheduledFuture<?>> fTimedOutFutures = new HashMap();
    private final Map<IRunControl.IExecutionDMContext, Long> fLastStepTimes = new HashMap<IRunControl.IExecutionDMContext, Long>();
    private volatile int fMinStepInterval;
    private volatile int fStepTimeout = 500;
    private final Map<IRunControl.IExecutionDMContext, List<ISteppingControlParticipant>> fStepInProgress = new HashMap<IRunControl.IExecutionDMContext, List<ISteppingControlParticipant>>();
    private final List<ISteppingControlParticipant> fParticipants = Collections.synchronizedList(new ArrayList());
    private IPropertyChangeListener fPreferencesListener;

    public SteppingController(DsfSession session) {
        this.fSession = session;
        this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
        final IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
        this.fPreferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SteppingController.this.handlePropertyChanged(store, event);
            }
        };
        store.addPropertyChangeListener(this.fPreferencesListener);
        this.setMinimumStepInterval(store.getInt("minStepInterval"));
    }

    @ThreadSafe
    public void dispose() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (SteppingController.this.fRunControl != null) {
                        SteppingController.this.getSession().removeServiceEventListener((Object)SteppingController.this);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.fPreferencesListener);
        this.fServicesTracker.dispose();
    }

    @ThreadSafe
    public void setMinimumStepInterval(int interval) {
        this.fMinStepInterval = interval;
    }

    @ThreadSafe
    public void setStepTimeout(int timeout) {
        assert (timeout >= 0);
        this.fStepTimeout = timeout;
    }

    @ThreadSafe
    public int getStepTimeout() {
        return this.fStepTimeout;
    }

    @ThreadSafe
    public void addSteppingControlParticipant(ISteppingControlParticipant participant) {
        this.fParticipants.add(participant);
    }

    @ThreadSafe
    public void removeSteppingControlParticipant(ISteppingControlParticipant participant) {
        this.fParticipants.remove(participant);
    }

    public void doneStepping(IRunControl.IExecutionDMContext execCtx, ISteppingControlParticipant participant) {
        List<ISteppingControlParticipant> participants;
        if (DEBUG) {
            System.out.println("[SteppingController] doneStepping participant=" + participant.getClass().getSimpleName());
        }
        if ((participants = this.fStepInProgress.get(execCtx)) != null) {
            participants.remove(participant);
            if (participants.isEmpty()) {
                this.doneStepping(execCtx);
            }
        } else {
            for (IRunControl.IExecutionDMContext disabledCtx : this.fStepInProgress.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)disabledCtx, (IDMContext)execCtx) || (participants = this.fStepInProgress.get(disabledCtx)) == null) continue;
                participants.remove(participant);
                if (!participants.isEmpty()) continue;
                this.doneStepping(disabledCtx);
            }
        }
    }

    @ThreadSafe
    public DsfSession getSession() {
        return this.fSession;
    }

    @ThreadSafe
    public DsfExecutor getExecutor() {
        return this.getSession().getExecutor();
    }

    private DsfServicesTracker getServicesTracker() {
        return this.fServicesTracker;
    }

    private IRunControl getRunControl() {
        if (this.fRunControl == null) {
            this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
            this.getSession().addServiceEventListener((Object)this, null);
        }
        return this.fRunControl;
    }

    public void canEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        if (this.doCanEnqueueStep(execCtx, stepType)) {
            rm.setData((Object)true);
            rm.done();
        } else {
            this.getRunControl().canStep(execCtx, stepType, rm);
        }
    }

    private boolean doCanEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        return this.getRunControl().isStepping(execCtx) && !this.isSteppingTimedOut(execCtx);
    }

    private boolean shouldDelayStep(IRunControl.IExecutionDMContext execCtx) {
        int stepDelay = this.getStepDelay(execCtx);
        if (DEBUG) {
            System.out.println("[SteppingController] shouldDelayStep delay=" + stepDelay);
        }
        return stepDelay > 0;
    }

    private int getStepDelay(IRunControl.IExecutionDMContext execCtx) {
        int minStepInterval = this.fMinStepInterval;
        if (minStepInterval > 0) {
            for (IRunControl.IExecutionDMContext lastStepCtx : this.fLastStepTimes.keySet()) {
                if (!execCtx.equals(lastStepCtx) && !DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)lastStepCtx)) continue;
                long now = System.currentTimeMillis();
                int delay = (int)(this.fLastStepTimes.get(lastStepCtx) + (long)minStepInterval - now);
                return Math.max(delay, 0);
            }
        }
        return 0;
    }

    private void updateLastStepTime(IRunControl.IExecutionDMContext execCtx) {
        long now = System.currentTimeMillis();
        this.fLastStepTimes.put(execCtx, now);
        for (IRunControl.IExecutionDMContext lastStepCtx : this.fLastStepTimes.keySet()) {
            if (execCtx.equals(lastStepCtx) || !DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)lastStepCtx)) continue;
            this.fLastStepTimes.put(lastStepCtx, now);
        }
    }

    private long getLastStepTime(IRunControl.IExecutionDMContext execCtx) {
        if (this.fLastStepTimes.containsKey(execCtx)) {
            return this.fLastStepTimes.get(execCtx);
        }
        for (IRunControl.IExecutionDMContext lastStepCtx : this.fLastStepTimes.keySet()) {
            if (!DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)lastStepCtx)) continue;
            return this.fLastStepTimes.get(lastStepCtx);
        }
        return 0L;
    }

    public int getPendingStepCount(IRunControl.IExecutionDMContext execCtx) {
        List<StepRequest> stepQueue = this.getStepQueue(execCtx);
        if (stepQueue == null) {
            return 0;
        }
        return stepQueue.size();
    }

    public void enqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        if (DEBUG) {
            System.out.println("[SteppingController] enqueueStep ctx=" + execCtx);
        }
        if (!this.shouldDelayStep(execCtx) || this.doCanEnqueueStep(execCtx, stepType)) {
            this.doEnqueueStep(execCtx, stepType);
            this.processStepQueue(execCtx);
        }
    }

    private void doStep(final IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        if (DEBUG) {
            System.out.println("[SteppingController] doStep ctx=" + execCtx);
        }
        this.disableStepping(execCtx);
        this.updateLastStepTime(execCtx);
        this.getRunControl().step(execCtx, stepType, new RequestMonitor((Executor)this.getExecutor(), null){

            protected void handleSuccess() {
                SteppingController.this.fTimedOutFlags.remove(execCtx);
                ScheduledFuture currentTimeOutFuture = (ScheduledFuture)SteppingController.this.fTimedOutFutures.get(execCtx);
                if (currentTimeOutFuture != null) {
                    currentTimeOutFuture.cancel(false);
                }
                SteppingController.this.fTimedOutFutures.put(execCtx, SteppingController.this.getExecutor().schedule((Runnable)((Object)new TimeOutRunnable(execCtx)), (long)SteppingController.this.fStepTimeout, TimeUnit.MILLISECONDS));
            }

            protected void handleFailure() {
                SteppingController.this.enableStepping(execCtx);
                if (this.getStatus().getCode() == 10001) {
                    return;
                }
                super.handleFailure();
            }
        });
    }

    private void doEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
        if (stepQueue == null) {
            stepQueue = new LinkedList<StepRequest>();
            this.fStepQueues.put(execCtx, stepQueue);
        }
        if (stepQueue.size() < this.fQueueDepth) {
            stepQueue.add(new StepRequest(execCtx, stepType));
        }
    }

    public boolean isSteppingTimedOut(IRunControl.IExecutionDMContext execCtx) {
        for (IRunControl.IExecutionDMContext timedOutCtx : this.fTimedOutFlags.keySet()) {
            if (!execCtx.equals(timedOutCtx) && !DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)timedOutCtx)) continue;
            return this.fTimedOutFlags.get(timedOutCtx);
        }
        return false;
    }

    private void processStepQueue(final IRunControl.IExecutionDMContext execCtx) {
        final List<StepRequest> queue = this.getStepQueue(execCtx);
        if (queue != null) {
            int stepDelay = this.getStepDelay(execCtx);
            if (stepDelay > 0) {
                this.getExecutor().schedule((Runnable)new DsfRunnable(){

                    public void run() {
                        SteppingController.this.processStepQueue(execCtx);
                    }
                }, (long)stepDelay, TimeUnit.MILLISECONDS);
                return;
            }
            final StepRequest request = queue.get(0);
            if (DEBUG) {
                System.out.println("[SteppingController] processStepQueue request-in-progress=" + request.inProgress);
            }
            if (!request.inProgress) {
                if (this.isSteppingDisabled(request.fContext)) {
                    return;
                }
                request.inProgress = true;
                this.getRunControl().canStep(request.fContext, request.fStepType, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                            queue.remove(0);
                            if (queue.isEmpty()) {
                                SteppingController.this.fStepQueues.remove(request.fContext);
                            }
                            SteppingController.this.doStep(request.fContext, request.fStepType);
                        } else {
                            SteppingController.this.fStepQueues.remove(request.fContext);
                        }
                    }
                });
            }
        }
    }

    private List<StepRequest> getStepQueue(IRunControl.IExecutionDMContext execCtx) {
        List<StepRequest> queue = this.fStepQueues.get(execCtx);
        if (queue == null) {
            for (IRunControl.IExecutionDMContext stepCtx : this.fStepQueues.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)stepCtx, (IDMContext)execCtx)) continue;
                queue = this.fStepQueues.get(stepCtx);
                break;
            }
        }
        return queue;
    }

    private void disableStepping(IRunControl.IExecutionDMContext execCtx) {
        if (!this.fParticipants.isEmpty()) {
            this.fStepInProgress.put(execCtx, new ArrayList<ISteppingControlParticipant>(this.fParticipants));
        }
    }

    private void doneStepping(IRunControl.IExecutionDMContext execCtx) {
        if (DEBUG) {
            System.out.println("[SteppingController] doneStepping ctx=" + execCtx);
        }
        this.enableStepping(execCtx);
        this.processStepQueue(execCtx);
    }

    public void enableStepping(IRunControl.IExecutionDMContext execCtx) {
        this.fStepInProgress.remove(execCtx);
        for (IRunControl.IExecutionDMContext disabledCtx : this.fStepInProgress.keySet()) {
            if (!DMContexts.isAncestorOf((IDMContext)disabledCtx, (IDMContext)execCtx)) continue;
            this.fStepInProgress.remove(disabledCtx);
        }
    }

    private boolean isSteppingDisabled(IRunControl.IExecutionDMContext execCtx) {
        long lastStepTime;
        long now;
        boolean disabled = this.fStepInProgress.containsKey(execCtx);
        if (!disabled) {
            for (IRunControl.IExecutionDMContext disabledCtx : this.fStepInProgress.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)disabledCtx)) continue;
                disabled = true;
                break;
            }
        }
        if (disabled && (now = System.currentTimeMillis()) - (lastStepTime = this.getLastStepTime(execCtx)) > 5000L) {
            if (DEBUG) {
                System.out.println("[SteppingController] stepping control participant(s) timed out");
            }
            this.enableStepping(execCtx);
            disabled = false;
        }
        return disabled;
    }

    protected void handlePropertyChanged(IPreferenceStore store, PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("minStepInterval".equals(property)) {
            this.setMinimumStepInterval(store.getInt(property));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        IRunControl.IExecutionDMContext nextDmc;
        Map.Entry<IRunControl.IExecutionDMContext, Comparable<Boolean>> entry;
        boolean timedOut = false;
        IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)e.getDMContext();
        Iterator<Map.Entry<IRunControl.IExecutionDMContext, Comparable<Boolean>>> itr = this.fTimedOutFlags.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            nextDmc = entry.getKey();
            if (!nextDmc.equals(dmc) && !DMContexts.isAncestorOf((IDMContext)nextDmc, (IDMContext)dmc)) continue;
            if (((Boolean)entry.getValue()).booleanValue()) {
                this.fStepQueues.remove(dmc);
                timedOut = true;
            }
            itr.remove();
        }
        itr = this.fTimedOutFutures.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            nextDmc = entry.getKey();
            if (!nextDmc.equals(dmc) && !DMContexts.isAncestorOf((IDMContext)nextDmc, (IDMContext)dmc) && !DMContexts.isAncestorOf((IDMContext)dmc, (IDMContext)nextDmc)) continue;
            ((ScheduledFuture)entry.getValue()).cancel(false);
            itr.remove();
        }
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fStepQueues.remove(dmc);
        } else if (!timedOut) {
            this.processStepQueue(dmc);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)e.getDMContext();
            this.fTimedOutFlags.remove(dmc);
            if (!this.fTimedOutFutures.containsKey(dmc)) {
                Iterator<Map.Entry<IRunControl.IExecutionDMContext, ScheduledFuture<?>>> itr = this.fTimedOutFutures.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<IRunControl.IExecutionDMContext, ScheduledFuture<?>> entry = itr.next();
                    if (!DMContexts.isAncestorOf((IDMContext)((IDMContext)entry.getKey()), (IDMContext)dmc)) continue;
                    entry.getValue().cancel(false);
                    itr.remove();
                }
                this.fTimedOutFutures.put(dmc, this.getExecutor().schedule((Runnable)((Object)new TimeOutRunnable(dmc)), (long)this.fStepTimeout, TimeUnit.MILLISECONDS));
            }
        }
    }

    public static interface ISteppingControlParticipant {
    }

    private static class StepRequest {
        IRunControl.IExecutionDMContext fContext;
        IRunControl.StepType fStepType;
        boolean inProgress = false;

        StepRequest(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType type) {
            this.fContext = execCtx;
            this.fStepType = type;
        }
    }

    public static final class SteppingTimedOutEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext> {
        private SteppingTimedOutEvent(IRunControl.IExecutionDMContext execCtx) {
            super((IDMContext)execCtx);
        }
    }

    private class TimeOutRunnable
    extends DsfRunnable {
        private final IRunControl.IExecutionDMContext fDmc;

        TimeOutRunnable(IRunControl.IExecutionDMContext dmc) {
            this.fDmc = dmc;
        }

        public void run() {
            SteppingController.this.fTimedOutFutures.remove(this.fDmc);
            if (SteppingController.this.getSession().isActive()) {
                SteppingController.this.fTimedOutFlags.put(this.fDmc, Boolean.TRUE);
                SteppingController.this.enableStepping(this.fDmc);
                SteppingController.this.getSession().dispatchEvent((Object)new SteppingTimedOutEvent(this.fDmc), null);
            }
        }
    }
}

