/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IMultiRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IResumeHandler;

@Immutable
public class DsfResumeCommand
implements IResumeHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfResumeCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length == 1) {
            this.canExecuteSingle(request);
            return;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements(), (IDebugCommandRequest)request){

            @Override
            public void doExecute() {
                IMultiRunControl multiRun = (IMultiRunControl)DsfResumeCommand.this.fTracker.getService(IMultiRunControl.class);
                if (multiRun == null) {
                    request.setEnabled(false);
                    request.done();
                    return;
                }
                multiRun.canResumeSome(this.getContexts(), (DataRequestMonitor)new ImmediateDataRequestMonitor<Boolean>(){

                    protected void handleCompleted() {
                        request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                        request.done();
                    }
                });
            }
        }));
    }

    private void canExecuteSingle(final IEnabledStateRequest request) {
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){

            @Override
            public void doExecute() {
                this.getRunControl().canResume(this.getContext(), (DataRequestMonitor)new ImmediateDataRequestMonitor<Boolean>(){

                    protected void handleCompleted() {
                        request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                        request.done();
                    }
                });
            }
        }));
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length == 1) {
            this.executeSingle(request);
            return false;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements(), request){

            @Override
            public void doExecute() {
                IMultiRunControl multiRun = (IMultiRunControl)DsfResumeCommand.this.fTracker.getService(IMultiRunControl.class);
                if (multiRun == null) {
                    request.done();
                    return;
                }
                multiRun.resume(this.getContexts(), (RequestMonitor)new ImmediateRequestMonitor());
            }
        }));
        return false;
    }

    private void executeSingle(IDebugCommandRequest request) {
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            @Override
            public void doExecute() {
                this.getRunControl().resume(this.getContext(), new RequestMonitor((Executor)DsfResumeCommand.this.fExecutor, null));
            }
        }));
    }
}

