/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.localization.translators;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.proxy.ProxyAuthenticator;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.json.JSONArray;
import org.eclipse.andmore.android.json.JSONObject;
import org.eclipse.andmore.android.json.JSONPair;
import org.eclipse.andmore.android.json.JSONString;
import org.eclipse.andmore.android.json.JSONValue;
import org.eclipse.andmore.android.json.Jason;
import org.eclipse.andmore.android.localization.translators.GoogleTranslatorConstants;
import org.eclipse.andmore.android.localization.translators.TranslationPlugin;
import org.eclipse.andmore.android.localization.translators.i18n.TranslateNLS;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.localization.tools.datamodel.node.TranslationResult;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ITranslator;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.ITranslateDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class GoogleTranslator
extends ITranslator
implements GoogleTranslatorConstants {
    public List<TranslationResult> translate(List<String> words, String fromLanguage, String toLanguage, IProgressMonitor monitor) throws Exception {
        int MAX_REQUEST_SIZE;
        ArrayList<TranslationResult> translationResults = new ArrayList<TranslationResult>();
        int characterCount = 0;
        int maxRequestSize = MAX_REQUEST_SIZE = this.getMaxQuerySize(fromLanguage, toLanguage);
        ArrayList<String> wordsToTranslate = new ArrayList<String>();
        Iterator<String> wordsIterator = words.iterator();
        int counter = 0;
        while (wordsIterator.hasNext()) {
            String word = wordsIterator.next();
            if (characterCount + word.length() < (maxRequestSize -= "&q=".length())) {
                wordsToTranslate.add(word);
                characterCount += word.length();
                continue;
            }
            URL translationURL = this.createTranslationURL(wordsToTranslate, fromLanguage, toLanguage);
            String httpRequestResponseBody = GoogleTranslator.executeHttpGetRequest(translationURL);
            List<String> responses = this.parseTranslationResponse(httpRequestResponseBody);
            int i = 0;
            while (i < wordsToTranslate.size()) {
                translationResults.add(new TranslationResult(words.get(counter++), (ITranslator)this, responses.get(i), fromLanguage, toLanguage, Calendar.getInstance().getTime(), true));
                ++i;
            }
            characterCount = 0;
            maxRequestSize = MAX_REQUEST_SIZE;
            wordsToTranslate.clear();
            wordsToTranslate.add(word);
        }
        if (!wordsToTranslate.isEmpty()) {
            URL translationURL = this.createTranslationURL(wordsToTranslate, fromLanguage, toLanguage);
            String httpRequestResponseBody = GoogleTranslator.executeHttpGetRequest(translationURL);
            List<String> responses = this.parseTranslationResponse(httpRequestResponseBody);
            int i = 0;
            while (i < wordsToTranslate.size()) {
                translationResults.add(new TranslationResult(words.get(counter++), (ITranslator)this, responses.get(i), fromLanguage, toLanguage, Calendar.getInstance().getTime(), true));
                ++i;
            }
        }
        return translationResults;
    }

    public TranslationResult translate(String text, String from, String to) throws Exception {
        TranslationResult translationResult;
        if (text != null && !text.equals("") && text.length() < this.getMaxQuerySize(from, to)) {
            String httpResult = "";
            URL url = null;
            try {
                ArrayList<String> sentences = new ArrayList<String>();
                sentences.add(text);
                url = this.createTranslationURL(sentences, from, to);
                httpResult = GoogleTranslator.executeHttpGetRequest(url);
                translationResult = new TranslationResult(text, (ITranslator)this, this.parseTranslationResponse(httpResult).get(0), from, to, Calendar.getInstance().getTime(), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new HttpException(String.valueOf(TranslateNLS.GoogleTranslator_Error_UnsupportedEncoding) + "UTF-8");
            }
        } else {
            if (text.length() >= this.getMaxQuerySize(from, to)) {
                throw new Exception(TranslateNLS.GoogleTranslator_Error_QueryTooBig);
            }
            translationResult = new TranslationResult(text, (ITranslator)this, text, from, to, new Date(), true);
        }
        try {
            String descriptionToLog = "provider=google|from_lang=" + from + "|" + "to_lang=" + to;
            AndmoreLogger.collectUsageData((String)"automatic_translator", (String)"localization", (String)descriptionToLog, (String)"org.eclipse.andmore.android.translation", (String)TranslationPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return translationResult;
    }

    public List<TranslationResult> translate(String sentence, String fromLanguage, List<String> toLanguages) throws Exception {
        ArrayList<TranslationResult> translationResults = new ArrayList<TranslationResult>();
        if (fromLanguage == null || toLanguages == null || toLanguages.isEmpty()) {
            throw new IllegalArgumentException(TranslateNLS.GoogleTranslator_Error_ToAndFromLanguagesAreEmpty);
        }
        if (sentence == null || sentence.equals("")) {
            sentence = "";
            if (toLanguages.size() == 1) {
                translationResults.add(new TranslationResult("", (ITranslator)this, "", fromLanguage, toLanguages.get(0), new Date(), true));
            }
        } else {
            if (sentence.length() >= this.getMaxQuerySize(fromLanguage, toLanguages.get(0))) {
                throw new Exception(TranslateNLS.GoogleTranslator_Error_QueryTooBig);
            }
            for (String toLanguage : toLanguages) {
                translationResults.add(this.translate(sentence, fromLanguage, toLanguage));
            }
        }
        try {
            String descriptionToLog = "provider=google|from_lang=" + fromLanguage + "|" + "to_lang=" + "several languages";
            AndmoreLogger.collectUsageData((String)"automatic_translator", (String)"localization", (String)descriptionToLog, (String)"org.eclipse.andmore.android.translation", (String)TranslationPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return translationResults;
    }

    public List<TranslationResult> translateAll(List<String> sentences, String fromLanguage, String toLanguage, IProgressMonitor monitor) throws Exception {
        ArrayList<TranslationResult> translationResults = new ArrayList<TranslationResult>();
        if (fromLanguage == null || toLanguage == null) {
            throw new IllegalArgumentException(TranslateNLS.GoogleTranslator_Error_ToAndFromLanguagesAreEmpty);
        }
        if (sentences == null || sentences.size() == 0) {
            throw new IllegalArgumentException(TranslateNLS.GoogleTranslator_Error_NoAvailableData);
        }
        translationResults.addAll(this.translate(sentences, fromLanguage, toLanguage, monitor));
        try {
            String descriptionToLog = "provider=google|from_lang=" + fromLanguage + "|" + "to_lang=" + toLanguage;
            AndmoreLogger.collectUsageData((String)"automatic_translator", (String)"localization", (String)descriptionToLog, (String)"org.eclipse.andmore.android.translation", (String)TranslationPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return translationResults;
    }

    public List<TranslationResult> translateAll(List<String> words, List<String> fromLanguage, List<String> toLanguage, IProgressMonitor monitor) throws Exception {
        ArrayList<TranslationResult> translationResults = new ArrayList<TranslationResult>();
        if (fromLanguage == null || toLanguage == null) {
            throw new IllegalArgumentException(TranslateNLS.GoogleTranslator_Error_ToAndFromLanguagesAreEmpty);
        }
        if (words == null || words.size() == 0) {
            throw new IllegalArgumentException(TranslateNLS.GoogleTranslator_Error_NoAvailableData);
        }
        translationResults.addAll(this.groupAndTranslate(words, fromLanguage, toLanguage, monitor));
        try {
            String descriptionToLog = "provider=google|from_lang=" + fromLanguage + "|" + "to_lang=" + toLanguage;
            AndmoreLogger.collectUsageData((String)"automatic_translator", (String)"localization", (String)descriptionToLog, (String)"org.eclipse.andmore.android.translation", (String)TranslationPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return translationResults;
    }

    private List<TranslationResult> groupAndTranslate(List<String> words, List<String> fromLanguage, List<String> toLanguage, IProgressMonitor monitor) throws Exception {
        class StringItem {
            private String sentence = "";
            private int orderNumber = -1;

            public StringItem(String sentence, int orderNumber) {
                this.sentence = sentence;
                this.orderNumber = orderNumber;
            }

            public Integer getOrderNumber() {
                return this.orderNumber;
            }

            public String getSentence() {
                return this.sentence;
            }

            public String toString() {
                return String.valueOf(this.orderNumber) + "|" + this.sentence;
            }
        }
        List<StringItem> itemsToTranslate;
        ArrayList<TranslationResult> results = new ArrayList<TranslationResult>();
        LinkedHashMap<String, ArrayList<StringItem>> sameSourceDestMap = new LinkedHashMap<String, ArrayList<StringItem>>();
        HashMap<Integer, TranslationResult> translations = new HashMap<Integer, TranslationResult>();
        int i = 0;
        while (i < words.size()) {
            if (words.get(i).length() >= this.getMaxQuerySize(fromLanguage.get(i), toLanguage.get(i)) - "&q=".length() - 1) {
                throw new Exception(TranslateNLS.GoogleTranslator_Error_QueryTooBig);
            }
            String key = String.valueOf(fromLanguage.get(i)) + "|" + toLanguage.get(i);
            itemsToTranslate = (List)sameSourceDestMap.get(key);
            if (itemsToTranslate == null) {
                itemsToTranslate = new ArrayList<StringItem>();
                sameSourceDestMap.put(key, (ArrayList<StringItem>)itemsToTranslate);
            }
            itemsToTranslate.add(new StringItem(words.get(i), i));
            ++i;
        }
        for (String key : sameSourceDestMap.keySet()) {
            itemsToTranslate = (ArrayList<StringItem>)sameSourceDestMap.get(key);
            ArrayList<String> items = new ArrayList<String>();
            for (StringItem item : itemsToTranslate) {
                items.add(item.getSentence());
            }
            List<TranslationResult> tempResults = this.translate(items, key.split("\\|")[0], key.split("\\|")[1], monitor);
            int i2 = 0;
            while (i2 < itemsToTranslate.size()) {
                translations.put(((StringItem)itemsToTranslate.get(i2)).getOrderNumber(), tempResults.get(i2));
                ++i2;
            }
        }
        i = 0;
        while (i < words.size()) {
            results.add((TranslationResult)translations.get(i));
            ++i;
        }
        return results;
    }

    private int getMaxQuerySize(String fromLanguage, String toLanguage) {
        return 2000 - "https://www.googleapis.com/language/translate/v2?prettyprint=false".length() - "&key=".length() - GoogleTranslator.getApiKey().length() - "&source=".length() - fromLanguage.length() - "&target=".length() - toLanguage.length();
    }

    private List<String> parseTranslationResponse(String httpRequestResponseBody) {
        JSONPair translationSection = this.getTranslationSection(httpRequestResponseBody);
        return this.getTranslations(translationSection);
    }

    private JSONPair getTranslationSection(String httpRequestResponseBody) {
        Jason ripper = new Jason(httpRequestResponseBody);
        JSONPair translationsSection = null;
        Iterator<JSONObject> jsonIterator = ripper.getJSON().iterator();
        while (translationsSection == null && jsonIterator.hasNext()) {
            translationsSection = GoogleTranslator.findPair(jsonIterator.next(), "translations");
        }
        return translationsSection;
    }

    private static JSONPair findPair(JSONValue origin, String name) {
        JSONPair pair = null;
        if (origin instanceof JSONObject) {
            JSONObject object = (JSONObject)origin;
            Iterator pairs = object.getValue().iterator();
            while (pair == null && pairs.hasNext()) {
                JSONPair jsonPair = (JSONPair)pairs.next();
                pair = jsonPair.getName().equals(name) ? jsonPair : GoogleTranslator.findPair(jsonPair.getValue(), name);
            }
        }
        return pair;
    }

    private List<String> getTranslations(JSONPair translationSection) {
        ArrayList<String> translations = new ArrayList<String>();
        if (translationSection.getValue() instanceof JSONArray) {
            JSONArray translationsArray = (JSONArray)translationSection.getValue();
            Iterator iterator = translationsArray.getValue().iterator();
            while (iterator.hasNext()) {
                JSONValue translationObject = (JSONValue)iterator.next();
                translations.add(this.getTranslation(translationObject));
            }
        }
        return translations;
    }

    private String getTranslation(JSONValue translationObject) {
        String translation = null;
        if (translationObject instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)translationObject;
            translation = ((JSONString)((JSONPair)jsonObject.getValue().iterator().next()).getValue()).getValue();
        }
        return translation != null ? GoogleTranslator.fixHTMLTags(translation) : null;
    }

    private URL createTranslationURL(List<String> wordsToTranslate, String fromLanguage, String toLanguage) throws UnsupportedEncodingException {
        URL translationURL = null;
        String regex = "\\\\'";
        Pattern pattern = Pattern.compile(regex);
        StringBuilder urlBuilder = new StringBuilder("https://www.googleapis.com/language/translate/v2?prettyprint=false");
        urlBuilder.append("&key=#API_KEY#&source=#FROM#&target=#TO#".replace("#FROM#", fromLanguage).replace("#TO#", toLanguage).replace("#API_KEY#", GoogleTranslator.getApiKey()));
        for (String word : wordsToTranslate) {
            String wordToTranslate = pattern.matcher(word).replaceAll("'");
            urlBuilder.append("&q=");
            urlBuilder.append(URLEncoder.encode(wordToTranslate, "UTF-8"));
        }
        try {
            translationURL = new URL(urlBuilder.toString());
        }
        catch (MalformedURLException e) {
            AndmoreLogger.error(this.getClass(), (String)"Unable to create translation URL", (Throwable)e);
        }
        return translationURL;
    }

    private static String fixHTMLTags(String originalText) {
        String result = "";
        if (originalText != null) {
            result = originalText;
        }
        result = originalText.replaceAll("</ b>", "</b>");
        result = originalText.replaceAll("</ i>", "</i>");
        result = originalText.replaceAll("</ u>", "</u>");
        result = originalText.replaceAll("</ B>", "</B>");
        result = originalText.replaceAll("</ I>", "</I>");
        result = originalText.replaceAll("</ U>", "</U>");
        result = originalText.replaceAll(" \\\\ n ", " \\\\n ");
        return result;
    }

    protected static String executeHttpGetRequest(URL url) throws HttpException {
        if (url.toString().length() > 2000) {
            throw new HttpException(TranslateNLS.GoogleTranslator_Error_QueryTooBig);
        }
        IProxyService proxyService = ProxyManager.getProxyManager();
        IProxyData proxyData = null;
        if (proxyService.isProxiesEnabled() || proxyService.isSystemProxiesEnabled()) {
            Authenticator.setDefault((Authenticator)new ProxyAuthenticator());
            String urlStr = url.toString();
            if (urlStr.startsWith("https")) {
                proxyData = proxyService.getProxyData("HTTPS");
                AndmoreLogger.debug(GoogleTranslator.class, (String)"Using https proxy");
            } else if (urlStr.startsWith("http")) {
                proxyData = proxyService.getProxyData("HTTP");
                AndmoreLogger.debug(GoogleTranslator.class, (String)"Using http proxy");
            } else {
                AndmoreLogger.debug(GoogleTranslator.class, (String)"Not using any proxy");
            }
        }
        HttpClient client = null;
        client = new HttpClient();
        if (proxyData != null) {
            if (proxyData.getHost() != null) {
                client.getHostConfiguration().setProxy(proxyData.getHost(), proxyData.getPort());
            }
            if (proxyData.getUserId() != null && proxyData.getUserId().trim().length() > 0) {
                UsernamePasswordCredentials cred = new UsernamePasswordCredentials(proxyData.getUserId(), proxyData.getPassword() == null ? "" : proxyData.getPassword());
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)cred);
            }
        }
        GetMethod method = new GetMethod(url.toString());
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        method.setRequestHeader("Referer", "http://developer.motorola.com");
        client.getHttpConnectionManager().getParams().setConnectionTimeout(new Integer(4000).intValue());
        String result = "";
        try {
            int statusCode;
            try {
                statusCode = client.executeMethod((HttpMethod)method);
                result = method.getResponseBodyAsString(100000);
            }
            catch (IOException e) {
                throw new HttpException(String.valueOf(TranslateNLS.GoogleTranslator_Error_CannotConnectToServer) + e.getMessage());
            }
            GoogleTranslator.checkStatusCode(statusCode, result);
            result = GoogleTranslator.unescapeUnicode(result);
            result = GoogleTranslator.unescapeHTML(result);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private static void checkStatusCode(int statusCode, String response) throws HttpException {
        switch (statusCode) {
            case 200: {
                break;
            }
            case 400: {
                throw new HttpException(NLS.bind((String)TranslateNLS.GoogleTranslator_ErrorMessageExecutingRequest, (Object)GoogleTranslator.getErrorMessage(response)));
            }
            case 414: {
                throw new HttpException(TranslateNLS.GoogleTranslator_Error_QueryTooBig);
            }
            case 403: {
                throw new HttpException(NLS.bind((String)TranslateNLS.GoogleTranslator_ErrorMessageNoValidTranslationReturned, (Object)GoogleTranslator.getErrorMessage(response)));
            }
            default: {
                throw new HttpException(NLS.bind((String)TranslateNLS.GoogleTranslator_Error_HTTPRequestError, (Object[])new Object[]{statusCode, GoogleTranslator.getErrorMessage(response)}));
            }
        }
    }

    private static String getErrorMessage(String response) {
        Jason ripper = new Jason(response);
        JSONPair translationsSection = null;
        Iterator<JSONObject> jsonIterator = ripper.getJSON().iterator();
        while (translationsSection == null && jsonIterator.hasNext()) {
            translationsSection = GoogleTranslator.findPair(jsonIterator.next(), "message");
        }
        return translationsSection != null ? ((JSONString)translationsSection.getValue()).getValue() : null;
    }

    private static String unescapeHTML(String source) {
        Pattern p = Pattern.compile("&#([0-9]+);");
        String result = source;
        Matcher m = p.matcher(result);
        while (m.find()) {
            char c = (char)Integer.parseInt(m.group(1));
            result = c == "'".charAt(0) ? result.replaceAll(m.group(0), "\\\\'") : result.replaceAll(m.group(0), "" + c);
        }
        return result;
    }

    private static String unescapeUnicode(String source) {
        int i = 0;
        int len = source.length();
        StringBuffer buffer = new StringBuffer(len);
        while (i < len) {
            char c;
            if ((c = source.charAt(i++)) == '\\' && i < len && (c = source.charAt(i++)) == 'u') {
                c = (char)Integer.parseInt(source.substring(i, i + 4), 16);
                i += 4;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String getApiKey() {
        String apiKey = "ABQIAAAAzLP1ONRdncTVQSc4T1g2MRT7zv61Fj6qXODo5OU8i7eIwTs2GRQjZ2moI_dkzMckcgUZys7M9wAMvQ";
        IPreferenceStore prefStore = TranslationPlugin.getDefault().getPreferenceStore();
        if (!prefStore.isDefault("google.translator.apikey") && (apiKey = prefStore.getString("google.translator.apikey")) == null) {
            apiKey = "ABQIAAAAzLP1ONRdncTVQSc4T1g2MRT7zv61Fj6qXODo5OU8i7eIwTs2GRQjZ2moI_dkzMckcgUZys7M9wAMvQ";
        }
        return apiKey;
    }

    public Composite createCustomArea(Composite parent, final ITranslateDialog dialog) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        final Link prefPageLink = new Link(mainComposite, 0);
        prefPageLink.setText(TranslateNLS.GoogleTranslator_ChangeAPIkeyLabel);
        prefPageLink.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        prefPageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EclipseUtils.openPreference((Shell)prefPageLink.getShell(), (String)"org.eclipse.andmore.android.localization.translators.preferencepage");
                dialog.validate();
            }
        });
        mainComposite.setLayoutData((Object)new GridData(131072, 1024, false, false));
        return mainComposite;
    }

    public String canTranslate(String fromLanguage, String[] toLanguages) {
        return GoogleTranslator.getApiKey() == null || "ABQIAAAAzLP1ONRdncTVQSc4T1g2MRT7zv61Fj6qXODo5OU8i7eIwTs2GRQjZ2moI_dkzMckcgUZys7M9wAMvQ".equals(GoogleTranslator.getApiKey()) ? TranslateNLS.GoogleTranslator_ErrorNoAPIkeySet : null;
    }
}

