/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.json;

import java.util.List;
import org.eclipse.andmore.android.json.JSONValue;

public class JSONString
extends JSONValue {
    private final String value;

    public JSONString(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static JSONValue parseValues(List<Character> json) {
        String value = null;
        boolean parsed = false;
        while (!parsed) {
            Character next = json.get(0);
            if (next.charValue() != '\"') continue;
            value = JSONString.parseName(json);
            parsed = true;
        }
        return new JSONString(value);
    }

    private static String parseName(List<Character> json) {
        String name = null;
        StringBuilder nameBuilder = new StringBuilder();
        boolean specialChar = false;
        json.remove(0);
        while (name == null) {
            Character next = json.remove(0);
            if (next.charValue() == '\"') {
                if (specialChar) {
                    specialChar = false;
                    nameBuilder.append(next);
                    continue;
                }
                name = nameBuilder.toString();
                continue;
            }
            if (next.charValue() == '\\') {
                specialChar = true;
                continue;
            }
            specialChar = false;
            nameBuilder.append(next);
        }
        return name;
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }
}

