/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.json;

import java.util.List;
import org.eclipse.andmore.android.json.JSONValue;
import org.eclipse.andmore.android.json.JSONValueParser;

public class JSONPair {
    private final String name;
    private final JSONValue value;

    public JSONPair(String name, JSONValue value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public JSONValue getValue() {
        return this.value;
    }

    public static JSONPair parse(List<Character> json) {
        String name = null;
        JSONValue value = null;
        boolean parsed = false;
        while (!parsed) {
            Character next = json.get(0);
            if (next.charValue() == '\"') {
                name = JSONPair.parseName(json);
                continue;
            }
            if (next.charValue() == ' ' || next.charValue() == '\r' || next.charValue() == '\n') {
                json.remove(0);
                continue;
            }
            if (next.charValue() != ':') continue;
            json.remove(0);
            value = JSONValueParser.parse(json);
            parsed = true;
        }
        return new JSONPair(name, value);
    }

    private static String parseName(List<Character> json) {
        String name = null;
        StringBuilder nameBuilder = new StringBuilder();
        boolean specialChar = false;
        json.remove(0);
        while (name == null) {
            Character next = json.remove(0);
            if (next.charValue() == '\"') {
                if (specialChar) {
                    specialChar = false;
                    continue;
                }
                name = nameBuilder.toString();
                continue;
            }
            if (next.charValue() == '\\') {
                specialChar = true;
                continue;
            }
            specialChar = false;
            nameBuilder.append(next);
        }
        return name;
    }

    public String toString() {
        return "\"" + this.name + "\":" + this.value.toString();
    }
}

