/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.json;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.andmore.android.json.JSONPair;
import org.eclipse.andmore.android.json.JSONValue;

public class JSONObject
extends JSONValue {
    private final Set<JSONPair> value;

    public JSONObject(Set<JSONPair> value) {
        this.value = value;
    }

    @Override
    public Set<JSONPair> getValue() {
        return this.value;
    }

    static JSONValue parseValues(List<Character> json) {
        Stack<Character> stack = new Stack<Character>();
        HashSet<JSONPair> values = new HashSet<JSONPair>();
        boolean parsed = false;
        while (!parsed) {
            Character next = json.get(0);
            if (next.charValue() == '{') {
                json.remove(0);
                stack.push(Character.valueOf('{'));
                continue;
            }
            if (next.charValue() == '}') {
                json.remove(0);
                if (((Character)stack.pop()).charValue() != '{') {
                    throw new IllegalArgumentException();
                }
                parsed = true;
                continue;
            }
            if (next.charValue() == ' ' || next.charValue() == '\r' || next.charValue() == '\n' || next.charValue() == ',') {
                json.remove(0);
                continue;
            }
            if (next.charValue() != '\"') continue;
            values.add(JSONPair.parse(json));
        }
        return new JSONObject(values);
    }

    public String toString() {
        String string = "{";
        Iterator<JSONPair> objectIterator = this.value.iterator();
        while (objectIterator.hasNext()) {
            string = String.valueOf(string) + objectIterator.next().toString();
            if (!objectIterator.hasNext()) continue;
            string = String.valueOf(string) + ",";
        }
        string = String.valueOf(string) + "}";
        return string;
    }
}

