/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.launch.ILaunchConfigurationConstants;
import org.eclipse.andmore.android.launch.LaunchUtils;
import org.eclipse.andmore.android.launch.i18n.LaunchNLS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;

public class LaunchConfigurationShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        ILaunchConfiguration launchConfiguration = this.getLaunchConfigurationForSelection(selection, true);
        this.handleLaunch(mode, launchConfiguration);
    }

    public void launch(IEditorPart editor, String mode) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            ILaunchConfiguration launchConfiguration = this.getLaunchConfigurationForResource(resource, true);
            this.handleLaunch(mode, launchConfiguration);
        }
    }

    private void handleLaunch(String mode, ILaunchConfiguration launchConfiguration) {
        if (launchConfiguration != null) {
            final ILaunchConfiguration config = launchConfiguration;
            final String launchMode = mode;
            Job job = new Job("Launch Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        config.launch(launchMode, monitor);
                    }
                    catch (CoreException e) {
                        status = new Status(4, "org.eclipse.andmore.android.launch", LaunchNLS.ERR_LaunchConfigurationShortcut_CannotLaunchSelectedResourceMsg, (Throwable)e);
                    }
                    return status;
                }
            };
            job.schedule();
        } else {
            LaunchUtils.showErrorDialog(LaunchNLS.ERR_LaunchConfigurationShortcut_MsgTitle, LaunchNLS.ERR_LaunchConfigurationShortcut_CannotLaunchSelectedResourceMsg);
        }
    }

    private ILaunchConfiguration getLaunchConfigurationForSelection(ISelection selection, boolean create) {
        ILaunchConfiguration config = null;
        IResource selectedResource = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection newSelection = (IStructuredSelection)selection;
            Object selectedObject = newSelection.getFirstElement();
            if (selectedObject instanceof IResource) {
                selectedResource = (IResource)selectedObject;
            } else if (selectedObject instanceof IJavaElement) {
                selectedResource = ((IJavaElement)selectedObject).getResource();
            }
            if (selectedResource != null) {
                config = this.getLaunchConfigurationForResource(selectedResource, create);
            }
        }
        return config;
    }

    private ILaunchConfiguration getLaunchConfigurationForResource(IResource resource, boolean create) {
        Object project;
        ILaunchConfiguration config = null;
        if (resource != null && (config = this.findLaunchConfiguration((IResource)(project = resource.getType() == 4 ? resource : resource.getProject()))) == null && create) {
            IResource app = this.getFirstActivity((IProject)project);
            app = app == null ? resource : app;
            config = this.createLaunchConfiguration(app);
        }
        return config;
    }

    private ILaunchConfiguration findLaunchConfiguration(IResource resource) {
        ILaunchConfiguration launchConfig = null;
        if (resource != null) {
            try {
                List<ILaunchConfiguration> projectLC = this.getProjectLaunchConfigurations(resource.getProject());
                if (!(resource.getType() != 4 && resource.getType() != 1 || projectLC.isEmpty())) {
                    launchConfig = projectLC.iterator().next();
                }
            }
            catch (CoreException e) {
                AndmoreLogger.error(LaunchConfigurationShortcut.class, (String)("Error searching for launch configuration for resource: " + resource.getName()), (Throwable)e);
            }
        }
        return launchConfig;
    }

    protected List<ILaunchConfiguration> getProjectLaunchConfigurations(IProject project) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType andmoreLaunchType = launchManager.getLaunchConfigurationType("androidLaunchConfigurationType");
        ILaunchConfiguration[] andmoreLaunchConfigurations = launchManager.getLaunchConfigurations(andmoreLaunchType);
        ArrayList<ILaunchConfiguration> matches = new ArrayList<ILaunchConfiguration>(andmoreLaunchConfigurations.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = andmoreLaunchConfigurations;
        int n = andmoreLaunchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(project.getName())) {
                matches.add(launchConfiguration);
            }
            ++n2;
        }
        return matches;
    }

    private IResource getFirstActivity(IProject project) {
        IFile app = null;
        String[] allActivities = LaunchUtils.getProjectActivities(project);
        if (allActivities != null && allActivities.length >= 1) {
            app = project.getFile(allActivities[0]);
        }
        return app;
    }

    private ILaunchConfiguration createLaunchConfiguration(IResource resource) {
        ILaunchConfiguration config = null;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType andmoreLaunchType = launchManager.getLaunchConfigurationType("androidLaunchConfigurationType");
        String configBaseName = resource.getName();
        String launchConfigurationName = launchManager.generateLaunchConfigurationName(configBaseName);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = andmoreLaunchType.newInstance(null, launchConfigurationName);
            workingCopy.setAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            workingCopy.setAttribute("org.eclipse.andmore.activity", "");
            workingCopy.setAttribute("org.eclipse.andmore.android.launch.instanceName", null);
            LaunchUtils.setADTLaunchConfigurationDefaults(workingCopy);
            IProject project = resource.getProject();
            String projectName = project.getName();
            workingCopy.setAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
            if (resource.getType() != 4) {
                workingCopy.setAttribute("org.eclipse.andmore.activity", resource.getName());
            }
            String deviceName = this.getSelectedInstanceName(project);
            workingCopy.setAttribute("org.eclipse.andmore.android.launch.instanceName", deviceName);
            Collection validAvds = SdkUtils.getAllValidVmNames();
            if (validAvds.contains(deviceName)) {
                workingCopy.setAttribute("org.eclipse.andmore.avd", deviceName);
            }
            if (workingCopy.getAttribute("org.eclipse.andmore.activity", "").equals("")) {
                workingCopy.setAttribute("org.eclipse.andmore.action", 0);
            }
            config = workingCopy.doSave();
        }
        catch (CoreException e) {
            AndmoreLogger.error(LaunchConfigurationShortcut.class, (String)("Error creating launch configuration for resource: " + resource.getName()), (Throwable)e);
        }
        return config;
    }

    protected String getSelectedInstanceName(IProject project) {
        String selectedDevice = "";
        Collection instances = DevicesManager.getInstance().getAllDevicesSorted();
        String candidate = "";
        for (ISerialNumbered instance : instances) {
            IStatus compatible = LaunchUtils.isCompatible(project, instance);
            if (compatible.isOK()) {
                selectedDevice = instance.getDeviceName();
                break;
            }
            if (compatible.getSeverity() != 2) continue;
            candidate = instance.getDeviceName();
        }
        if (selectedDevice.equals("") && !candidate.equals("")) {
            selectedDevice = candidate;
        }
        return selectedDevice;
    }
}

