/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import com.android.ide.common.xml.XmlFormatStyle;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.resources.ResourceFolderType;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.actions.AddSupportJarAction;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlFormatPreferences;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlPrettyPrinter;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.sdk.AdtManifestMergeCallback;
import org.eclipse.andmore.internal.wizards.templates.CreateFileChange;
import org.eclipse.andmore.internal.wizards.templates.FmActivityToLayoutMethod;
import org.eclipse.andmore.internal.wizards.templates.FmCamelCaseToUnderscoreMethod;
import org.eclipse.andmore.internal.wizards.templates.FmClassNameToResourceMethod;
import org.eclipse.andmore.internal.wizards.templates.FmEscapeXmlStringMethod;
import org.eclipse.andmore.internal.wizards.templates.FmExtractLettersMethod;
import org.eclipse.andmore.internal.wizards.templates.FmLayoutToActivityMethod;
import org.eclipse.andmore.internal.wizards.templates.FmSlashedPackageNameMethod;
import org.eclipse.andmore.internal.wizards.templates.FmUnderscoreToCamelCaseMethod;
import org.eclipse.andmore.internal.wizards.templates.TemplateManager;
import org.eclipse.andmore.internal.wizards.templates.TemplateMetadata;
import org.eclipse.andmore.internal.wizards.templates.TypedVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.Version;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TemplateHandler {
    static final int CURRENT_FORMAT = 4;
    private static final String VALUE_TEMPLATE_DIR = "$TEMPLATEDIR";
    private static final String DATA_ROOT = "root";
    private static final String RESOURCE_ROOT = "resources";
    static final String TEMPLATE_XML = "template.xml";
    static final String TAG_MERGE = "merge";
    static final String TAG_EXECUTE = "execute";
    static final String TAG_GLOBALS = "globals";
    static final String TAG_GLOBAL = "global";
    static final String TAG_PARAMETER = "parameter";
    static final String TAG_COPY = "copy";
    static final String TAG_INSTANTIATE = "instantiate";
    static final String TAG_OPEN = "open";
    static final String TAG_THUMB = "thumb";
    static final String TAG_THUMBS = "thumbs";
    static final String TAG_DEPENDENCY = "dependency";
    static final String TAG_ICONS = "icons";
    static final String TAG_FORMFACTOR = "formfactor";
    static final String TAG_CATEGORY = "category";
    static final String ATTR_FORMAT = "format";
    static final String ATTR_REVISION = "revision";
    static final String ATTR_VALUE = "value";
    static final String ATTR_DEFAULT = "default";
    static final String ATTR_SUGGEST = "suggest";
    static final String ATTR_ID = "id";
    static final String ATTR_NAME = "name";
    static final String ATTR_DESCRIPTION = "description";
    static final String ATTR_TYPE = "type";
    static final String ATTR_HELP = "help";
    static final String ATTR_FILE = "file";
    static final String ATTR_TO = "to";
    static final String ATTR_FROM = "from";
    static final String ATTR_CONSTRAINTS = "constraints";
    static final String ATTR_BACKGROUND = "background";
    static final String ATTR_FOREGROUND = "foreground";
    static final String ATTR_SHAPE = "shape";
    static final String ATTR_TRIM = "trim";
    static final String ATTR_PADDING = "padding";
    static final String ATTR_SOURCE_TYPE = "source";
    static final String ATTR_CLIPART_NAME = "clipartName";
    static final String ATTR_TEXT = "text";
    static final String ATTR_SRC_DIR = "srcDir";
    static final String ATTR_SRC_OUT = "srcOut";
    static final String ATTR_RES_DIR = "resDir";
    static final String ATTR_RES_OUT = "resOut";
    static final String ATTR_MANIFEST_DIR = "manifestDir";
    static final String ATTR_MANIFEST_OUT = "manifestOut";
    static final String ATTR_PROJECT_DIR = "projectDir";
    static final String ATTR_PROJECT_OUT = "projectOut";
    static final String ATTR_MAVEN_URL = "mavenUrl";
    static final String ATTR_DEBUG_KEYSTORE_SHA1 = "debugKeystoreSha1";
    static final String CATEGORY_ACTIVITIES = "activities";
    static final String CATEGORY_PROJECTS = "projects";
    static final String CATEGORY_OTHER = "other";
    static final String MAVEN_SUPPORT_V4 = "support-v4";
    static final String MAVEN_SUPPORT_V13 = "support-v13";
    static final String MAVEN_APPCOMPAT = "appcompat-v7";
    static final int PREVIEW_PADDING = 10;
    static final int PREVIEW_WIDTH = 200;
    private final List<String> mOpen = Lists.newArrayList();
    protected List<Runnable> mFinalizingActions = Lists.newArrayList();
    private final File mRootPath;
    private List<Change> mMergeChanges;
    private List<Change> mTextChanges;
    private List<Change> mOtherChanges;
    private IProject mProject;
    private final MyTemplateLoader mLoader;
    private boolean mYesToAll = false;
    private boolean mNoToAll = false;
    private boolean mBackupMergedFiles = true;
    private TemplateMetadata mTemplate;
    private final TemplateManager mManager;
    public static Exception sMostRecentException;

    static TemplateHandler createFromPath(File rootPath) {
        return new TemplateHandler(rootPath, new TemplateManager());
    }

    static TemplateHandler createFromName(String category, String name) {
        TemplateManager manager = new TemplateManager();
        List<File> templates = manager.getTemplates(category);
        for (File file : templates) {
            if (!file.getName().equals(name) || !category.equals(file.getParentFile().getName())) continue;
            return new TemplateHandler(file, manager);
        }
        return new TemplateHandler(new File(TemplateManager.getTemplateRootFolder(), String.valueOf(category) + File.separator + name), manager);
    }

    private TemplateHandler(File rootPath, TemplateManager manager) {
        this.mRootPath = rootPath;
        this.mManager = manager;
        this.mLoader = new MyTemplateLoader();
        this.mLoader.setPrefix(this.mRootPath.getPath());
    }

    public TemplateManager getManager() {
        return this.mManager;
    }

    public void setBackupMergedFiles(boolean backupMergedFiles) {
        this.mBackupMergedFiles = backupMergedFiles;
    }

    public List<Change> render(IProject project, Map<String, Object> args) {
        this.mOpen.clear();
        this.mProject = project;
        this.mMergeChanges = new ArrayList<Change>();
        this.mTextChanges = new ArrayList<Change>();
        this.mOtherChanges = new ArrayList<Change>();
        Map<String, Object> paramMap = this.createParameterMap(args);
        Configuration freemarker = new Configuration();
        freemarker.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        freemarker.setTemplateLoader((TemplateLoader)this.mLoader);
        this.processVariables(freemarker, TEMPLATE_XML, paramMap);
        ArrayList<Change> changes = new ArrayList<Change>();
        changes.addAll(this.mMergeChanges);
        changes.addAll(this.mTextChanges);
        changes.addAll(this.mOtherChanges);
        return changes;
    }

    Map<String, Object> createParameterMap(Map<String, Object> args) {
        Map<String, Object> paramMap = TemplateHandler.createBuiltinMap();
        paramMap.putAll(args);
        return paramMap;
    }

    static Map<String, Object> createBuiltinMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("slashedPackageName", new FmSlashedPackageNameMethod());
        paramMap.put("camelCaseToUnderscore", new FmCamelCaseToUnderscoreMethod());
        paramMap.put("underscoreToCamelCase", new FmUnderscoreToCamelCaseMethod());
        paramMap.put("activityToLayout", new FmActivityToLayoutMethod());
        paramMap.put("layoutToActivity", new FmLayoutToActivityMethod());
        paramMap.put("classToResource", new FmClassNameToResourceMethod());
        paramMap.put("escapeXmlAttribute", new FmEscapeXmlStringMethod());
        paramMap.put("escapeXmlText", new FmEscapeXmlStringMethod());
        paramMap.put("escapeXmlString", new FmEscapeXmlStringMethod());
        paramMap.put("extractLetters", new FmExtractLettersMethod());
        HashMap<String, String> builtin = new HashMap<String, String>();
        builtin.put("templatesRes", VALUE_TEMPLATE_DIR);
        paramMap.put("android", builtin);
        return paramMap;
    }

    static void addDirectoryParameters(Map<String, Object> parameters, IProject project) {
        IPath srcDir = project.getFile("src").getProjectRelativePath();
        parameters.put(ATTR_SRC_DIR, srcDir.toString());
        IPath resDir = project.getFile("res").getProjectRelativePath();
        parameters.put(ATTR_RES_DIR, resDir.toString());
        IPath manifestDir = project.getProjectRelativePath();
        parameters.put(ATTR_MANIFEST_DIR, manifestDir.toString());
        parameters.put(ATTR_MANIFEST_OUT, manifestDir.toString());
        parameters.put(ATTR_PROJECT_DIR, manifestDir.toString());
        parameters.put(ATTR_PROJECT_OUT, manifestDir.toString());
        parameters.put(ATTR_DEBUG_KEYSTORE_SHA1, "");
    }

    public TemplateMetadata getTemplate() {
        if (this.mTemplate == null) {
            this.mTemplate = this.mManager.getTemplate(this.mRootPath);
        }
        return this.mTemplate;
    }

    public String getResourcePath(String templateName) {
        return new File(this.mRootPath.getPath(), templateName).getPath();
    }

    public String readTemplateTextResource(String relativePath) {
        try {
            return Files.toString((File)new File(this.mRootPath, relativePath.replace('/', File.separatorChar)), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return null;
        }
    }

    public String readTemplateTextResource(File file) {
        assert (file.isAbsolute());
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return null;
        }
    }

    public byte[] readTemplateResource(String relativePath) {
        try {
            return Files.toByteArray((File)new File(this.mRootPath, relativePath));
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return null;
        }
    }

    private void processVariables(final Configuration freemarker, String file, final Map<String, Object> paramMap) {
        try {
            String xml;
            if (file.endsWith(".xml")) {
                xml = this.readTemplateTextResource(file);
                if (xml == null) {
                    return;
                }
            } else {
                this.mLoader.setTemplateFile(new File(this.mRootPath, file));
                Template inputsTemplate = freemarker.getTemplate(file);
                StringWriter out = new StringWriter();
                inputsTemplate.process(paramMap, (Writer)out);
                out.flush();
                xml = out.toString();
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if (TemplateHandler.TAG_PARAMETER.equals(name)) {
                        String id = attributes.getValue(TemplateHandler.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            String type;
                            String value = attributes.getValue(TemplateHandler.ATTR_DEFAULT);
                            Object mapValue = value;
                            if (value != null && !value.isEmpty() && "boolean".equals(type = attributes.getValue(TemplateHandler.ATTR_TYPE))) {
                                mapValue = Boolean.valueOf(value);
                            }
                            paramMap.put(id, mapValue);
                        }
                    } else if (TemplateHandler.TAG_GLOBAL.equals(name)) {
                        String id = attributes.getValue(TemplateHandler.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            paramMap.put(id, TypedVariable.parseGlobal(attributes));
                        }
                    } else if (TemplateHandler.TAG_GLOBALS.equals(name)) {
                        String path = attributes.getValue(TemplateHandler.ATTR_FILE);
                        if (path != null) {
                            TemplateHandler.this.processVariables(freemarker, path, paramMap);
                        }
                    } else if (TemplateHandler.TAG_EXECUTE.equals(name)) {
                        String path = attributes.getValue(TemplateHandler.ATTR_FILE);
                        if (path != null) {
                            TemplateHandler.this.execute(freemarker, path, paramMap);
                        }
                    } else if (TemplateHandler.TAG_DEPENDENCY.equals(name)) {
                        File path;
                        String dependencyName = attributes.getValue(TemplateHandler.ATTR_NAME);
                        if (dependencyName.equals("android-support-v4") && (path = AddSupportJarAction.getSupportJarFile()) != null) {
                            IPath to = TemplateHandler.this.getTargetPath("libs/" + path.getName());
                            try {
                                TemplateHandler.this.copy(path, to);
                            }
                            catch (IOException ioe) {
                                AndmoreAndroidPlugin.log(ioe, null, new Object[0]);
                            }
                        }
                    } else if (!(name.equals("template") || name.equals(TemplateHandler.TAG_CATEGORY) || name.equals(TemplateHandler.TAG_FORMFACTOR) || name.equals("option") || name.equals(TemplateHandler.TAG_THUMBS) || name.equals(TemplateHandler.TAG_THUMB) || name.equals(TemplateHandler.TAG_ICONS))) {
                        System.err.println("WARNING: Unknown template directive " + name);
                    }
                }
            });
        }
        catch (Exception e) {
            sMostRecentException = e;
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
    }

    private boolean canOverwrite(File file) {
        if (file.exists()) {
            if (!this.mYesToAll) {
                MessageDialog dialog = new MessageDialog(null, "File Already Exists", null, String.format("%1$s already exists.\nWould you like to replace it?", file.getPath()), 3, new String[]{"Yes", "No", "Cancel", "Yes to All"}, 0);
                int result = dialog.open();
                switch (result) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        this.mYesToAll = true;
                        break;
                    }
                    case 1: {
                        return false;
                    }
                    case -1: 
                    case 2: {
                        this.mNoToAll = true;
                        return false;
                    }
                }
            }
            if (this.mBackupMergedFiles) {
                return TemplateHandler.makeBackup(file);
            }
            return file.delete();
        }
        return true;
    }

    private void execute(final Configuration freemarker, String file, final Map<String, Object> paramMap) {
        try {
            this.mLoader.setTemplateFile(new File(this.mRootPath, file));
            Template freemarkerTemplate = freemarker.getTemplate(file);
            StringWriter out = new StringWriter();
            freemarkerTemplate.process(paramMap, (Writer)out);
            out.flush();
            String xml = out.toString();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if (TemplateHandler.this.mNoToAll) {
                        return;
                    }
                    try {
                        boolean instantiate = TemplateHandler.TAG_INSTANTIATE.equals(name);
                        if (TemplateHandler.TAG_COPY.equals(name) || instantiate) {
                            String fromPath = attributes.getValue(TemplateHandler.ATTR_FROM);
                            String toPath = attributes.getValue(TemplateHandler.ATTR_TO);
                            if (toPath == null || toPath.isEmpty()) {
                                toPath = attributes.getValue(TemplateHandler.ATTR_FROM);
                                toPath = AdtUtils.stripSuffix(toPath, ".ftl");
                            }
                            IPath to = TemplateHandler.this.getTargetPath(toPath);
                            if (instantiate) {
                                TemplateHandler.this.instantiate(freemarker, paramMap, fromPath, to);
                            } else {
                                TemplateHandler.this.copyTemplateResource(fromPath, to);
                            }
                        } else if (TemplateHandler.TAG_MERGE.equals(name)) {
                            String fromPath = attributes.getValue(TemplateHandler.ATTR_FROM);
                            String toPath = attributes.getValue(TemplateHandler.ATTR_TO);
                            if (toPath == null || toPath.isEmpty()) {
                                toPath = attributes.getValue(TemplateHandler.ATTR_FROM);
                                toPath = AdtUtils.stripSuffix(toPath, ".ftl");
                            }
                            IPath to = TemplateHandler.this.getTargetPath(toPath);
                            TemplateHandler.this.merge(freemarker, paramMap, fromPath, to);
                        } else if (name.equals(TemplateHandler.TAG_OPEN)) {
                            String relativePath = attributes.getValue(TemplateHandler.ATTR_FILE);
                            if (relativePath != null && !relativePath.isEmpty()) {
                                TemplateHandler.this.mOpen.add(relativePath);
                            }
                        } else if (TemplateHandler.TAG_DEPENDENCY.equals(name)) {
                            File path;
                            String dependencyUrl = attributes.getValue(TemplateHandler.ATTR_MAVEN_URL);
                            if (dependencyUrl.contains(TemplateHandler.MAVEN_SUPPORT_V4)) {
                                path = AddSupportJarAction.getSupportJarFile();
                            } else if (dependencyUrl.contains(TemplateHandler.MAVEN_SUPPORT_V13)) {
                                path = AddSupportJarAction.getSupport13JarFile();
                            } else if (dependencyUrl.contains(TemplateHandler.MAVEN_APPCOMPAT)) {
                                path = null;
                                TemplateHandler.this.mFinalizingActions.add(new Runnable(){

                                    @Override
                                    public void run() {
                                        AddSupportJarAction.installAppCompatLibrary(TemplateHandler.this.mProject, true);
                                    }
                                });
                            } else {
                                path = null;
                                System.err.println("WARNING: Unknown dependency type");
                            }
                            if (path != null) {
                                IPath to = TemplateHandler.this.getTargetPath("libs/" + path.getName());
                                try {
                                    TemplateHandler.this.copy(path, to);
                                }
                                catch (IOException ioe) {
                                    AndmoreAndroidPlugin.log(ioe, null, new Object[0]);
                                }
                            }
                        } else if (!name.equals("recipe") && !name.equals(TemplateHandler.TAG_DEPENDENCY)) {
                            System.err.println("WARNING: Unknown template directive " + name);
                        }
                    }
                    catch (Exception e) {
                        sMostRecentException = e;
                        AndmoreAndroidPlugin.log(e, null, new Object[0]);
                    }
                }
            });
        }
        catch (Exception e) {
            sMostRecentException = e;
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
    }

    private File getFullPath(String fromPath) {
        if (fromPath.startsWith(VALUE_TEMPLATE_DIR)) {
            return new File(TemplateManager.getTemplateRootFolder(), RESOURCE_ROOT + File.separator + fromPath.substring(VALUE_TEMPLATE_DIR.length() + 1).replace('/', File.separatorChar));
        }
        return new File(this.mRootPath, DATA_ROOT + File.separator + fromPath);
    }

    private IPath getTargetPath(String relative) {
        if (relative.indexOf(92) != -1) {
            relative = relative.replace('\\', '/');
        }
        return new Path(relative);
    }

    private IFile getTargetFile(IPath path) {
        return this.mProject.getFile(path);
    }

    private void merge(Configuration freemarker, Map<String, Object> paramMap, String relativeFrom, IPath toPath) throws IOException, TemplateException {
        boolean modified;
        boolean ok;
        String currentXml = null;
        IFile to = this.getTargetFile(toPath);
        if (to.exists()) {
            currentXml = AndmoreAndroidPlugin.readFile(to);
        }
        if (currentXml == null) {
            boolean instantiate = relativeFrom.endsWith(".ftl");
            if (instantiate) {
                this.instantiate(freemarker, paramMap, relativeFrom, toPath);
            } else {
                this.copyTemplateResource(relativeFrom, toPath);
            }
            return;
        }
        if (!to.getFileExtension().equals("xml")) {
            throw new RuntimeException("Only XML files can be merged at this point: " + to);
        }
        String xml = null;
        File from = this.getFullPath(relativeFrom);
        if (relativeFrom.endsWith(".ftl")) {
            this.mLoader.setTemplateFile(from);
            Template template = freemarker.getTemplate(from.getName());
            StringWriter out = new StringWriter();
            template.process(paramMap, (Writer)out);
            ((Writer)out).flush();
            xml = ((Object)out).toString();
        } else {
            xml = this.readTemplateTextResource(from);
            if (xml == null) {
                return;
            }
        }
        org.w3c.dom.Document currentDocument = DomUtilities.parseStructuredDocument(currentXml);
        assert (currentDocument != null) : currentXml;
        org.w3c.dom.Document fragment = DomUtilities.parseStructuredDocument(xml);
        assert (fragment != null) : xml;
        XmlFormatStyle formatStyle = XmlFormatStyle.MANIFEST;
        String fileName = to.getName();
        if (fileName.equals("AndroidManifest.xml")) {
            modified = ok = TemplateHandler.mergeManifest(currentDocument, fragment);
        } else {
            String parentFolderName = to.getParent().getName();
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentFolderName);
            formatStyle = folderType != null ? EclipseXmlPrettyPrinter.getForFile(toPath) : XmlFormatStyle.FILE;
            modified = TemplateHandler.mergeResourceFile(currentDocument, fragment, folderType, paramMap);
            ok = true;
        }
        String contents = null;
        if (ok) {
            if (modified) {
                contents = EclipseXmlPrettyPrinter.prettyPrint(currentDocument, EclipseXmlFormatPreferences.create(), formatStyle, null, currentXml.endsWith("\n"));
            }
        } else {
            String sep = SdkUtils.getLineSeparator();
            contents = "<<<<<<< Original" + sep + currentXml + sep + "=======" + sep + xml + ">>>>>>> Added" + sep;
        }
        if (contents != null) {
            TextFileChange change = new TextFileChange("Merge " + fileName, to);
            MultiTextEdit rootEdit = new MultiTextEdit();
            rootEdit.addChild((TextEdit)new ReplaceEdit(0, currentXml.length(), contents));
            change.setEdit((TextEdit)rootEdit);
            change.setTextType("xml");
            this.mMergeChanges.add((Change)change);
        }
    }

    private static boolean mergeResourceFile(org.w3c.dom.Document currentDocument, org.w3c.dom.Document fragment, ResourceFolderType folderType, Map<String, Object> paramMap) {
        boolean modified = false;
        NamedNodeMap attributes = fragment.getDocumentElement().getAttributes();
        if (attributes != null) {
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Attr attribute = (Attr)attributes.item(i);
                if (attribute.getName().startsWith("xmlns:")) {
                    currentDocument.getDocumentElement().setAttribute(attribute.getName(), attribute.getValue());
                }
                ++i;
            }
        }
        Element root = fragment.getDocumentElement();
        NodeList children = root.getChildNodes();
        ArrayList<Node> nodes = new ArrayList<Node>(children.getLength());
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            nodes.add(child);
            root.removeChild(child);
            --i;
        }
        Collections.reverse(nodes);
        root = currentDocument.getDocumentElement();
        if (folderType == ResourceFolderType.VALUES) {
            Element element;
            String name;
            HashMap<String, Element> old = new HashMap<String, Element>();
            NodeList newSiblings = root.getChildNodes();
            int i2 = newSiblings.getLength() - 1;
            while (i2 >= 0) {
                Node child = newSiblings.item(i2);
                if (child.getNodeType() == 1 && (name = TemplateHandler.getResourceId(element = (Element)child)) != null) {
                    old.put(name, element);
                }
                --i2;
            }
            for (Node node : nodes) {
                Node replace;
                if (node.getNodeType() != 1) continue;
                element = (Element)node;
                name = TemplateHandler.getResourceId(element);
                Node node2 = replace = name != null ? (Node)old.get(name) : null;
                if (replace != null) {
                    AndmoreAndroidPlugin.log(null, "Warning: Ignoring name conflict in resource file for name %1$s", name);
                    continue;
                }
                root.appendChild(node);
                modified = true;
            }
        } else {
            for (Node node : nodes) {
                root.appendChild(node);
                modified = true;
            }
        }
        return modified;
    }

    private static boolean mergeManifest(org.w3c.dom.Document currentManifest, org.w3c.dom.Document fragment) {
        Element fragmentRoot = fragment.getDocumentElement();
        Element manifestRoot = currentManifest.getDocumentElement();
        if (fragmentRoot == null || manifestRoot == null) {
            return false;
        }
        String pkg = fragmentRoot.getAttribute("package");
        if ((pkg == null || pkg.isEmpty()) && (pkg = manifestRoot.getAttribute("package")) != null && !pkg.isEmpty()) {
            fragmentRoot.setAttribute("package", pkg);
        }
        ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)AndmoreAndroidPlugin.getDefault()), (ICallback)new AdtManifestMergeCallback()).setExtractPackagePrefix(true);
        return currentManifest != null && fragment != null && merger.process(currentManifest, new org.w3c.dom.Document[]{fragment});
    }

    private static boolean makeBackup(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            return false;
        }
        File backupFile = new File(file.getParentFile(), String.valueOf(file.getName()) + '~');
        if (backupFile.exists()) {
            backupFile.delete();
        }
        return file.renameTo(backupFile);
    }

    private static String getResourceId(Element element) {
        String name = element.getAttribute(ATTR_NAME);
        if (name == null) {
            name = element.getAttribute(ATTR_ID);
        }
        return name;
    }

    private void instantiate(Configuration freemarker, Map<String, Object> paramMap, String relativeFrom, IPath to) throws IOException, TemplateException {
        boolean isDirectory;
        boolean bl = isDirectory = relativeFrom.indexOf(46) == -1;
        if (isDirectory) {
            this.copyTemplateResource(relativeFrom, to);
        } else {
            File from = this.getFullPath(relativeFrom);
            this.mLoader.setTemplateFile(from);
            Template template = freemarker.getTemplate(from.getName());
            StringWriter out = new StringWriter(1024);
            template.process(paramMap, (Writer)out);
            ((Writer)out).flush();
            String contents = ((Object)out).toString();
            contents = TemplateHandler.format(this.mProject, contents, to);
            IFile targetFile = this.getTargetFile(to);
            TextFileChange change = TemplateHandler.createNewFileChange(targetFile);
            MultiTextEdit rootEdit = new MultiTextEdit();
            rootEdit.addChild((TextEdit)new InsertEdit(0, contents));
            change.setEdit((TextEdit)rootEdit);
            this.mTextChanges.add((Change)change);
        }
    }

    private static String format(IProject project, String contents, IPath to) {
        String name = to.lastSegment();
        if (name.endsWith(".xml")) {
            XmlFormatStyle formatStyle = EclipseXmlPrettyPrinter.getForFile(to);
            EclipseXmlFormatPreferences prefs = EclipseXmlFormatPreferences.create();
            return EclipseXmlPrettyPrinter.prettyPrint(contents, prefs, formatStyle, null);
        }
        if (name.endsWith(".java")) {
            Map options = null;
            if (project != null && project.isAccessible()) {
                try {
                    IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
                    if (javaProject != null) {
                        options = javaProject.getOptions(true);
                    }
                }
                catch (CoreException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
            }
            if (options == null) {
                options = JavaCore.getOptions();
            }
            CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)options);
            try {
                Document doc = new Document();
                doc.set(contents);
                TextEdit edit = formatter.format(4104, contents, 0, contents.length(), 0, null);
                if (edit != null) {
                    edit.apply((IDocument)doc);
                }
                return doc.get();
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
        }
        return contents;
    }

    private static TextFileChange createNewFileChange(IFile targetFile) {
        String fileName = targetFile.getName();
        String message = targetFile.exists() ? String.format("Replace %1$s", fileName) : String.format("Create %1$s", fileName);
        TextFileChange change = new TextFileChange(message, targetFile){

            protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
                IDocument document = super.acquireDocument(pm);
                if (document.getLength() > 0) {
                    try {
                        document.replace(0, document.getLength(), "");
                    }
                    catch (BadLocationException badLocationException) {}
                }
                return document;
            }
        };
        change.setTextType(fileName.substring(fileName.lastIndexOf(46) + 1));
        return change;
    }

    public List<String> getFilesToOpen() {
        return this.mOpen;
    }

    public List<Runnable> getFinalizingActions() {
        return this.mFinalizingActions;
    }

    private final void copyTemplateResource(String relativeFrom, IPath output) throws IOException {
        File from = this.getFullPath(relativeFrom);
        this.copy(from, output);
    }

    private static boolean isIdentical(byte[] data, IFile dest) {
        assert (dest.exists());
        byte[] existing = AdtUtils.readData(dest);
        return Arrays.equals(existing, data);
    }

    private void copy(File src, IPath path) throws IOException {
        if (src.isDirectory()) {
            File[] children = src.listFiles();
            if (children != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.copy(child, path.append(child.getName()));
                    ++n2;
                }
            }
        } else {
            IFile dest = this.mProject.getFile(path);
            if (dest.exists() && !(dest instanceof IFile)) {
                assert (false) : dest.getClass().getName();
                return;
            }
            IFile file = dest;
            String targetName = path.lastSegment();
            if (dest instanceof IFile && dest.exists() && TemplateHandler.isIdentical(Files.toByteArray((File)src), file)) {
                String label = String.format("Not overwriting %1$s because the files are identical", targetName);
                NullChange change = new NullChange(label);
                change.setEnabled(false);
                this.mOtherChanges.add((Change)change);
                return;
            }
            if (targetName.endsWith(".xml") || targetName.endsWith(".java") || targetName.endsWith(".txt") || targetName.endsWith(".rs") || targetName.endsWith(".aidl") || targetName.endsWith(".svg")) {
                String newFile = Files.toString((File)src, (Charset)Charsets.UTF_8);
                newFile = TemplateHandler.format(this.mProject, newFile, path);
                TextFileChange addFile = TemplateHandler.createNewFileChange(file);
                addFile.setEdit((TextEdit)new InsertEdit(0, newFile));
                this.mTextChanges.add((Change)addFile);
            } else {
                IPath workspacePath = this.mProject.getFullPath().append(path);
                this.mOtherChanges.add((Change)new CreateFileChange(targetName, workspacePath, src));
            }
        }
    }

    public IStatus validateTemplate(int currentMinSdk, int buildApi) {
        TemplateMetadata template = this.getTemplate();
        if (template == null) {
            return null;
        }
        if (!template.isSupported()) {
            String versionString = (String)AndmoreAndroidPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
            Version version = new Version(versionString);
            return new Status(4, "org.eclipse.andmore", String.format("This template requires a more recent version of the Android Eclipse plugin. Please update from version %1$d.%2$d.%3$d.", version.getMajor(), version.getMinor(), version.getMicro()));
        }
        int templateMinSdk = template.getMinSdk();
        if (templateMinSdk > currentMinSdk && currentMinSdk >= 1) {
            return new Status(4, "org.eclipse.andmore", String.format("This template requires a minimum SDK version of at least %1$d, and the current min version is %2$d", templateMinSdk, currentMinSdk));
        }
        int templateMinBuildApi = template.getMinBuildApi();
        if (templateMinBuildApi > buildApi && buildApi >= 1) {
            return new Status(4, "org.eclipse.andmore", String.format("This template requires a build target API version of at least %1$d, and the current version is %2$d", templateMinBuildApi, buildApi));
        }
        return null;
    }

    private static final class MyTemplateLoader
    implements TemplateLoader {
        private String mPrefix;

        private MyTemplateLoader() {
        }

        public void setPrefix(String prefix) {
            this.mPrefix = prefix;
        }

        public void setTemplateFile(File file) {
            this.setTemplateParent(file.getParentFile());
        }

        public void setTemplateParent(File parent) {
            this.mPrefix = parent.getPath();
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            URL url = (URL)templateSource;
            return new InputStreamReader(url.openStream(), encoding);
        }

        public long getLastModified(Object templateSource) {
            return 0L;
        }

        public Object findTemplateSource(String name) throws IOException {
            String path = this.mPrefix != null ? String.valueOf(this.mPrefix) + '/' + name : name;
            File file = new File(path);
            if (file.exists()) {
                return file.toURI().toURL();
            }
            return null;
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }
    }
}

