/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.internal.assetstudio.ConfigureAssetSetPage;
import org.eclipse.andmore.internal.assetstudio.CreateAssetSetWizardState;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.wizards.templates.StringEvaluator;
import org.eclipse.andmore.internal.wizards.templates.TemplateHandler;
import org.eclipse.andmore.internal.wizards.templates.TemplateManager;
import org.eclipse.andmore.internal.wizards.templates.TemplateMetadata;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;

public class NewTemplateWizardState {
    private TemplateHandler mTemplateHandler;
    public final Map<String, Object> parameters = new HashMap<String, Object>();
    public final Map<String, String> defaults = new HashMap<String, String>();
    public final Set<String> hidden = new HashSet<String>();
    public IProject project;
    public int minSdkLevel;
    private File mTemplateLocation;
    private CreateAssetSetWizardState mIconState;

    public NewTemplateWizardState() {
        this.parameters.put("isNewProject", false);
    }

    TemplateHandler getTemplateHandler() {
        if (this.mTemplateHandler == null) {
            File inputPath = this.mTemplateLocation != null ? this.mTemplateLocation : TemplateManager.getTemplateLocation("activities/BlankActivity");
            this.mTemplateHandler = TemplateHandler.createFromPath(inputPath);
        }
        return this.mTemplateHandler;
    }

    void setTemplateLocation(File file) {
        if (!file.equals(this.mTemplateLocation)) {
            this.mTemplateLocation = file;
            this.mTemplateHandler = null;
        }
    }

    File getTemplateLocation() {
        return this.mTemplateLocation;
    }

    int getMinSdk() {
        if (this.project == null) {
            return -1;
        }
        ManifestInfo manifest = ManifestInfo.get(this.project);
        return manifest.getMinSdkVersion();
    }

    int getBuildApi() {
        if (this.project == null) {
            return -1;
        }
        IAndroidTarget target = Sdk.getCurrent().getTarget(this.project);
        if (target != null) {
            return target.getVersion().getApiLevel();
        }
        return this.getMinSdk();
    }

    List<Change> computeChanges() {
        if (this.project == null) {
            return Collections.emptyList();
        }
        ManifestInfo manifest = ManifestInfo.get(this.project);
        this.parameters.put("packageName", manifest.getPackage());
        this.parameters.put("minApi", manifest.getMinSdkName());
        this.parameters.put("minApiLevel", manifest.getMinSdkVersion());
        this.parameters.put("targetApi", manifest.getTargetSdkVersion());
        this.parameters.put("buildApi", this.getBuildApi());
        this.parameters.put("copyIcons", this.mIconState == null);
        ProjectState projectState = Sdk.getProjectState(this.project);
        this.parameters.put("isLibraryProject", projectState != null ? projectState.isLibrary() : false);
        TemplateHandler.addDirectoryParameters(this.parameters, this.project);
        List<Change> changes = this.getTemplateHandler().render(this.project, this.parameters);
        if (this.mIconState != null) {
            String title = String.format("Generate icons (res/drawable-<density>/%1$s.png)", this.mIconState.outputName);
            changes.add((Change)new NullChange(title){

                public Change perform(IProgressMonitor pm) throws CoreException {
                    ConfigureAssetSetPage.generateIcons(((NewTemplateWizardState)NewTemplateWizardState.this).mIconState.project, NewTemplateWizardState.this.mIconState, false, null);
                    return null;
                }
            });
        }
        return changes;
    }

    CreateAssetSetWizardState getIconState() {
        TemplateMetadata template;
        TemplateHandler handler;
        if (this.mIconState == null && (handler = this.getTemplateHandler()) != null && (template = handler.getTemplate()) != null) {
            this.mIconState = template.getIconState(this.project);
        }
        return this.mIconState;
    }

    public void updateIconState(StringEvaluator evaluator) {
        TemplateMetadata template = this.getTemplateHandler().getTemplate();
        if (template != null) {
            if (evaluator == null) {
                evaluator = new StringEvaluator();
            }
            template.updateIconName(template.getParameters(), evaluator);
        }
    }
}

