/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class CreateFileChange
extends ResourceChange {
    private String mName;
    private final IPath mPath;
    private final File mSource;

    CreateFileChange(String name, IPath workspacePath, File source) {
        this.mName = name;
        this.mPath = workspacePath;
        this.mSource = source;
    }

    protected IResource getModifiedResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.mPath);
    }

    public String getName() {
        return this.mName;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.mPath);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError("Unknown location " + file.getFullPath().toString());
            return result;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        block6: {
            InputSupplier supplier = Files.newInputStreamSupplier((File)this.mSource);
            InputStream is = null;
            try {
                try {
                    pm.beginTask("Creating file", 3);
                    IFile file = (IFile)this.getModifiedResource();
                    IContainer parent = file.getParent();
                    if (parent != null && !parent.exists()) {
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(parent.getFullPath());
                        AdtUtils.ensureExists((IContainer)folder);
                    }
                    is = (InputStream)supplier.getInput();
                    file.create(is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    pm.worked(1);
                }
                catch (Exception ioe) {
                    AndmoreAndroidPlugin.log(ioe, null, new Object[0]);
                    Closeables.closeQuietly(is);
                    pm.done();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(is);
                pm.done();
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)is);
            pm.done();
        }
        return null;
    }
}

