/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.newproject;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;

public class WorkingSetGroup {
    private WorkingSetConfigurationBlock fWorkingSetBlock;
    private Button mEnableButton;

    public WorkingSetGroup() {
        String[] workingSetIds = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
        this.fWorkingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, JavaPlugin.getDefault().getDialogSettings());
    }

    public Composite createControl(Composite composite) {
        Group workingSetGroup = new Group(composite, 0);
        workingSetGroup.setFont(composite.getFont());
        workingSetGroup.setText(NewWizardMessages.NewJavaProjectWizardPageOne_WorkingSets_group);
        workingSetGroup.setLayout((Layout)new GridLayout(1, false));
        this.fWorkingSetBlock.createContent((Composite)workingSetGroup);
        this.mEnableButton = this.findCheckbox((Composite)workingSetGroup);
        return workingSetGroup;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.fWorkingSetBlock.setWorkingSets(workingSets);
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        try {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
        catch (Throwable throwable) {
            return new IWorkingSet[0];
        }
    }

    public boolean isChecked() {
        return this.mEnableButton == null ? false : this.mEnableButton.getSelection();
    }

    public void setChecked(boolean state) {
        if (this.mEnableButton != null) {
            this.mEnableButton.setSelection(state);
        }
    }

    private Button findCheckbox(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button found;
            Control control = controlArray[n2];
            if (control instanceof Button && (control.getStyle() & 0x20) == 32) {
                return (Button)control;
            }
            if (control instanceof Composite && (found = this.findCheckbox((Composite)control)) != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }
}

