/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.newproject;

import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import java.io.File;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.wizards.newproject.NewProjectWizardState;
import org.eclipse.andmore.internal.wizards.newproject.ProjectNamePage;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

class SampleSelectionPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private final NewProjectWizardState mValues;
    private boolean mIgnore;
    private Table mTable;
    private TableViewer mTableViewer;
    private IAndroidTarget mCurrentSamplesTarget;
    private Text mSampleProjectName;

    SampleSelectionPage(NewProjectWizardState values) {
        super("samplePage");
        this.setTitle("Select Sample");
        this.setDescription("Select which sample to create");
        this.mValues = values;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.mTableViewer = new TableViewer(container, 67584);
        this.mTable = this.mTableViewer.getTable();
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 300;
        this.mTable.setLayoutData((Object)gridData);
        this.mTable.addSelectionListener((SelectionListener)this);
        this.setControl((Control)container);
        Label projectLabel = new Label(container, 0);
        projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        projectLabel.setText("Project Name:");
        this.mSampleProjectName = new Text(container, 2048);
        this.mSampleProjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mSampleProjectName.addModifyListener((ModifyListener)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.mValues.projectName != null) {
                try {
                    this.mIgnore = true;
                    this.mSampleProjectName.setText(this.mValues.projectName);
                }
                finally {
                    this.mIgnore = false;
                }
            }
            if (this.mCurrentSamplesTarget != this.mValues.target) {
                this.mCurrentSamplesTarget = this.mValues.target;
                this.updateSamples();
            }
            this.validatePage();
        }
    }

    private void updateSamples() {
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return AndmoreAndroidPlugin.getAndroidLogo();
            }

            public String getText(Object element) {
                if (element instanceof Pair) {
                    Object name = ((Pair)element).getFirst();
                    return name.toString();
                }
                return element.toString();
            }
        };
        this.mTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (this.mValues.samples != null && this.mValues.samples.size() > 0) {
            Object[] samples = this.mValues.samples.toArray();
            this.mTableViewer.setInput((Object)samples);
            this.mTable.select(0);
            this.selectSample((File)this.mValues.samples.get(0).getSecond());
            this.extractNamesFromAndroidManifest();
        }
    }

    private void selectSample(File sample) {
        this.mValues.chosenSample = sample;
        if (sample != null && !this.mValues.projectNameModifiedByUser) {
            this.mValues.projectName = sample.getName();
            if ("sample".equals(this.mValues.projectName) && sample.getParentFile() != null) {
                this.mValues.projectName = String.valueOf(sample.getParentFile().getName()) + '_' + this.mValues.projectName;
            }
            try {
                this.mIgnore = true;
                this.mSampleProjectName.setText(this.mValues.projectName);
            }
            finally {
                this.mIgnore = false;
            }
            this.updatedProjectName();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        if (e.getSource() == this.mTable) {
            this.extractNamesFromAndroidManifest();
            int index = this.mTable.getSelectionIndex();
            if (index >= 0) {
                Object[] roots = (Object[])this.mTableViewer.getInput();
                this.selectSample((File)((Pair)roots[index]).getSecond());
            } else {
                this.selectSample(null);
            }
        } else assert (false) : e.getSource();
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        if (e.getSource() == this.mSampleProjectName) {
            this.mValues.projectName = this.mSampleProjectName.getText().trim();
            this.mValues.projectNameModifiedByUser = true;
            this.updatedProjectName();
        }
        this.validatePage();
    }

    private void updatedProjectName() {
        if (this.mValues.useDefaultLocation) {
            this.mValues.projectLocation = Platform.getLocation().toFile();
        }
    }

    private void extractNamesFromAndroidManifest() {
        if (this.mValues.chosenSample == null || !this.mValues.chosenSample.isDirectory()) {
            return;
        }
        Path path = new Path(this.mValues.chosenSample.getPath());
        this.mValues.extractFromAndroidManifest(path);
    }

    public boolean isPageComplete() {
        if (this.mValues.mode != NewProjectWizardState.Mode.SAMPLE) {
            return true;
        }
        if (this.mValues.chosenSample == null) {
            return false;
        }
        return super.isPageComplete();
    }

    private void validatePage() {
        Object status = null;
        status = this.mValues.samples == null || this.mValues.samples.size() == 0 ? new Status(4, "org.eclipse.andmore", "The chosen SDK does not contain any samples") : (this.mValues.chosenSample == null ? new Status(4, "org.eclipse.andmore", "Choose a sample") : (!this.mValues.chosenSample.exists() ? new Status(4, "org.eclipse.andmore", String.format("Sample does not exist: %1$s", this.mValues.chosenSample.getPath())) : ProjectNamePage.validateProjectName(this.mValues.projectName)));
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }
}

