/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.newproject;

import com.android.SdkConstants;
import java.io.File;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.wizards.newproject.ApplicationInfoPage;
import org.eclipse.andmore.internal.wizards.newproject.NewProjectCreator;
import org.eclipse.andmore.internal.wizards.newproject.NewProjectWizardState;
import org.eclipse.andmore.internal.wizards.newproject.ProjectNamePage;
import org.eclipse.andmore.internal.wizards.newproject.SampleSelectionPage;
import org.eclipse.andmore.internal.wizards.newproject.SdkSelectionPage;
import org.eclipse.andmore.internal.wizards.newproject.TestTargetPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    private static final String PROJECT_LOGO_LARGE = "icons/android-64.png";
    private NewProjectWizardState mValues;
    private ProjectNamePage mNamePage;
    private SdkSelectionPage mSdkPage;
    private SampleSelectionPage mSamplePage;
    private ApplicationInfoPage mPropertiesPage;
    private final NewProjectWizardState.Mode mMode;
    private IStructuredSelection mSelection;

    public NewProjectWizard() {
        this(NewProjectWizardState.Mode.ANY);
    }

    protected NewProjectWizard(NewProjectWizardState.Mode mode) {
        this.mMode = mode;
        switch (this.mMode) {
            case SAMPLE: {
                this.setWindowTitle("New Android Sample Project");
                break;
            }
            case TEST: {
                this.setWindowTitle("New Android Test Project");
                break;
            }
            default: {
                this.setWindowTitle("New Android Project");
            }
        }
    }

    public void addPages() {
        this.mValues = new NewProjectWizardState(this.mMode);
        if (this.mMode != NewProjectWizardState.Mode.SAMPLE) {
            this.mNamePage = new ProjectNamePage(this.mValues);
            if (this.mSelection != null) {
                this.mNamePage.init(this.mSelection, AdtUtils.getActivePart());
            }
            this.addPage((IWizardPage)this.mNamePage);
        }
        if (this.mMode == NewProjectWizardState.Mode.TEST) {
            this.addPage((IWizardPage)new TestTargetPage(this.mValues));
        }
        this.mSdkPage = new SdkSelectionPage(this.mValues);
        this.addPage((IWizardPage)this.mSdkPage);
        if (this.mMode != NewProjectWizardState.Mode.TEST) {
            this.mSamplePage = new SampleSelectionPage(this.mValues);
            this.addPage((IWizardPage)this.mSamplePage);
        }
        if (this.mMode != NewProjectWizardState.Mode.SAMPLE) {
            this.mPropertiesPage = new ApplicationInfoPage(this.mValues);
            this.addPage((IWizardPage)this.mPropertiesPage);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mSelection = selection;
        this.setHelpAvailable(false);
        ImageDescriptor desc = AndmoreAndroidPlugin.getImageDescriptor(PROJECT_LOGO_LARGE);
        this.setDefaultPageImageDescriptor(desc);
        AndmoreAndroidPlugin.getDefault().refreshSdk();
    }

    public boolean performFinish() {
        File file = new File(AndmoreAndroidPlugin.getOsSdkFolder(), String.valueOf(SdkConstants.OS_SDK_TOOLS_LIB_FOLDER) + File.separator + "proguard-project.txt");
        if (!file.exists()) {
            AndmoreAndroidPlugin.displayError("Tools Out of Date?", String.format("It looks like you do not have the latest version of the SDK Tools installed. Make sure you update via the SDK Manager first. (Could not find %1$s)", file.getPath()));
            return false;
        }
        NewProjectCreator creator = new NewProjectCreator(this.mValues, (IRunnableContext)this.getContainer());
        if (!creator.createAndroidProjects()) {
            return false;
        }
        this.updatePerspective();
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mNamePage) {
            if (this.mValues.mode != NewProjectWizardState.Mode.TEST) {
                return this.mSdkPage;
            }
        } else {
            if (page == this.mSdkPage) {
                if (this.mValues.mode == NewProjectWizardState.Mode.SAMPLE) {
                    return this.mSamplePage;
                }
                if (this.mValues.mode != NewProjectWizardState.Mode.TEST) {
                    return this.mPropertiesPage;
                }
                return null;
            }
            if (page == this.mSamplePage) {
                return null;
            }
        }
        return super.getNextPage(page);
    }

    public String getPackageName() {
        return this.mValues.packageName;
    }
}

