/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.export;

import java.util.List;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.wizards.export.ExportWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class KeyCreationPage
extends ExportWizard.ExportWizardPage {
    private final ExportWizard mWizard;
    private Text mAlias;
    private Text mKeyPassword;
    private Text mKeyPassword2;
    private Text mCnField;
    private boolean mDisableOnChange = false;
    private Text mOuField;
    private Text mOField;
    private Text mLField;
    private Text mStField;
    private Text mCField;
    private String mDName;
    private int mValidity = 0;
    private List<String> mExistingAliases;

    protected KeyCreationPage(ExportWizard wizard, String pageName) {
        super(pageName);
        this.mWizard = wizard;
        this.setTitle("Key Creation");
        this.setDescription("");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        new Label(composite, 0).setText("Alias:");
        this.mAlias = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.mAlias.setLayoutData((Object)gd);
        new Label(composite, 0).setText("Password:");
        this.mKeyPassword = new Text(composite, 0x400800);
        gd = new GridData(768);
        this.mKeyPassword.setLayoutData((Object)gd);
        this.mKeyPassword.addVerifyListener(sPasswordVerifier);
        new Label(composite, 0).setText("Confirm:");
        this.mKeyPassword2 = new Text(composite, 0x400800);
        gd = new GridData(768);
        this.mKeyPassword2.setLayoutData((Object)gd);
        this.mKeyPassword2.addVerifyListener(sPasswordVerifier);
        new Label(composite, 0).setText("Validity (years):");
        final Text validityText = new Text(composite, 2048);
        gd = new GridData(768);
        validityText.setLayoutData((Object)gd);
        validityText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i = 0;
                while (i < e.text.length()) {
                    char letter = e.text.charAt(i);
                    if (letter < '0' || letter > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        gd = new GridData(768);
        new Label(composite, 258).setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        new Label(composite, 0).setText("First and Last Name:");
        this.mCnField = new Text(composite, 2048);
        gd = new GridData(768);
        this.mCnField.setLayoutData((Object)gd);
        new Label(composite, 0).setText("Organizational Unit:");
        this.mOuField = new Text(composite, 2048);
        gd = new GridData(768);
        this.mOuField.setLayoutData((Object)gd);
        new Label(composite, 0).setText("Organization:");
        this.mOField = new Text(composite, 2048);
        gd = new GridData(768);
        this.mOField.setLayoutData((Object)gd);
        new Label(composite, 0).setText("City or Locality:");
        this.mLField = new Text(composite, 2048);
        gd = new GridData(768);
        this.mLField.setLayoutData((Object)gd);
        new Label(composite, 0).setText("State or Province:");
        this.mStField = new Text(composite, 2048);
        gd = new GridData(768);
        this.mStField.setLayoutData((Object)gd);
        new Label(composite, 0).setText("Country Code (XX):");
        this.mCField = new Text(composite, 2048);
        gd = new GridData(768);
        this.mCField.setLayoutData((Object)gd);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.mAlias.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyCreationPage.this.mWizard.setKeyAlias(KeyCreationPage.this.mAlias.getText().trim());
                KeyCreationPage.this.onChange();
            }
        });
        this.mKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyCreationPage.this.mWizard.setKeyPassword(KeyCreationPage.this.mKeyPassword.getText());
                KeyCreationPage.this.onChange();
            }
        });
        this.mKeyPassword2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyCreationPage.this.onChange();
            }
        });
        validityText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    KeyCreationPage.this.mValidity = Integer.parseInt(validityText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    KeyCreationPage.this.mValidity = 0;
                }
                KeyCreationPage.this.mWizard.setValidity(KeyCreationPage.this.mValidity);
                KeyCreationPage.this.onChange();
            }
        });
        ModifyListener dNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyCreationPage.this.onDNameChange();
            }
        };
        this.mCnField.addModifyListener(dNameListener);
        this.mOuField.addModifyListener(dNameListener);
        this.mOField.addModifyListener(dNameListener);
        this.mLField.addModifyListener(dNameListener);
        this.mStField.addModifyListener(dNameListener);
        this.mCField.addModifyListener(dNameListener);
    }

    @Override
    void onShow() {
        if ((this.mProjectDataChanged & 3) != 0) {
            IProject project = this.mWizard.getProject();
            this.mDisableOnChange = true;
            String alias = ProjectHelper.loadStringProperty((IResource)project, "alias");
            if (alias != null) {
                this.mAlias.setText(alias);
            }
            this.mExistingAliases = this.mWizard.getKeyCreationMode() ? this.mWizard.getExistingAliases() : null;
            this.mKeyPassword.setText("");
            this.mKeyPassword2.setText("");
            this.mDisableOnChange = false;
            this.onChange();
        }
    }

    public IWizardPage getPreviousPage() {
        if (this.mWizard.getKeyCreationMode()) {
            return this.mWizard.getKeySelectionPage();
        }
        return this.mWizard.getKeystoreSelectionPage();
    }

    public IWizardPage getNextPage() {
        return this.mWizard.getKeyCheckPage();
    }

    private void onChange() {
        String value;
        if (this.mDisableOnChange) {
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.mAlias.getText().trim().length() == 0) {
            this.setErrorMessage("Enter key alias.");
            this.setPageComplete(false);
            return;
        }
        if (this.mExistingAliases != null) {
            String keyAlias = this.mAlias.getText().trim();
            for (String alias : this.mExistingAliases) {
                if (!alias.equalsIgnoreCase(keyAlias)) continue;
                this.setErrorMessage("Key alias already exists in keystore.");
                this.setPageComplete(false);
                return;
            }
        }
        if ((value = this.mKeyPassword.getText()).length() == 0) {
            this.setErrorMessage("Enter key password.");
            this.setPageComplete(false);
            return;
        }
        if (value.length() < 6) {
            this.setErrorMessage("Key password is too short - must be at least 6 characters.");
            this.setPageComplete(false);
            return;
        }
        if (!value.equals(this.mKeyPassword2.getText())) {
            this.setErrorMessage("Key passwords don't match.");
            this.setPageComplete(false);
            return;
        }
        if (this.mValidity == 0) {
            this.setErrorMessage("Key certificate validity is required.");
            this.setPageComplete(false);
            return;
        }
        if (this.mValidity < 25) {
            this.setMessage("A 25 year certificate validity is recommended.", 2);
        } else if (this.mValidity > 1000) {
            this.setErrorMessage("Key certificate validity must be between 1 and 1000 years.");
            this.setPageComplete(false);
            return;
        }
        if (this.mDName == null || this.mDName.length() == 0) {
            this.setErrorMessage("At least one Certificate issuer field is required to be non-empty.");
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    private void onDNameChange() {
        StringBuilder sb = new StringBuilder();
        this.buildDName("CN", this.mCnField, sb);
        this.buildDName("OU", this.mOuField, sb);
        this.buildDName("O", this.mOField, sb);
        this.buildDName("L", this.mLField, sb);
        this.buildDName("ST", this.mStField, sb);
        this.buildDName("C", this.mCField, sb);
        this.mDName = sb.toString();
        this.mWizard.setDName(this.mDName);
        this.onChange();
    }

    private void buildDName(String prefix, Text textField, StringBuilder sb) {
        String value;
        if (textField != null && (value = textField.getText().trim()).length() > 0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(prefix);
            sb.append('=');
            sb.append(value);
        }
    }
}

