/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.ui;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.ImageControl;
import org.eclipse.andmore.internal.editors.layout.gle2.ImageUtils;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderService;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtUtils;
import org.eclipse.andmore.internal.resources.ResourceHelper;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResourcePreviewHelper {
    private static final int WIDTH = 100;
    private static final int HEIGHT = 100;
    private final GraphicalEditorPart mEditor;
    private final TrayDialog mTrayDialog;
    private boolean mShowingPreview;
    private DialogTray mPreviewTray;
    private ImageControl mPreviewImageControl;

    public ResourcePreviewHelper(TrayDialog trayDialog, GraphicalEditorPart editor) {
        this.mTrayDialog = trayDialog;
        this.mEditor = editor;
    }

    public void updatePreview(ResourceType type, String resource) {
        boolean showPreview;
        boolean bl = showPreview = type == ResourceType.DRAWABLE || type == ResourceType.COLOR;
        if (showPreview) {
            BufferedImage image;
            block17: {
                if (this.mPreviewTray == null) {
                    this.mPreviewTray = new DialogTray(){

                        protected Control createContents(Composite parent) {
                            Composite panel = new Composite(parent, 0);
                            panel.setLayout((Layout)new GridLayout(3, false));
                            Label dummy1 = new Label(panel, 0);
                            dummy1.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
                            ResourcePreviewHelper.this.mPreviewImageControl = new ImageControl(panel, 0, SwtUtils.createEmptyImage(parent.getDisplay(), 100, 100));
                            GridData gd = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
                            gd.widthHint = 100;
                            gd.heightHint = 100;
                            ResourcePreviewHelper.this.mPreviewImageControl.setLayoutData(gd);
                            Label dummy2 = new Label(panel, 0);
                            dummy2.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
                            return panel;
                        }
                    };
                }
                if (!this.mShowingPreview) {
                    this.mTrayDialog.openTray(this.mPreviewTray);
                }
                image = null;
                try {
                    File file;
                    ResourceResolver resources;
                    if (type == ResourceType.COLOR) {
                        RGB color;
                        resources = this.mEditor.getResourceResolver();
                        ResourceValue value = resources.findResValue(resource, false);
                        if (value != null && (color = ResourceHelper.resolveColor(resources, value)) != null) {
                            image = ImageUtils.createColoredImage(100, 100, color);
                        }
                        break block17;
                    }
                    assert (type == ResourceType.DRAWABLE);
                    resources = this.mEditor.getResourceResolver();
                    ResourceValue drawable = resources.findResValue(resource, false);
                    if (drawable == null) break block17;
                    String path = drawable.getValue();
                    if (ImageUtils.hasImageExtension(path) && !SdkUtils.endsWithIgnoreCase((String)path, (String)".9.png") && (file = new File(path)).exists()) {
                        try {
                            image = ImageIO.read(file);
                            int width = image.getWidth();
                            int height = image.getHeight();
                            if (width > 100 || height > 100) {
                                double xScale = 100.0 / (double)width;
                                double yScale = 100.0 / (double)height;
                                double scale = Math.min(xScale, yScale);
                                image = ImageUtils.scale(image, scale, scale);
                            }
                        }
                        catch (IOException e) {
                            AndmoreAndroidPlugin.log(e, "Can't read preview image %1$s", path);
                        }
                    }
                    if (image == null) {
                        RenderService renderService = RenderService.create(this.mEditor);
                        renderService.setOverrideRenderSize(100, 100);
                        image = renderService.renderDrawable(drawable);
                    }
                }
                catch (Throwable throwable) {
                    AndmoreAndroidPlugin.log(2, "Can't generate preview for %1$s", resource);
                }
            }
            Display display = this.mEditor.getSite().getShell().getDisplay();
            if (image != null) {
                this.mPreviewImageControl.setImage(SwtUtils.convertToSwt((Device)display, image, true, -1));
            } else {
                this.mPreviewImageControl.setImage(SwtUtils.createEmptyImage(display, 100, 100));
            }
            this.mPreviewImageControl.redraw();
        } else if (this.mPreviewTray != null && this.mShowingPreview) {
            this.mTrayDialog.closeTray();
        }
        this.mShowingPreview = showPreview;
    }
}

