/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.sourcelookup;

import com.android.sdklib.IAndroidTarget;
import java.io.File;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class AdtSourceLookupDirector
extends JavaSourceLookupDirector {
    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        this.dispose();
        this.setLaunchConfiguration(configuration);
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        if (projectName != null && projectName.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.isOpen()) {
            ProjectState state = Sdk.getProjectState(project);
            if (state == null) {
                this.initDefaults();
                return;
            }
            IAndroidTarget target = state.getTarget();
            if (target == null) {
                this.initDefaults();
                return;
            }
            String path = target.getPath(1);
            if (path == null) {
                this.initDefaults();
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null && javaProject.isOpen()) {
                String androidSrc;
                IPath sourceAttachmentPath;
                IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
                IClasspathEntry androidEntry = null;
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && path.equals(entry.getPath().toString())) {
                        androidEntry = entry;
                        break;
                    }
                    ++i;
                }
                if (androidEntry != null && (sourceAttachmentPath = androidEntry.getSourceAttachmentPath()) != null && (androidSrc = sourceAttachmentPath.toString()) != null && androidSrc.trim().length() > 0) {
                    File srcFile = new File(androidSrc);
                    ExternalArchiveSourceContainer adtContainer = null;
                    if (srcFile.isFile()) {
                        adtContainer = new ExternalArchiveSourceContainer(androidSrc, true);
                    }
                    if (srcFile.isDirectory()) {
                        adtContainer = new DirectorySourceContainer(srcFile, false);
                    }
                    if (adtContainer != null) {
                        DefaultSourceContainer defaultContainer = new DefaultSourceContainer();
                        this.setSourceContainers(new ISourceContainer[]{adtContainer, defaultContainer});
                        this.initializeParticipants();
                        return;
                    }
                }
            }
        }
        this.initDefaults();
    }

    private void initDefaults() {
        this.setSourceContainers(new ISourceContainer[]{new DefaultSourceContainer()});
        this.initializeParticipants();
    }
}

