/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.IDevice;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.sdk.LoadStatus;
import com.android.io.StreamException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.utils.ILogger;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.DexWrapper;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.LibraryClasspathContainerInitializer;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.resources.manager.GlobalProjectMonitor;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.AndroidTargetParser;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class Sdk {
    private static final boolean DEBUG = false;
    private static final Object LOCK = new Object();
    private static Sdk sCurrentSdk = null;
    private static final HashMap<IProject, ProjectState> sProjectStateMap = new HashMap();
    private final SdkManager mManager;
    private final Map<String, DexWrapper> mDexWrappers = Maps.newHashMap();
    private final AvdManager mAvdManager;
    private final DeviceManager mDeviceManager;
    private final HashMap<IAndroidTarget, AndroidTargetData> mTargetDataMap = new HashMap();
    private final HashMap<IAndroidTarget, TargetLoadBundle> mTargetDataStatusMap = new HashMap();
    private boolean mDontLoadTargetData = false;
    private final String mDocBaseUrl;
    private GlobalProjectMonitor.IProjectListener mProjectListener = new GlobalProjectMonitor.IProjectListener(){

        @Override
        public void projectClosed(IProject project) {
            this.onProjectRemoved(project, false);
        }

        @Override
        public void projectDeleted(IProject project) {
            this.onProjectRemoved(project, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onProjectRemoved(IProject removedProject, boolean deleted) {
            Object object = LOCK;
            synchronized (object) {
                ProjectState removedState = (ProjectState)sProjectStateMap.get(removedProject);
                if (removedState != null) {
                    LayoutLibrary layoutLib;
                    AndroidTargetData data;
                    IAndroidTarget target = removedState.getTarget();
                    if (target != null && (data = (AndroidTargetData)Sdk.this.mTargetDataMap.get(target)) != null && (layoutLib = data.getLayoutLibrary()) != null && layoutLib.getStatus() == LoadStatus.LOADED) {
                        layoutLib.clearCaches((Object)removedProject);
                    }
                    for (ProjectState projectState : sProjectStateMap.values()) {
                        ProjectState.LibraryState libState = projectState.getLibrary(removedProject);
                        if (libState == null) continue;
                        libState.close();
                        Sdk.this.markProject(projectState, projectState.isLibrary());
                    }
                    sProjectStateMap.remove(removedProject);
                }
            }
        }

        @Override
        public void projectOpened(IProject project) {
            this.onProjectOpened(project);
        }

        @Override
        public void projectOpenedWithWorkspace(IProject project) {
            this.onProjectOpened(project);
        }

        @Override
        public void allProjectsOpenedWithWorkspace() {
            Sdk.this.fixOpenLegacyEditors();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onProjectOpened(final IProject openedProject) {
            ProjectState openedState = Sdk.getProjectState(openedProject);
            if (openedState != null) {
                Object object = LOCK;
                synchronized (object) {
                    boolean isLibrary = openedState.isLibrary();
                    boolean hasLibraries = openedState.hasLibraries();
                    if (isLibrary || hasLibraries) {
                        boolean foundLibraries = false;
                        for (ProjectState projectState : sProjectStateMap.values()) {
                            ProjectState.LibraryState libState;
                            if (projectState == openedState) continue;
                            if (hasLibraries && (libState = openedState.needs(projectState)) != null) {
                                foundLibraries = true;
                            }
                            if (!isLibrary || (libState = projectState.needs(openedState)) == null) continue;
                            Sdk.this.markProject(projectState, projectState.isLibrary());
                        }
                        if (foundLibraries) {
                            Sdk.this.markProject(openedState, false);
                        }
                    }
                }
                Sdk.this.fixEditorAssociations(openedProject);
                Job fixCpeJob = new Job("Adjusting Android Project Classpath"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ProjectHelper.fixProjectClasspathEntries(JavaCore.create((IProject)openedProject));
                        }
                        catch (JavaModelException e) {
                            AndmoreAndroidPlugin.log(e, "error fixing classpath entries", new Object[0]);
                        }
                        return Status.OK_STATUS;
                    }
                };
                fixCpeJob.setPriority(40);
                fixCpeJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                fixCpeJob.schedule();
            }
        }

        @Override
        public void projectRenamed(IProject project, IPath from) {
        }
    };
    private GlobalProjectMonitor.IFileListener mFileListener = new GlobalProjectMonitor.IFileListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileChanged(IFile file, IMarkerDelta[] markerDeltas, int kind, String extension, int flags, boolean isAndroidPRoject) {
            if (!isAndroidPRoject) {
                return;
            }
            if ("project.properties".equals(file.getName()) && file.getParent() == file.getProject()) {
                try {
                    IProject iProject = file.getProject();
                    ProjectState state = Sdk.getProjectState(iProject);
                    IAndroidTarget oldTarget = state.getTarget();
                    boolean oldRsSupportMode = state.getRenderScriptSupportMode();
                    boolean wasLibrary = state.isLibrary();
                    ProjectState.LibraryDifference diff = state.reloadProperties();
                    IAndroidTarget newTarget = Sdk.this.loadTargetAndBuildTools(state);
                    if (diff.hasDiff()) {
                        if (diff.added) {
                            Object object = LOCK;
                            synchronized (object) {
                                for (ProjectState projectState : sProjectStateMap.values()) {
                                    if (projectState == state) continue;
                                    state.needs(projectState);
                                }
                            }
                        }
                        Sdk.this.markProject(state, wasLibrary || state.isLibrary());
                    }
                    if (newTarget != oldTarget || oldRsSupportMode != state.getRenderScriptSupportMode()) {
                        IJavaProject javaProject = BaseProjectHelper.getJavaProject(file.getProject());
                        if (javaProject != null) {
                            ProjectHelper.updateProject(javaProject);
                        }
                        AndmoreAndroidPlugin.getDefault().updateTargetListeners(iProject);
                    }
                }
                catch (CoreException coreException) {}
            } else if ((kind == 1 || kind == 2) && "jar".equals(extension) && file.getProjectRelativePath().segmentCount() == 2 && file.getParent().getName().equals("libs")) {
                this.processJarFileChange(file);
            }
        }

        private void processJarFileChange(IFile file) {
            try {
                ProjectState state;
                IProject iProject = file.getProject();
                if (!iProject.hasNature("org.eclipse.andmore.AndroidNature")) {
                    return;
                }
                ArrayList<IJavaProject> projectList = new ArrayList<IJavaProject>();
                IJavaProject javaProject = BaseProjectHelper.getJavaProject(iProject);
                if (javaProject != null) {
                    projectList.add(javaProject);
                }
                if ((state = Sdk.getProjectState(iProject)) != null) {
                    Collection<ProjectState> parents = state.getFullParentProjects();
                    for (ProjectState s : parents) {
                        javaProject = BaseProjectHelper.getJavaProject(s.getProject());
                        if (javaProject == null) continue;
                        projectList.add(javaProject);
                    }
                    ProjectHelper.updateProjects(projectList.toArray(new IJavaProject[projectList.size()]));
                }
            }
            catch (CoreException coreException) {}
        }
    };
    private final List<ProjectState> mModifiedProjects = new ArrayList<ProjectState>();
    private final List<ProjectState> mModifiedChildProjects = new ArrayList<ProjectState>();
    private GlobalProjectMonitor.IResourceEventListener mResourceEventListener = new GlobalProjectMonitor.IResourceEventListener(){

        @Override
        public void resourceChangeEventStart() {
            Sdk.this.mModifiedProjects.clear();
            Sdk.this.mModifiedChildProjects.clear();
        }

        @Override
        public void resourceChangeEventEnd() {
            if (Sdk.this.mModifiedProjects.size() == 0) {
                return;
            }
            Sdk.this.updateParentProjects();
            final ArrayList<IJavaProject> projectList = new ArrayList<IJavaProject>();
            for (ProjectState state : Sdk.this.mModifiedProjects) {
                state.updateFullLibraryList();
                projectList.add(JavaCore.create((IProject)state.getProject()));
            }
            Job job = new Job("Android Library Update"){

                protected IStatus run(IProgressMonitor monitor) {
                    LibraryClasspathContainerInitializer.updateProjects(projectList.toArray(new IJavaProject[projectList.size()]));
                    for (IJavaProject javaProject : projectList) {
                        try {
                            javaProject.getProject().build(6, monitor);
                        }
                        catch (CoreException coreException) {}
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(40);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
    };

    public static final Object getLock() {
        return LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Sdk loadSdk(String sdkLocation) {
        Object object = LOCK;
        synchronized (object) {
            block21: {
                ArrayList logMessages;
                AtomicBoolean hasError;
                AtomicBoolean hasWarning;
                block17: {
                    Iterator iterator;
                    StringBuilder sb;
                    Throwable throwable2;
                    block19: {
                        Sdk sdk;
                        block20: {
                            block18: {
                                if (sCurrentSdk != null) {
                                    sCurrentSdk.dispose();
                                    sCurrentSdk = null;
                                }
                                hasWarning = new AtomicBoolean();
                                hasError = new AtomicBoolean();
                                logMessages = new ArrayList();
                                ILogger log = new ILogger(){

                                    public void error(Throwable throwable, String errorFormat, Object ... arg) {
                                        hasError.set(true);
                                        if (errorFormat != null) {
                                            logMessages.add(String.format("Error: " + errorFormat, arg));
                                        }
                                        if (throwable != null) {
                                            logMessages.add(throwable.getMessage());
                                        }
                                    }

                                    public void warning(String warningFormat, Object ... arg) {
                                        hasWarning.set(true);
                                        logMessages.add(String.format("Warning: " + warningFormat, arg));
                                    }

                                    public void info(String msgFormat, Object ... arg) {
                                        logMessages.add(String.format(msgFormat, arg));
                                    }

                                    public void verbose(String msgFormat, Object ... arg) {
                                        this.info(msgFormat, arg);
                                    }
                                };
                                SdkManager manager = SdkManager.createManager((String)sdkLocation, (ILogger)log);
                                try {
                                    if (manager == null) {
                                        hasError.set(true);
                                        break block17;
                                    }
                                    AvdManager avdManager = null;
                                    try {
                                        avdManager = AvdManager.getInstance((LocalSdk)manager.getLocalSdk(), (ILogger)log);
                                    }
                                    catch (AndroidLocation.AndroidLocationException e) {
                                        log.error((Throwable)e, "Error parsing the AVDs", new Object[0]);
                                    }
                                    sdk = sCurrentSdk = new Sdk(manager, avdManager);
                                    if (hasError.get()) break block18;
                                    if (!hasWarning.get()) return sdk;
                                }
                                catch (Throwable throwable2) {
                                    if (!hasError.get()) {
                                        if (!hasWarning.get()) throw throwable2;
                                    }
                                    sb = new StringBuilder(String.format("%s when loading the SDK:\n", hasError.get() ? "Error" : "Warning"));
                                    iterator = logMessages.iterator();
                                    break block19;
                                }
                            }
                            StringBuilder sb2 = new StringBuilder(String.format("%s when loading the SDK:\n", hasError.get() ? "Error" : "Warning"));
                            Iterator iterator2 = logMessages.iterator();
                            while (true) {
                                if (!iterator2.hasNext()) {
                                    if (!hasError.get()) break;
                                    AndmoreAndroidPlugin.printErrorToConsole("Android SDK", sb2.toString());
                                    AndmoreAndroidPlugin.displayError("Android SDK", sb2.toString());
                                    break block20;
                                }
                                String msg = (String)iterator2.next();
                                sb2.append('\n');
                                sb2.append(msg);
                            }
                            AndmoreAndroidPlugin.printToConsole("Android SDK", sb2.toString());
                        }
                        return sdk;
                    }
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (!hasError.get()) break;
                            AndmoreAndroidPlugin.printErrorToConsole("Android SDK", sb.toString());
                            AndmoreAndroidPlugin.displayError("Android SDK", sb.toString());
                            throw throwable2;
                        }
                        String msg = (String)iterator.next();
                        sb.append('\n');
                        sb.append(msg);
                    }
                    AndmoreAndroidPlugin.printToConsole("Android SDK", sb.toString());
                    throw throwable2;
                }
                if (!hasError.get()) {
                    if (!hasWarning.get()) return null;
                }
                StringBuilder sb = new StringBuilder(String.format("%s when loading the SDK:\n", hasError.get() ? "Error" : "Warning"));
                Iterator iterator = logMessages.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (!hasError.get()) break;
                        AndmoreAndroidPlugin.printErrorToConsole("Android SDK", sb.toString());
                        AndmoreAndroidPlugin.displayError("Android SDK", sb.toString());
                        break block21;
                    }
                    String msg = (String)iterator.next();
                    sb.append('\n');
                    sb.append(msg);
                }
                AndmoreAndroidPlugin.printToConsole("Android SDK", sb.toString());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sdk getCurrent() {
        Object object = LOCK;
        synchronized (object) {
            return sCurrentSdk;
        }
    }

    @Deprecated
    public String getSdkOsLocation() {
        String path;
        String string = path = this.mManager == null ? null : this.mManager.getLocation();
        if (path != null && path.length() > 0 && !path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public File getSdkFileLocation() {
        if (this.mManager == null || this.mManager.getLocalSdk() == null) {
            return null;
        }
        return this.mManager.getLocalSdk().getLocation();
    }

    public SdkManager getNewSdkManager(ILogger log) {
        return SdkManager.createManager((String)this.getSdkOsLocation(), (ILogger)log);
    }

    public String getDocumentationBaseUrl() {
        return this.mDocBaseUrl;
    }

    public IAndroidTarget[] getTargets() {
        return this.mManager.getTargets();
    }

    public boolean haveTargetsChanged() {
        return this.mManager.hasChanged();
    }

    public IAndroidTarget getTargetFromHashString(String hash) {
        return this.mManager.getTargetFromHashString(hash);
    }

    public BuildToolInfo getBuildToolInfo(String buildToolVersion) {
        if (buildToolVersion != null) {
            try {
                return this.mManager.getBuildTool(FullRevision.parseRevision((String)buildToolVersion));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public BuildToolInfo getLatestBuildTool() {
        return this.mManager.getLatestBuildTool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initProject(IProject project, IAndroidTarget target) throws IOException, StreamException {
        if (project == null || target == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            ProjectState state = Sdk.getProjectState(project);
            ProjectPropertiesWorkingCopy properties = null;
            if (state != null) {
                properties = state.getProperties().makeWorkingCopy();
            }
            if (properties == null) {
                IPath location = project.getLocation();
                if (location == null) {
                    return;
                }
                properties = ProjectProperties.create((String)location.toOSString(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
            }
            properties.setProperty("target", target.hashString());
            properties.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProjectState getProjectState(IProject project) {
        if (project == null) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            ProjectState state = sProjectStateMap.get(project);
            if (state == null) {
                IPath location = project.getLocation();
                if (location == null) {
                    return null;
                }
                String projectLocation = location.toOSString();
                ProjectProperties properties = ProjectProperties.load((String)projectLocation, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
                if (properties == null) {
                    properties = ProjectProperties.load((String)projectLocation, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.LEGACY_DEFAULT);
                    if (properties == null) {
                        AndmoreAndroidPlugin.log(4, "Failed to load properties file for project '%s'", project.getName());
                        return null;
                    }
                    ProjectPropertiesWorkingCopy wc = properties.makeWorkingCopy(ProjectProperties.PropertyType.PROJECT);
                    try {
                        wc.save();
                        ProjectProperties.delete((String)projectLocation, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.LEGACY_DEFAULT);
                        properties = ProjectProperties.load((String)projectLocation, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
                    }
                    catch (Exception exception) {
                        AndmoreAndroidPlugin.log(4, "Failed to rename properties file to %1$s for project '%s2$'", ProjectProperties.PropertyType.PROJECT.getFilename(), project.getName());
                    }
                }
                state = new ProjectState(project, properties);
                sProjectStateMap.put(project, state);
                if (AndmoreAndroidPlugin.getDefault().getSdkLoadStatus() == LoadStatus.LOADED) {
                    sCurrentSdk.loadTargetAndBuildTools(state);
                }
            }
            return state;
        }
    }

    public IAndroidTarget getTarget(IProject project) {
        if (project == null) {
            return null;
        }
        ProjectState state = Sdk.getProjectState(project);
        if (state != null) {
            return state.getTarget();
        }
        return null;
    }

    public IAndroidTarget loadTargetAndBuildTools(ProjectState state) {
        IAndroidTarget target = null;
        if (state != null) {
            String hash = state.getTargetHashString();
            if (hash != null) {
                target = this.getTargetFromHashString(hash);
                state.setTarget(target);
            }
            String markerMessage = null;
            String buildToolInfoVersion = state.getBuildToolInfoVersion();
            if (buildToolInfoVersion != null) {
                BuildToolInfo buildToolsInfo = this.getBuildToolInfo(buildToolInfoVersion);
                if (buildToolsInfo != null) {
                    state.setBuildToolInfo(buildToolsInfo);
                } else {
                    markerMessage = String.format("Unable to resolve %s property value '%s'", "sdk.buildtools", buildToolInfoVersion);
                }
            } else {
                state.setBuildToolInfo(null);
            }
            this.handleBuildToolsMarker(state.getProject(), markerMessage);
        }
        return target;
    }

    private void handleBuildToolsMarker(final IProject project, final String markerMessage) {
        Job markerJob = new Job("Android SDK: Build Tools Marker"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (project.isAccessible()) {
                        project.deleteMarkers("org.eclipse.andmore.buildToolsProblem", true, 0);
                        if (markerMessage != null) {
                            BaseProjectHelper.markProject(project, "org.eclipse.andmore.buildToolsProblem", markerMessage, 2, 2);
                        }
                    }
                }
                catch (CoreException e2) {
                    AndmoreAndroidPlugin.log(e2, null, new Object[0]);
                }
                return Status.OK_STATUS;
            }
        };
        markerJob.setPriority(40);
        markerJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        markerJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadStatus checkAndLoadTargetData(final IAndroidTarget target, IJavaProject project) {
        boolean loadData = false;
        Object object = LOCK;
        synchronized (object) {
            if (this.mDontLoadTargetData) {
                return LoadStatus.FAILED;
            }
            TargetLoadBundle bundle = this.mTargetDataStatusMap.get(target);
            if (bundle == null) {
                bundle = new TargetLoadBundle();
                this.mTargetDataStatusMap.put(target, bundle);
                bundle.status = LoadStatus.LOADING;
                if (project != null) {
                    bundle.projectsToReload.add(project);
                }
                loadData = true;
            } else {
                if (bundle.status == LoadStatus.LOADING) {
                    if (project != null) {
                        bundle.projectsToReload.add(project);
                    }
                    return bundle.status;
                }
                if (bundle.status == LoadStatus.LOADED || bundle.status == LoadStatus.FAILED) {
                    return bundle.status;
                }
            }
        }
        if (loadData) {
            Job job = new Job(String.format("Loading data for %1$s", target.getFullName())){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    AndmoreAndroidPlugin plugin = AndmoreAndroidPlugin.getDefault();
                    try {
                        IStatus status = new AndroidTargetParser(target).run(monitor);
                        IJavaProject[] javaProjectArray = null;
                        Object object = LOCK;
                        synchronized (object) {
                            TargetLoadBundle bundle = (TargetLoadBundle)Sdk.this.mTargetDataStatusMap.get(target);
                            if (status.getCode() != 0) {
                                bundle.status = LoadStatus.FAILED;
                                bundle.projectsToReload.clear();
                            } else {
                                bundle.status = LoadStatus.LOADED;
                                javaProjectArray = bundle.projectsToReload.toArray(new IJavaProject[bundle.projectsToReload.size()]);
                                plugin.updateTargetListeners(target);
                            }
                        }
                        if (javaProjectArray != null) {
                            ProjectHelper.updateProjects(javaProjectArray);
                        }
                        return status;
                    }
                    catch (Throwable t) {
                        Object object = LOCK;
                        synchronized (object) {
                            TargetLoadBundle bundle = (TargetLoadBundle)Sdk.this.mTargetDataStatusMap.get(target);
                            bundle.status = LoadStatus.FAILED;
                        }
                        AndmoreAndroidPlugin.log(t, "Exception in checkAndLoadTargetData.", new Object[0]);
                        return new Status(4, "org.eclipse.andmore", String.format("Parsing Data for %1$s failed", target.hashString()), t);
                    }
                }
            };
            job.setPriority(40);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
        return LoadStatus.LOADING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidTargetData getTargetData(IAndroidTarget target) {
        Object object = LOCK;
        synchronized (object) {
            return this.mTargetDataMap.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidTargetData getTargetData(IProject project) {
        Object object = LOCK;
        synchronized (object) {
            IAndroidTarget target = this.getTarget(project);
            if (target != null) {
                return this.getTargetData(target);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexWrapper getDexWrapper(BuildToolInfo buildToolInfo) {
        if (buildToolInfo == null) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            String dexLocation = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
            DexWrapper dexWrapper = this.mDexWrappers.get(dexLocation);
            if (dexWrapper == null) {
                dexWrapper = new DexWrapper();
                IStatus res = dexWrapper.loadDex(dexLocation);
                if (res != Status.OK_STATUS) {
                    AndmoreAndroidPlugin.log(null, res.getMessage(), new Object[0]);
                    dexWrapper = null;
                } else {
                    this.mDexWrappers.put(dexLocation, dexWrapper);
                }
            }
            return dexWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadDexWrappers() {
        Object object = LOCK;
        synchronized (object) {
            for (DexWrapper wrapper : this.mDexWrappers.values()) {
                wrapper.unload();
            }
            this.mDexWrappers.clear();
        }
    }

    public AvdManager getAvdManager() {
        return this.mAvdManager;
    }

    public static AndroidVersion getDeviceVersion(IDevice device) {
        String apiLevel;
        Map props;
        block3: {
            try {
                props = device.getProperties();
                apiLevel = (String)props.get("ro.build.version.sdk");
                if (apiLevel != null) break block3;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return new AndroidVersion(Integer.parseInt(apiLevel), (String)props.get("ro.build.version.codename"));
    }

    public DeviceManager getDeviceManager() {
        return this.mDeviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ProjectState> getMainProjectsFor(IProject project) {
        Object object = LOCK;
        synchronized (object) {
            HashSet<ProjectState> list = new HashSet<ProjectState>();
            for (Map.Entry<IProject, ProjectState> entry : sProjectStateMap.entrySet()) {
                ProjectState.LibraryState library;
                if (project == entry.getKey() || (library = entry.getValue().getLibrary(project)) == null) continue;
                list.add(entry.getValue());
            }
            HashSet<ProjectState> result = new HashSet<ProjectState>(list);
            for (ProjectState p : list) {
                if (!p.isLibrary()) continue;
                Set<ProjectState> set = Sdk.getMainProjectsFor(p.getProject());
                result.addAll(set);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadTargetData(boolean preventReload) {
        Object object = LOCK;
        synchronized (object) {
            this.mDontLoadTargetData = preventReload;
            for (AndroidTargetData data : this.mTargetDataMap.values()) {
                data.dispose();
            }
            this.mTargetDataMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sdk(SdkManager manager, AvdManager avdManager) {
        this.mManager = manager;
        this.mAvdManager = avdManager;
        GlobalProjectMonitor monitor = GlobalProjectMonitor.getMonitor();
        monitor.addResourceEventListener(this.mResourceEventListener);
        monitor.addProjectListener(this.mProjectListener);
        monitor.addFileListener(this.mFileListener, 7);
        this.mDocBaseUrl = this.getDocumentationBaseUrl(String.valueOf(manager.getLocation()) + SdkConstants.OS_SDK_DOCS_FOLDER);
        this.mDeviceManager = DeviceManager.createInstance((File)manager.getLocalSdk().getLocation(), (ILogger)AndmoreAndroidPlugin.getDefault());
        Object object = LOCK;
        synchronized (object) {
            for (Map.Entry<IProject, ProjectState> entry : sProjectStateMap.entrySet()) {
                this.loadTargetAndBuildTools(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        GlobalProjectMonitor monitor = GlobalProjectMonitor.getMonitor();
        monitor.removeProjectListener(this.mProjectListener);
        monitor.removeFileListener(this.mFileListener);
        monitor.removeResourceEventListener(this.mResourceEventListener);
        Object object = LOCK;
        synchronized (object) {
            for (Map.Entry<IProject, ProjectState> entry : sProjectStateMap.entrySet()) {
                entry.getValue().setTarget(null);
            }
            for (AndroidTargetData data : this.mTargetDataMap.values()) {
                data.dispose();
            }
            this.mTargetDataMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTargetData(IAndroidTarget target, AndroidTargetData data) {
        Object object = LOCK;
        synchronized (object) {
            this.mTargetDataMap.put(target, data);
        }
    }

    private String getDocumentationBaseUrl(String osDocsPath) {
        File f = new File(osDocsPath);
        if (f.isDirectory()) {
            try {
                String path = f.getAbsolutePath();
                if (File.separatorChar != '/') {
                    path = path.replace(File.separatorChar, '/');
                }
                URL url = new URL("file", null, "//" + path);
                String result = url.toString();
                return result;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    private void markProject(ProjectState projectState, boolean updateParents) {
        if (!this.mModifiedProjects.contains(projectState)) {
            this.mModifiedProjects.add(projectState);
        }
        if (updateParents && !this.mModifiedChildProjects.contains(projectState)) {
            this.mModifiedChildProjects.add(projectState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateParentProjects() {
        if (this.mModifiedChildProjects.size() == 0) {
            return;
        }
        ArrayList<ProjectState> childProjects = new ArrayList<ProjectState>(this.mModifiedChildProjects);
        this.mModifiedChildProjects.clear();
        Object object = LOCK;
        synchronized (object) {
            for (ProjectState state : childProjects) {
                List<ProjectState> parents = state.getParentProjects();
                for (ProjectState parent : parents) {
                    this.markProject(parent, parent.isLibrary());
                }
            }
        }
        this.updateParentProjects();
    }

    private void fixEditorAssociations(final IProject project) {
        QualifiedName KEY = new QualifiedName("org.eclipse.andmore", "editorbinding");
        try {
            String value = project.getPersistentProperty(KEY);
            int currentVersion = 0;
            if (value != null) {
                try {
                    currentVersion = Integer.parseInt(value);
                }
                catch (Exception exception) {}
            }
            if (currentVersion >= 2) {
                return;
            }
            project.setPersistentProperty(KEY, Integer.toString(2));
            Job job = new Job("Update Android editor bindings"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IResource[] iResourceArray = project.getFolder("res").members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource folderResource = iResourceArray[n2];
                            if (folderResource instanceof IFolder) {
                                IFolder folder = (IFolder)folderResource;
                                IResource[] iResourceArray2 = folder.members();
                                int n3 = iResourceArray2.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IResource resource = iResourceArray2[n4];
                                    if (resource instanceof IFile && resource.getName().endsWith(".xml")) {
                                        this.fixXmlFile((IFile)resource);
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        AndmoreAndroidPlugin.log(e, null, new Object[0]);
                    }
                    return Status.OK_STATUS;
                }

                private void fixXmlFile(IFile file) {
                    IEditorDescriptor desc = IDE.getDefaultEditor((IFile)file);
                    if (desc == null || !"org.eclipse.andmore.editors.CommonXmlEditor".equals(desc.getId())) {
                        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.andmore.editors.CommonXmlEditor");
                    }
                }
            };
            job.setPriority(40);
            job.schedule();
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
    }

    private void fixOpenLegacyEditors() {
        AndmoreAndroidPlugin adt = AndmoreAndroidPlugin.getDefault();
        if (adt == null) {
            return;
        }
        final IPreferenceStore store = adt.getPreferenceStore();
        int currentValue = store.getInt("org.eclipse.andmore.fixLegacyEditors");
        if (currentValue >= 1) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                HashSet<String> legacyIds = new HashSet<String>(Arrays.asList(CommonXmlEditor.LEGACY_EDITOR_IDS));
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow win = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = win.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference ref = iEditorReferenceArray[n6];
                            try {
                                IEditorInput input = ref.getEditorInput();
                                if (input instanceof IFileEditorInput) {
                                    String id;
                                    IWorkbenchPartSite site;
                                    IFile file = ((IFileEditorInput)input).getFile();
                                    IEditorPart part = ref.getEditor(true);
                                    if (part != null && (site = part.getSite()) != null && legacyIds.contains(id = site.getId())) {
                                        this.fixEditor(page, part, input, file, id);
                                    }
                                }
                            }
                            catch (Exception exception) {}
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                store.setValue("org.eclipse.andmore.fixLegacyEditors", 1);
            }

            private void fixEditor(IWorkbenchPage page, IEditorPart part, IEditorInput input, IFile file, String id) {
                IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.andmore.editors.CommonXmlEditor");
                boolean ok = page.closeEditor(part, true);
                AndmoreAndroidPlugin.log(1, "Closed legacy editor ID %s for %s: %s", id, file.getFullPath(), ok ? "Success" : "Failed");
                if (ok) {
                    try {
                        page.openEditor(input, "org.eclipse.andmore.editors.CommonXmlEditor");
                    }
                    catch (PartInitException e) {
                        AndmoreAndroidPlugin.log(e, "Failed to reopen %s", file.getFullPath());
                    }
                }
            }
        });
    }

    public static interface ITargetChangeListener {
        public void onProjectTargetChange(IProject var1);

        public void onTargetLoaded(IAndroidTarget var1);

        public void onSdkLoaded();
    }

    public static abstract class TargetChangeListener
    implements ITargetChangeListener {
        public abstract IProject getProject();

        public abstract void reload();

        @Override
        public void onProjectTargetChange(IProject changedProject) {
            if (changedProject != null && changedProject.equals((Object)this.getProject())) {
                this.reload();
            }
        }

        @Override
        public void onTargetLoaded(IAndroidTarget target) {
            IProject project = this.getProject();
            if (target != null && target.equals(Sdk.getCurrent().getTarget(project))) {
                this.reload();
            }
        }

        @Override
        public void onSdkLoaded() {
        }
    }

    private static final class TargetLoadBundle {
        LoadStatus status;
        final HashSet<IJavaProject> projectsToReload = new HashSet();

        private TargetLoadBundle() {
        }
    }
}

