/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.sdk;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.resources.ResourceRepository;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InvalidAttributeValueException;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.resources.platform.AttrsXmlParser;
import org.eclipse.andmore.common.resources.platform.DeclareStyleableInfo;
import org.eclipse.andmore.common.resources.platform.ViewClassInfo;
import org.eclipse.andmore.internal.editors.animator.AnimDescriptors;
import org.eclipse.andmore.internal.editors.animator.AnimatorDescriptors;
import org.eclipse.andmore.internal.editors.color.ColorDescriptors;
import org.eclipse.andmore.internal.editors.drawable.DrawableDescriptors;
import org.eclipse.andmore.internal.editors.layout.descriptors.LayoutDescriptors;
import org.eclipse.andmore.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import org.eclipse.andmore.internal.editors.menu.descriptors.MenuDescriptors;
import org.eclipse.andmore.internal.editors.otherxml.descriptors.OtherXmlDescriptors;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.andmore.internal.sdk.AndroidJarLoader;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.LayoutParamsParser;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.sdk.WidgetClassLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public final class AndroidTargetParser {
    private static final String TAG = "Framework Resource Parser";
    private final IAndroidTarget mAndroidTarget;

    public AndroidTargetParser(IAndroidTarget platformTarget) {
        this.mAndroidTarget = platformTarget;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format("Parsing SDK %1$s", this.mAndroidTarget.getName()), (int)16);
            AndroidTargetData targetData = new AndroidTargetData(this.mAndroidTarget);
            AndroidJarLoader classLoader = new AndroidJarLoader(this.mAndroidTarget.getPath(1));
            this.preload(classLoader, (IProgressMonitor)progress.newChild(40, 0));
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            progress.subTask("Permissions");
            String[] permissionValues = this.collectPermissions(classLoader);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            progress.subTask("Intents");
            ArrayList<String> activity_actions = new ArrayList<String>();
            ArrayList<String> broadcast_actions = new ArrayList<String>();
            ArrayList<String> service_actions = new ArrayList<String>();
            ArrayList<String> categories = new ArrayList<String>();
            this.collectIntentFilterActionsAndCategories(activity_actions, broadcast_actions, service_actions, categories);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            progress.subTask("Attributes definitions");
            AttrsXmlParser attrsXmlParser = new AttrsXmlParser(this.mAndroidTarget.getPath(8), AndmoreAndroidPlugin.getDefault(), 1000);
            attrsXmlParser.preload();
            progress.worked(1);
            progress.subTask("Manifest definitions");
            AttrsXmlParser attrsManifestXmlParser = new AttrsXmlParser(this.mAndroidTarget.getPath(9), attrsXmlParser, AndmoreAndroidPlugin.getDefault(), 1100);
            attrsManifestXmlParser.preload();
            progress.worked(1);
            ArrayList<ViewClassInfo> mainList = new ArrayList<ViewClassInfo>();
            ArrayList<ViewClassInfo> groupList = new ArrayList<ViewClassInfo>();
            progress.subTask("Widgets and layouts");
            this.collectLayoutClasses(classLoader, attrsXmlParser, mainList, groupList, (IProgressMonitor)progress.newChild(1));
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ViewClassInfo[] layoutViewsInfo = mainList.toArray(new ViewClassInfo[mainList.size()]);
            ViewClassInfo[] layoutGroupsInfo = groupList.toArray(new ViewClassInfo[groupList.size()]);
            mainList.clear();
            groupList.clear();
            this.collectPreferenceClasses(classLoader, attrsXmlParser, mainList, groupList, (IProgressMonitor)progress.newChild(1));
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ViewClassInfo[] preferencesInfo = mainList.toArray(new ViewClassInfo[mainList.size()]);
            ViewClassInfo[] preferenceGroupsInfo = groupList.toArray(new ViewClassInfo[groupList.size()]);
            Map<String, DeclareStyleableInfo> xmlMenuMap = this.collectMenuDefinitions(attrsXmlParser);
            Map<String, DeclareStyleableInfo> xmlSearchableMap = this.collectSearchableDefinitions(attrsXmlParser);
            Map<String, DeclareStyleableInfo> manifestMap = this.collectManifestDefinitions(attrsManifestXmlParser);
            Map<String, Map<String, Integer>> enumValueMap = attrsXmlParser.getEnumFlagValues();
            Map<String, DeclareStyleableInfo> xmlAppWidgetMap = null;
            if (this.mAndroidTarget.getVersion().getApiLevel() >= 3) {
                xmlAppWidgetMap = this.collectAppWidgetDefinitions(attrsXmlParser);
            }
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            AndroidManifestDescriptors manifestDescriptors = new AndroidManifestDescriptors();
            manifestDescriptors.updateDescriptors(manifestMap);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            LayoutDescriptors layoutDescriptors = new LayoutDescriptors();
            layoutDescriptors.updateDescriptors(layoutViewsInfo, layoutGroupsInfo, attrsXmlParser.getDeclareStyleableList(), this.mAndroidTarget);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            MenuDescriptors menuDescriptors = new MenuDescriptors();
            menuDescriptors.updateDescriptors(xmlMenuMap);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            OtherXmlDescriptors otherXmlDescriptors = new OtherXmlDescriptors();
            otherXmlDescriptors.updateDescriptors(xmlSearchableMap, xmlAppWidgetMap, preferencesInfo, preferenceGroupsInfo);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            DrawableDescriptors drawableDescriptors = new DrawableDescriptors();
            Map<String, DeclareStyleableInfo> map = attrsXmlParser.getDeclareStyleableList();
            drawableDescriptors.updateDescriptors(map);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            AnimatorDescriptors animatorDescriptors = new AnimatorDescriptors();
            animatorDescriptors.updateDescriptors(map);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            AnimDescriptors animDescriptors = new AnimDescriptors();
            animDescriptors.updateDescriptors(map);
            progress.worked(1);
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ColorDescriptors colorDescriptors = new ColorDescriptors();
            colorDescriptors.updateDescriptors(map);
            progress.worked(1);
            ResourceRepository frameworkResources = ResourceManager.getInstance().loadFrameworkResources(this.mAndroidTarget);
            progress.worked(1);
            LayoutLibrary layoutBridge = LayoutLibrary.load((String)this.mAndroidTarget.getPath(10), (ILogger)AndmoreAndroidPlugin.getDefault(), (String)"ADT plug-in");
            progress.worked(1);
            targetData.setExtraData(manifestDescriptors, layoutDescriptors, menuDescriptors, otherXmlDescriptors, drawableDescriptors, animatorDescriptors, animDescriptors, colorDescriptors, enumValueMap, permissionValues, activity_actions.toArray(new String[activity_actions.size()]), broadcast_actions.toArray(new String[broadcast_actions.size()]), service_actions.toArray(new String[service_actions.size()]), categories.toArray(new String[categories.size()]), this.mAndroidTarget.getPlatformLibraries(), this.mAndroidTarget.getOptionalLibraries(), frameworkResources, layoutBridge);
            targetData.setAttributeMap(attrsXmlParser.getAttributeMap());
            Sdk.getCurrent().setTargetData(this.mAndroidTarget, targetData);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.logAndPrintError(e, TAG, "SDK parser failed", new Object[0]);
            AndmoreAndroidPlugin.printToConsole("SDK parser failed", e.getMessage());
            return new Status(4, "org.eclipse.andmore", "SDK parser failed", (Throwable)e);
        }
    }

    private void preload(AndroidJarLoader classLoader, IProgressMonitor monitor) {
        try {
            classLoader.preLoadClasses("", this.mAndroidTarget.getName(), monitor);
        }
        catch (InvalidAttributeValueException e) {
            AndmoreAndroidPlugin.log(e, "Problem preloading classes", new Object[0]);
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.log(e, "Problem preloading classes", new Object[0]);
        }
    }

    private String[] collectPermissions(AndroidJarLoader classLoader) {
        block10: {
            try {
                Field[] fields;
                Class<?> permissionClass = classLoader.loadClass("android.Manifest$permission");
                if (permissionClass == null) break block10;
                ArrayList<String> list = new ArrayList<String>();
                Field[] fieldArray = fields = permissionClass.getFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    int modifiers = f.getModifiers();
                    if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers)) {
                        try {
                            Object value = f.get(null);
                            if (value instanceof String) {
                                list.add((String)value);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (ExceptionInInitializerError exceptionInInitializerError) {}
                    }
                    ++n2;
                }
                return list.toArray(new String[list.size()]);
            }
            catch (ClassNotFoundException e) {
                AndmoreAndroidPlugin.logAndPrintError(e, TAG, "Collect permissions failed, class %1$s not found in %2$s", "android.Manifest$permission", this.mAndroidTarget.getPath(1));
            }
        }
        return new String[0];
    }

    private void collectIntentFilterActionsAndCategories(ArrayList<String> activityActions, ArrayList<String> broadcastActions, ArrayList<String> serviceActions, ArrayList<String> categories) {
        this.collectValues(this.mAndroidTarget.getPath(14), activityActions);
        this.collectValues(this.mAndroidTarget.getPath(15), broadcastActions);
        this.collectValues(this.mAndroidTarget.getPath(16), serviceActions);
        this.collectValues(this.mAndroidTarget.getPath(17), categories);
    }

    private void collectValues(String osFilePath, ArrayList<String> values) {
        FileReader fr = null;
        BufferedReader reader = null;
        try {
            try {
                String line;
                fr = new FileReader(osFilePath);
                reader = new BufferedReader(fr);
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                    values.add(line);
                }
            }
            catch (IOException e) {
                AndmoreAndroidPlugin.log(e, "Failed to read SDK values", new Object[0]);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    AndmoreAndroidPlugin.log(e2, "Failed to read SDK values", new Object[0]);
                }
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException e3) {
                    AndmoreAndroidPlugin.log(e3, "Failed to read SDK values", new Object[0]);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                AndmoreAndroidPlugin.log(e, "Failed to read SDK values", new Object[0]);
            }
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                AndmoreAndroidPlugin.log(e, "Failed to read SDK values", new Object[0]);
            }
        }
    }

    private void collectLayoutClasses(AndroidJarLoader classLoader, AttrsXmlParser attrsXmlParser, Collection<ViewClassInfo> mainList, Collection<ViewClassInfo> groupList, IProgressMonitor monitor) {
        LayoutParamsParser ldp = null;
        try {
            WidgetClassLoader loader = new WidgetClassLoader(this.mAndroidTarget.getPath(13));
            if (loader.parseWidgetList(monitor)) {
                ldp = new LayoutParamsParser(loader, attrsXmlParser);
            }
        }
        catch (FileNotFoundException e) {
            AndmoreAndroidPlugin.log(e, "Android Framework Parser", new Object[0]);
        }
        if (ldp == null) {
            ldp = new LayoutParamsParser(classLoader, attrsXmlParser);
        }
        ldp.parseLayoutClasses(monitor);
        List<ViewClassInfo> views = ldp.getViews();
        List<ViewClassInfo> groups = ldp.getGroups();
        if (views != null && groups != null) {
            mainList.addAll(views);
            groupList.addAll(groups);
        }
    }

    private void collectPreferenceClasses(AndroidJarLoader classLoader, AttrsXmlParser attrsXmlParser, Collection<ViewClassInfo> mainList, Collection<ViewClassInfo> groupList, IProgressMonitor monitor) {
        LayoutParamsParser ldp = new LayoutParamsParser(classLoader, attrsXmlParser);
        try {
            ldp.parsePreferencesClasses(monitor);
            List<ViewClassInfo> prefs = ldp.getViews();
            List<ViewClassInfo> groups = ldp.getGroups();
            if (prefs != null && groups != null) {
                mainList.addAll(prefs);
                groupList.addAll(groups);
            }
        }
        catch (NoClassDefFoundError e) {
            AndmoreAndroidPlugin.logAndPrintError(e, TAG, "Collect preferences failed, class %1$s not found in %2$s", e.getMessage(), classLoader.getSource());
        }
        catch (Throwable e) {
            AndmoreAndroidPlugin.log(e, "Android Framework Parser: failed to collect preference classes", new Object[0]);
            AndmoreAndroidPlugin.printErrorToConsole("Android Framework Parser", "failed to collect preference classes");
        }
    }

    private Map<String, DeclareStyleableInfo> collectMenuDefinitions(AttrsXmlParser attrsXmlParser) {
        Map<String, DeclareStyleableInfo> map = attrsXmlParser.getDeclareStyleableList();
        HashMap<String, DeclareStyleableInfo> map2 = new HashMap<String, DeclareStyleableInfo>();
        String[] stringArray = new String[]{"Menu", "MenuItem", "MenuGroup"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (map.containsKey(key)) {
                map2.put(key, map.get(key));
            } else {
                AndmoreAndroidPlugin.log(2, "Menu declare-styleable %1$s not found in file %2$s", key, attrsXmlParser.getOsAttrsXmlPath());
                AndmoreAndroidPlugin.printErrorToConsole("Android Framework Parser", String.format("Menu declare-styleable %1$s not found in file %2$s", key, attrsXmlParser.getOsAttrsXmlPath()));
            }
            ++n2;
        }
        return Collections.unmodifiableMap(map2);
    }

    private Map<String, DeclareStyleableInfo> collectSearchableDefinitions(AttrsXmlParser attrsXmlParser) {
        Map<String, DeclareStyleableInfo> map = attrsXmlParser.getDeclareStyleableList();
        HashMap<String, DeclareStyleableInfo> map2 = new HashMap<String, DeclareStyleableInfo>();
        String[] stringArray = new String[]{"Searchable", "SearchableActionKey"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (map.containsKey(key)) {
                map2.put(key, map.get(key));
            } else {
                AndmoreAndroidPlugin.log(2, "Searchable declare-styleable %1$s not found in file %2$s", key, attrsXmlParser.getOsAttrsXmlPath());
                AndmoreAndroidPlugin.printErrorToConsole("Android Framework Parser", String.format("Searchable declare-styleable %1$s not found in file %2$s", key, attrsXmlParser.getOsAttrsXmlPath()));
            }
            ++n2;
        }
        return Collections.unmodifiableMap(map2);
    }

    private Map<String, DeclareStyleableInfo> collectAppWidgetDefinitions(AttrsXmlParser attrsXmlParser) {
        Map<String, DeclareStyleableInfo> map = attrsXmlParser.getDeclareStyleableList();
        HashMap<String, DeclareStyleableInfo> map2 = new HashMap<String, DeclareStyleableInfo>();
        String[] stringArray = new String[]{"AppWidgetProviderInfo"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (map.containsKey(key)) {
                map2.put(key, map.get(key));
            } else {
                AndmoreAndroidPlugin.log(2, "AppWidget declare-styleable %1$s not found in file %2$s", key, attrsXmlParser.getOsAttrsXmlPath());
                AndmoreAndroidPlugin.printErrorToConsole("Android Framework Parser", String.format("AppWidget declare-styleable %1$s not found in file %2$s", key, attrsXmlParser.getOsAttrsXmlPath()));
            }
            ++n2;
        }
        return Collections.unmodifiableMap(map2);
    }

    private Map<String, DeclareStyleableInfo> collectManifestDefinitions(AttrsXmlParser attrsXmlParser) {
        return attrsXmlParser.getDeclareStyleableList();
    }
}

