/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.sdk;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.InvalidAttributeValueException;
import org.eclipse.andmore.internal.sdk.IAndroidClassLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AndroidJarLoader
extends ClassLoader
implements IAndroidClassLoader {
    private String mOsFrameworkLocation;
    private final HashMap<String, byte[]> mEntryCache = new HashMap();
    private final HashMap<String, Class<?>> mClassCache = new HashMap();

    public AndroidJarLoader(String osFrameworkLocation) {
        this.mOsFrameworkLocation = osFrameworkLocation;
    }

    @Override
    public String getSource() {
        return this.mOsFrameworkLocation;
    }

    public void preLoadClasses(String packageFilter, String taskLabel, IProgressMonitor monitor) throws IOException, InvalidAttributeValueException, ClassFormatError {
        ZipEntry entry;
        String pathFilter = packageFilter.replaceAll("\\.", "/");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)(taskLabel == null ? "" : taskLabel), (int)100);
        FileInputStream fis = new FileInputStream(this.mOsFrameworkLocation);
        ZipInputStream zis = new ZipInputStream(fis);
        while ((entry = zis.getNextEntry()) != null) {
            String entryPath = entry.getName();
            if (!entryPath.endsWith(".class") || pathFilter.length() > 0 && !entryPath.startsWith(pathFilter)) continue;
            String className = this.entryPathToClassName(entryPath);
            if (!this.mEntryCache.containsKey(className)) {
                long entrySize = entry.getSize();
                if (entrySize > Integer.MAX_VALUE) {
                    throw new InvalidAttributeValueException();
                }
                byte[] data = this.readZipData(zis, (int)entrySize);
                this.mEntryCache.put(className, data);
            }
            progress.setWorkRemaining(100);
            progress.worked(5);
            progress.subTask(String.format("Preload %1$s", className));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public HashMap<String, ArrayList<IAndroidClassLoader.IClassDescriptor>> findClassesDerivingFrom(String packageFilter, String[] superClasses) throws IOException, InvalidAttributeValueException, ClassFormatError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String entryPathToClassName(String entryPath) {
        return entryPath.replaceFirst("\\.class$", "").replaceAll("[/\\\\]", ".");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Class<?> cached_class = this.mClassCache.get(name);
            if (cached_class == ClassNotFoundException.class) {
                throw new ClassNotFoundException(name);
            }
            if (cached_class != null) {
                return cached_class;
            }
            byte[] data = this.loadClassData(name);
            if (data != null) {
                return this.defineAndCacheClass(name, data);
            }
            this.mClassCache.put(name, ClassNotFoundException.class);
            throw new ClassNotFoundException(name);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    private Class<?> defineAndCacheClass(String name, byte[] data) throws ClassFormatError {
        Class<?> cached_class = this.defineClass(null, data, 0, data.length);
        if (cached_class != null) {
            this.mClassCache.put(name, cached_class);
            this.mEntryCache.remove(name);
        }
        return cached_class;
    }

    private synchronized byte[] loadClassData(String className) throws InvalidAttributeValueException, IOException {
        byte[] data = this.mEntryCache.get(className);
        if (data != null) {
            return data;
        }
        String entryName = String.valueOf(className.replaceAll("\\.", "/")) + ".class";
        FileInputStream fis = new FileInputStream(this.mOsFrameworkLocation);
        ZipInputStream zis = new ZipInputStream(fis);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String currEntryName = entry.getName();
                if (!currEntryName.equals(entryName)) continue;
                long entrySize = entry.getSize();
                if (entrySize > Integer.MAX_VALUE) {
                    throw new InvalidAttributeValueException();
                }
                byte[] byArray = data = this.readZipData(zis, (int)entrySize);
                return byArray;
            }
            return null;
        }
        finally {
            zis.close();
        }
    }

    private byte[] readZipData(ZipInputStream zis, int entrySize) throws IOException {
        int block_size = 1024;
        int data_size = entrySize < 1 ? block_size : entrySize;
        int offset = 0;
        byte[] data = new byte[data_size];
        while (zis.available() != 0) {
            int count = zis.read(data, offset, data_size - offset);
            if (count < 0 || entrySize >= 1 && (offset += count) >= entrySize) break;
            if (offset < data_size) continue;
            byte[] temp = new byte[data_size + block_size];
            System.arraycopy(data, 0, temp, 0, data_size);
            data_size += block_size;
            data = temp;
            block_size *= 2;
        }
        if (offset < data_size) {
            byte[] temp = new byte[offset];
            if (offset > 0) {
                System.arraycopy(data, 0, temp, 0, offset);
            }
            data = temp;
        }
        return data;
    }

    @Override
    public IAndroidClassLoader.IClassDescriptor getClass(String className) throws ClassNotFoundException {
        return new ClassWrapper(this.loadClass(className));
    }

    public static final class ClassWrapper
    implements IAndroidClassLoader.IClassDescriptor {
        private Class<?> mClass;

        public ClassWrapper(Class<?> clazz) {
            this.mClass = clazz;
        }

        @Override
        public String getFullClassName() {
            return this.mClass.getCanonicalName();
        }

        @Override
        public IAndroidClassLoader.IClassDescriptor[] getDeclaredClasses() {
            Class<?>[] classes = this.mClass.getDeclaredClasses();
            IAndroidClassLoader.IClassDescriptor[] iclasses = new IAndroidClassLoader.IClassDescriptor[classes.length];
            int i = 0;
            while (i < classes.length) {
                iclasses[i] = new ClassWrapper(classes[i]);
                ++i;
            }
            return iclasses;
        }

        @Override
        public IAndroidClassLoader.IClassDescriptor getEnclosingClass() {
            return new ClassWrapper(this.mClass.getEnclosingClass());
        }

        @Override
        public String getSimpleName() {
            return this.mClass.getSimpleName();
        }

        @Override
        public IAndroidClassLoader.IClassDescriptor getSuperclass() {
            return new ClassWrapper(this.mClass.getSuperclass());
        }

        public boolean equals(Object clazz) {
            if (clazz instanceof ClassWrapper) {
                return this.mClass.equals(((ClassWrapper)clazz).mClass);
            }
            return super.equals(clazz);
        }

        public int hashCode() {
            return this.mClass.hashCode();
        }

        @Override
        public boolean isInstantiable() {
            int modifiers = this.mClass.getModifiers();
            return !Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers);
        }

        public Class<?> wrappedClass() {
            return this.mClass;
        }
    }
}

