/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.resources.manager;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.io.IAbstractFolder;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.internal.resources.manager.DynamicIdMap;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.io.IFolderWrapper;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;

public class ProjectResources
extends ResourceRepository {
    private static final int DYNAMIC_ID_SEED_START = 0x7FFF0000;
    private Map<ResourceType, Map<String, Integer>> mResourceValueMap;
    private Map<Integer, Pair<ResourceType, String>> mResIdValueToNameMap;
    private Map<IntArrayWrapper, String> mStyleableValueToNameMap;
    private final DynamicIdMap mDynamicIdMap = new DynamicIdMap(0x7FFF0000);
    private final IntArrayWrapper mWrapper = new IntArrayWrapper(null);
    private final IProject mProject;

    public static ProjectResources create(IProject project) {
        IFolder resFolder = project.getFolder("res");
        return new ProjectResources(project, new IFolderWrapper(resFolder));
    }

    private ProjectResources(IProject project, IAbstractFolder resFolder) {
        super(resFolder, false);
        this.mProject = project;
    }

    public Map<ResourceType, Map<String, ResourceValue>> getConfiguredResources(FolderConfiguration referenceConfig) {
        ProjectState state;
        this.ensureInitialized();
        EnumMap<ResourceType, Map<String, ResourceValue>> resultMap = new EnumMap<ResourceType, Map<String, ResourceValue>>(ResourceType.class);
        if (this.mProject != null && (state = Sdk.getProjectState(this.mProject)) != null) {
            List<IProject> libraries = state.getFullLibraryProjects();
            ResourceManager resMgr = ResourceManager.getInstance();
            int i = libraries.size() - 1;
            while (i >= 0) {
                IProject library = libraries.get(i);
                ProjectResources libRes = resMgr.getProjectResources(library);
                if (libRes != null) {
                    Map libMap = libRes.doGetConfiguredResources(referenceConfig);
                    for (Map.Entry libEntry : libMap.entrySet()) {
                        Map tempMap = (Map)resultMap.get(libEntry.getKey());
                        if (tempMap == null) {
                            resultMap.put((ResourceType)libEntry.getKey(), (Map)libEntry.getValue());
                            continue;
                        }
                        tempMap.putAll((Map)libEntry.getValue());
                    }
                }
                --i;
            }
        }
        Map thisProjectMap = this.doGetConfiguredResources(referenceConfig);
        for (Map.Entry entry : thisProjectMap.entrySet()) {
            ResourceType type = (ResourceType)entry.getKey();
            Map typeMap = (Map)resultMap.get(type);
            if (typeMap == null) {
                resultMap.put(type, (Map)entry.getValue());
                continue;
            }
            typeMap.putAll((Map)entry.getValue());
        }
        return resultMap;
    }

    public ResourceFolder getResourceFolder(IFolder folder) {
        return this.getResourceFolder(new IFolderWrapper(folder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<ResourceType, String> resolveResourceId(int id) {
        Pair<ResourceType, String> result = null;
        if (this.mResIdValueToNameMap != null) {
            result = this.mResIdValueToNameMap.get(id);
        }
        if (result == null) {
            DynamicIdMap dynamicIdMap = this.mDynamicIdMap;
            synchronized (dynamicIdMap) {
                result = this.mDynamicIdMap.resolveId(id);
            }
        }
        return result;
    }

    public String resolveStyleable(int[] id) {
        if (this.mStyleableValueToNameMap != null) {
            this.mWrapper.set(id);
            return this.mStyleableValueToNameMap.get(this.mWrapper);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getResourceId(ResourceType type, String name) {
        Map<String, Integer> map;
        Integer result = null;
        if (this.mResourceValueMap != null && (map = this.mResourceValueMap.get(type)) != null) {
            result = map.get(name);
        }
        if (result == null) {
            DynamicIdMap dynamicIdMap = this.mDynamicIdMap;
            synchronized (dynamicIdMap) {
                result = this.mDynamicIdMap.getId(type, name);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDynamicIds() {
        DynamicIdMap dynamicIdMap = this.mDynamicIdMap;
        synchronized (dynamicIdMap) {
            this.mDynamicIdMap.reset(0x7FFF0000);
        }
    }

    protected ResourceItem createResourceItem(String name) {
        return new ResourceItem(name);
    }

    void setCompiledResources(Map<Integer, Pair<ResourceType, String>> resIdValueToNameMap, Map<IntArrayWrapper, String> styleableValueMap, Map<ResourceType, Map<String, Integer>> resourceValueMap) {
        this.mResourceValueMap = resourceValueMap;
        this.mResIdValueToNameMap = resIdValueToNameMap;
        this.mStyleableValueToNameMap = styleableValueMap;
        this.resetDynamicIds();
    }
}

