/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.refactorings.extractstring;

import org.eclipse.andmore.internal.refactorings.extractstring.ExtractStringRefactoring;
import org.eclipse.andmore.internal.refactorings.extractstring.ExtractStringWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ExtractStringAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow mWindow;
    private ITextSelection mSelection;
    private IEditorPart mEditor;
    private IFile mFile;

    public void init(IWorkbenchWindow window) {
        this.mWindow = window;
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = null;
        this.mFile = null;
        if (selection instanceof ITextSelection) {
            this.mSelection = (ITextSelection)selection;
            if (this.mSelection.getLength() > 0) {
                this.mEditor = this.getActiveEditor();
                this.mFile = this.getSelectedFile(this.mEditor);
            }
        }
        action.setEnabled(this.mSelection != null && this.mFile != null);
    }

    public void run(IAction action) {
        if (this.mSelection != null && this.mFile != null) {
            ExtractStringRefactoring ref = new ExtractStringRefactoring(this.mFile, this.mEditor, this.mSelection);
            ExtractStringWizard wizard = new ExtractStringWizard(ref, this.mFile.getProject());
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                op.run(this.mWindow.getShell(), wizard.getDefaultPageTitle());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow wwin = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wwin != null && (page = wwin.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    private IFile getSelectedFile(IEditorPart editor) {
        FileEditorInput fi;
        IFile file;
        IEditorInput input;
        if (editor != null && (input = editor.getEditorInput()) instanceof FileEditorInput && (file = (fi = (FileEditorInput)input).getFile()).exists()) {
            IProject proj = file.getProject();
            try {
                if (proj != null && proj.hasNature("org.eclipse.andmore.AndroidNature")) {
                    return file;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }
}

