/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.refactorings.core;

import org.eclipse.andmore.internal.refactorings.core.RefactoringUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class FixImportsJob
extends WorkspaceJob {
    private IFile mAndroidManifest;
    private String mJavaPackage;

    public FixImportsJob(String name, IFile androidManifest, String javaPackage) {
        super(name);
        this.mAndroidManifest = androidManifest;
        this.mJavaPackage = javaPackage;
    }

    public IStatus runInWorkspace(final IProgressMonitor monitor) throws CoreException {
        if (this.mJavaPackage == null || this.mAndroidManifest == null || !this.mAndroidManifest.exists()) {
            return Status.CANCEL_STATUS;
        }
        IProject project = this.mAndroidManifest.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.isOpen()) {
            return Status.CANCEL_STATUS;
        }
        project.build(10, monitor);
        IMarker[] markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IResource resource = marker.getResource();
            try {
                String packageName;
                ICompilationUnit cu;
                IPackageFragment packageFragment;
                IJavaElement element = JavaCore.create((IResource)resource);
                if (element != null && element instanceof ICompilationUnit && (packageFragment = (IPackageFragment)(cu = (ICompilationUnit)element).getAncestor(4)) != null && packageFragment.exists() && (packageName = packageFragment.getElementName()) != null && packageName.startsWith(this.mJavaPackage)) {
                    CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)cu, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_ACTIVE_ONLY, null);
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)cu.getJavaProject());
                    final boolean[] hasAmbiguity = new boolean[1];
                    OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

                        public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                            hasAmbiguity[0] = true;
                            return new TypeNameMatch[0];
                        }
                    };
                    final OrganizeImportsOperation op = new OrganizeImportsOperation(cu, astRoot, settings.importIgnoreLowercase, !cu.isWorkingCopy(), true, query);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                                progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)op, op.getScheduleRule()));
                                IEditorPart openEditor = EditorUtility.isOpenInEditor((Object)cu);
                                if (openEditor != null) {
                                    openEditor.doSave(monitor);
                                }
                            }
                            catch (Throwable e) {
                                RefactoringUtil.log(e);
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                RefactoringUtil.log(e);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

