/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.properties;

import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.project.ProjectChooserHelper;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

final class LibraryProperties {
    private Composite mTop;
    private Table mTable;
    private Image mMatchIcon;
    private Image mErrorIcon;
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mUpButton;
    private Button mDownButton;
    private ProjectChooserHelper mProjectChooser;
    private ProjectState mState;
    private ProjectPropertiesWorkingCopy mPropertiesWorkingCopy;
    private final List<ItemData> mItemDataList = new ArrayList<ItemData>();
    private boolean mMustSave = false;
    ProjectChooserHelper.IProjectChooserFilter mFilter = new ProjectChooserHelper.IProjectChooserFilter(){

        @Override
        public boolean accept(IProject project) {
            ProjectState state = Sdk.getProjectState(project);
            if (state != null) {
                if (!state.isLibrary() || project == LibraryProperties.this.mState.getProject()) {
                    return false;
                }
                for (ItemData data : LibraryProperties.this.mItemDataList) {
                    if (data.project != project) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean useCache() {
            return false;
        }
    };

    LibraryProperties(Composite parent) {
        this.mMatchIcon = AndmoreAndroidPlugin.getImageDescriptor("/icons/match.png").createImage();
        this.mErrorIcon = AndmoreAndroidPlugin.getImageDescriptor("/icons/error.png").createImage();
        this.mTop = new Composite(parent, 0);
        this.mTop.setLayout((Layout)new GridLayout(2, false));
        this.mTop.setLayoutData((Object)new GridData(1808));
        this.mTop.setFont(parent.getFont());
        this.mTop.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LibraryProperties.this.mMatchIcon.dispose();
                LibraryProperties.this.mErrorIcon.dispose();
            }
        });
        this.mTable = new Table(this.mTop, 67588);
        this.mTable.setLayoutData((Object)new GridData(1808));
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(false);
        this.mTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryProperties.this.resetEnabled();
            }
        });
        TableColumn column0 = new TableColumn(this.mTable, 0);
        column0.setText("Reference");
        TableColumn column1 = new TableColumn(this.mTable, 0);
        column1.setText("Project");
        Composite buttons = new Composite(this.mTop, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1040));
        this.mProjectChooser = new ProjectChooserHelper(parent.getShell(), this.mFilter);
        this.mAddButton = new Button(buttons, 0x800008);
        this.mAddButton.setLayoutData((Object)new GridData(768));
        this.mAddButton.setText("Add...");
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IJavaProject javaProject = LibraryProperties.this.mProjectChooser.chooseJavaProject(null, "Please select a library project");
                if (javaProject != null) {
                    IProject iProject = javaProject.getProject();
                    IPath relativePath = iProject.getLocation().makeRelativeTo(LibraryProperties.this.mState.getProject().getLocation());
                    LibraryProperties.this.addItem(relativePath.toString(), iProject, -1);
                    LibraryProperties.this.resetEnabled();
                    LibraryProperties.this.mMustSave = true;
                }
            }
        });
        this.mRemoveButton = new Button(buttons, 0x800008);
        this.mRemoveButton.setLayoutData((Object)new GridData(768));
        this.mRemoveButton.setText("Remove");
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selection = LibraryProperties.this.mTable.getSelection()[0];
                ItemData data = (ItemData)selection.getData();
                LibraryProperties.this.mItemDataList.remove(data);
                LibraryProperties.this.mTable.remove(LibraryProperties.this.mTable.getSelectionIndex());
                LibraryProperties.this.resetEnabled();
                LibraryProperties.this.mMustSave = true;
            }
        });
        Label l = new Label(buttons, 258);
        l.setLayoutData((Object)new GridData(768));
        this.mUpButton = new Button(buttons, 0x800008);
        this.mUpButton.setLayoutData((Object)new GridData(768));
        this.mUpButton.setText("Up");
        this.mUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = LibraryProperties.this.mTable.getSelectionIndex();
                ItemData data = (ItemData)LibraryProperties.this.mItemDataList.remove(index);
                LibraryProperties.this.mTable.remove(index);
                LibraryProperties.this.addItem(data.relativePath, data.project, index - 1);
                LibraryProperties.this.mTable.select(index - 1);
                LibraryProperties.this.resetEnabled();
                LibraryProperties.this.mMustSave = true;
            }
        });
        this.mDownButton = new Button(buttons, 0x800008);
        this.mDownButton.setLayoutData((Object)new GridData(768));
        this.mDownButton.setText("Down");
        this.mDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = LibraryProperties.this.mTable.getSelectionIndex();
                ItemData data = (ItemData)LibraryProperties.this.mItemDataList.remove(index);
                LibraryProperties.this.mTable.remove(index);
                LibraryProperties.this.addItem(data.relativePath, data.project, index + 1);
                LibraryProperties.this.mTable.select(index + 1);
                LibraryProperties.this.resetEnabled();
                LibraryProperties.this.mMustSave = true;
            }
        });
        this.adjustColumnsWidth(this.mTable, column0, column1);
    }

    void setContent(ProjectState state, ProjectPropertiesWorkingCopy propertiesWorkingCopy) {
        this.mState = state;
        this.mPropertiesWorkingCopy = propertiesWorkingCopy;
        this.mTable.removeAll();
        this.mItemDataList.clear();
        List<ProjectState.LibraryState> libs = state.getLibraries();
        for (ProjectState.LibraryState lib : libs) {
            ProjectState libState = lib.getProjectState();
            this.addItem(lib.getRelativePath(), libState != null ? libState.getProject() : null, -1);
        }
        this.mMustSave = false;
        this.resetEnabled();
    }

    boolean save() {
        boolean mustSave = this.mMustSave;
        if (this.mMustSave) {
            Set keys = this.mPropertiesWorkingCopy.keySet();
            for (String key : keys) {
                if (!key.startsWith("android.library.reference.")) continue;
                this.mPropertiesWorkingCopy.removeProperty(key);
            }
            int index = 1;
            for (ItemData data : this.mItemDataList) {
                this.mPropertiesWorkingCopy.setProperty("android.library.reference." + index++, data.relativePath);
            }
        }
        this.mMustSave = false;
        return mustSave;
    }

    void setEnabled(boolean enabled) {
        if (!enabled) {
            this.mTable.setEnabled(false);
            this.mAddButton.setEnabled(false);
            this.mRemoveButton.setEnabled(false);
            this.mUpButton.setEnabled(false);
            this.mDownButton.setEnabled(false);
        } else {
            this.mTable.setEnabled(true);
            this.mAddButton.setEnabled(true);
            this.resetEnabled();
        }
    }

    private void resetEnabled() {
        int index = this.mTable.getSelectionIndex();
        this.mRemoveButton.setEnabled(index != -1);
        this.mUpButton.setEnabled(index > 0);
        this.mDownButton.setEnabled(index != -1 && index < this.mTable.getItemCount() - 1);
    }

    private void addItem(String relativePath, IProject project, int index) {
        TableItem item;
        ItemData data = new ItemData();
        data.relativePath = relativePath;
        data.project = project;
        if (index == -1) {
            this.mItemDataList.add(data);
            item = new TableItem(this.mTable, 0);
        } else {
            this.mItemDataList.add(index, data);
            item = new TableItem(this.mTable, 0, index);
        }
        item.setData((Object)data);
        item.setText(0, data.relativePath);
        item.setImage(data.project != null ? this.mMatchIcon : this.mErrorIcon);
        item.setText(1, data.project != null ? data.project.getName() : "?");
    }

    private void adjustColumnsWidth(final Table table, final TableColumn column0, final TableColumn column1) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = table.getClientArea();
                column0.setWidth(r.width * 50 / 100);
                column1.setWidth(r.width * 50 / 100);
            }
        });
    }

    private static final class ItemData {
        String relativePath;
        IProject project;

        private ItemData() {
        }
    }
}

