/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.preferences;

import com.android.ide.common.xml.XmlAttributeSortOrder;
import com.android.sdkuilib.internal.widgets.ResolutionChooserDialog;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EditorsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor mIndentEditor;
    private BooleanFieldEditor mRemoveEmptyEditor;
    private BooleanFieldEditor mOneAttrPerLineEditor;
    private BooleanFieldEditor mSpaceBeforeCloseEditor;
    private BooleanFieldEditor mFormatGuiXmlEditor;

    public EditorsPage() {
        super(1);
        this.setPreferenceStore(AndmoreAndroidPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.addField((FieldEditor)new DensityFieldEditor("org.eclipse.andmore.monitorDensity", "Monitor Density", parent));
        final MyBooleanFieldEditor editor = new MyBooleanFieldEditor("org.eclipse.andmore.androidForm", "Format XML files using the standard Android XML style rather than the \nconfigured Eclipse XML style (additional options below)", parent);
        this.addField((FieldEditor)editor);
        Button checkbox = editor.getChangeControl(parent);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorsPage.this.updateCustomFormattingOptions(editor.getBooleanValue());
            }
        });
        this.mIndentEditor = new BooleanFieldEditor("org.eclipse.andmore.eclipseIndent", "Use Eclipse setting for indentation width and space or tab character indentation \n(Android default is 4 space characters)", parent);
        this.addField((FieldEditor)this.mIndentEditor);
        this.mRemoveEmptyEditor = new BooleanFieldEditor("org.eclipse.andmore.removeEmpty", "Always remove empty lines between elements", parent);
        this.addField((FieldEditor)this.mRemoveEmptyEditor);
        this.mOneAttrPerLineEditor = new BooleanFieldEditor("org.eclipse.andmore.oneAttrPerLine", "Allow single attributes to appear on the same line as their elements", parent);
        this.addField((FieldEditor)this.mOneAttrPerLineEditor);
        this.mSpaceBeforeCloseEditor = new BooleanFieldEditor("org.eclipse.andmore.spaceBeforeClose", "Add a space before the > or /> in opening tags", parent);
        this.addField((FieldEditor)this.mSpaceBeforeCloseEditor);
        this.addField((FieldEditor)new RadioGroupFieldEditor("org.eclipse.andmore.attrSort", "Sort Attributes", 1, (String[][])new String[][]{{"&Logical (id, style, layout attributes, remaining attributes alphabetically)", XmlAttributeSortOrder.LOGICAL.key}, {"&Alphabetical", XmlAttributeSortOrder.ALPHABETICAL.key}, {"&None", XmlAttributeSortOrder.NO_SORTING.key}}, parent, true));
        this.mFormatGuiXmlEditor = new BooleanFieldEditor("org.eclipse.andmore.formatXml", "Automatically format the XML edited by the visual layout editor", parent);
        this.addField((FieldEditor)this.mFormatGuiXmlEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.andmore.formatOnSave", "Format on Save", parent));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.andmore.sharedLayoutEditor", "Use a single layout editor for all configuration variations of a layout", parent));
        boolean enabled = this.getPreferenceStore().getBoolean("org.eclipse.andmore.androidForm");
        this.updateCustomFormattingOptions(enabled);
    }

    private void updateCustomFormattingOptions(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        this.mIndentEditor.setEnabled(enabled, parent);
        this.mRemoveEmptyEditor.setEnabled(enabled, parent);
        this.mOneAttrPerLineEditor.setEnabled(enabled, parent);
        this.mSpaceBeforeCloseEditor.setEnabled(enabled, parent);
        this.mFormatGuiXmlEditor.setEnabled(enabled, parent);
    }

    private static class DensityFieldEditor
    extends StringButtonFieldEditor {
        public DensityFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setChangeButtonText("Compute...");
        }

        protected String changePressed() {
            ResolutionChooserDialog dialog = new ResolutionChooserDialog(this.getShell());
            if (dialog.open() == 0) {
                return Integer.toString(dialog.getDensity());
            }
            return null;
        }
    }

    private class MyBooleanFieldEditor
    extends BooleanFieldEditor {
        public MyBooleanFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        protected Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }
    }
}

