/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.detector.api.TextFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.lint.DocumentFix;
import org.eclipse.andmore.internal.lint.LintFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Node;

final class TypoFix
extends DocumentFix {
    private String mTypo;
    private String mReplacement;

    private TypoFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public String getDisplayString() {
        return String.format("Replace \"%1$s\" by \"%2$s\"", this.mTypo, this.mReplacement);
    }

    @Override
    public boolean needsFocus() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        String message = this.mMarker.getAttribute("message", "");
        String typo = TypoDetector.getTypo((String)message, (TextFormat)TextFormat.TEXT);
        if (typo == null) {
            return;
        }
        List replacements = TypoDetector.getSuggestions((String)message, (TextFormat)TextFormat.TEXT);
        if (replacements == null || replacements.isEmpty()) {
            return;
        }
        try {
            String current = document.get(start, end - start);
            if (current.equals(typo)) {
                document.replace(start, end - start, (String)replacements.get(0));
            } else {
                FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
                IRegion forward = finder.find(start, typo, true, true, true, false);
                IRegion backward = finder.find(start, typo, false, true, true, false);
                if (forward != null && backward != null) {
                    int backwardDelta;
                    int forwardDelta = forward.getOffset() - start;
                    start = forwardDelta < (backwardDelta = start - backward.getOffset()) ? forward.getOffset() : backward.getOffset();
                } else if (forward != null) {
                    start = forward.getOffset();
                } else if (backward != null) {
                    start = backward.getOffset();
                } else {
                    return;
                }
                end = start + typo.length();
                document.replace(start, end - start, (String)replacements.get(0));
            }
        }
        catch (BadLocationException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
    }

    @Override
    protected List<LintFix> getAllFixes() {
        String message = this.mMarker.getAttribute("message", "");
        String typo = TypoDetector.getTypo((String)message, (TextFormat)TextFormat.TEXT);
        List replacements = TypoDetector.getSuggestions((String)message, (TextFormat)TextFormat.TEXT);
        if (replacements != null && !replacements.isEmpty() && typo != null) {
            ArrayList<LintFix> allFixes = new ArrayList<LintFix>(replacements.size());
            for (String replacement : replacements) {
                TypoFix fix = new TypoFix(this.mId, this.mMarker);
                fix.mTypo = typo;
                fix.mReplacement = replacement;
                allFixes.add(fix);
            }
            return allFixes;
        }
        return null;
    }
}

