/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import org.eclipse.andmore.internal.lint.DocumentFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class ObsoleteLayoutParamsFix
extends DocumentFix {
    private ObsoleteLayoutParamsFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public boolean needsFocus() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public boolean isBulkCapable() {
        return false;
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                IndexedRegion region;
                Attr attribute = (Attr)attributes.item(i);
                if (attribute instanceof IndexedRegion && (region = (IndexedRegion)attribute).getStartOffset() == start) {
                    element.removeAttribute(attribute.getName());
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public String getDisplayString() {
        return "Remove attribute";
    }

    @Override
    public Image getImage() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return sharedImages.getImage("IMG_ETOOL_DELETE");
    }
}

