/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.detector.api.LintUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.lint.EclipseLintRunner;
import org.eclipse.andmore.internal.lint.LintFix;
import org.eclipse.andmore.internal.lint.LintFixGenerator;
import org.eclipse.andmore.internal.lint.LintJob;
import org.eclipse.andmore.internal.lint.LintList;
import org.eclipse.andmore.internal.preferences.LintPreferencePage;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.ViewPart;

public class LintViewPart
extends ViewPart
implements SelectionListener,
IJobChangeListener {
    public static final String ID = "org.eclipse.andmore.internal.lint.LintViewPart";
    private static final String QUICKFIX_DISABLED_ICON = "quickfix-disabled";
    private static final String QUICKFIX_ICON = "quickfix";
    private static final String REFRESH_ICON = "refresh";
    private static final String EXPAND_DISABLED_ICON = "expandall-disabled";
    private static final String EXPAND_ICON = "expandall";
    private static final String COLUMNS_ICON = "columns";
    private static final String OPTIONS_ICON = "options";
    private static final String IGNORE_THIS_ICON = "ignore-this";
    private static final String IGNORE_THIS_DISABLED_ICON = "ignore-this-disabled";
    private static final String IGNORE_FILE_ICON = "ignore-file";
    private static final String IGNORE_FILE_DISABLED_ICON = "ignore-file-disabled";
    private static final String IGNORE_PRJ_ICON = "ignore-project";
    private static final String IGNORE_PRJ_DISABLED_ICON = "ignore-project-disabled";
    private static final String IGNORE_ALL_ICON = "ignore-all";
    private static final String IGNORE_ALL_DISABLED_ICON = "ignore-all-disabled";
    private IMemento mMemento;
    private LintList mLintView;
    private Text mDetailsText;
    private Label mErrorLabel;
    private SashForm mSashForm;
    private Action mFixAction;
    private Action mRemoveAction;
    private Action mIgnoreAction;
    private Action mAlwaysIgnoreAction;
    private Action mIgnoreFileAction;
    private Action mIgnoreProjectAction;
    private Action mRemoveAllAction;
    private Action mRefreshAction;
    private Action mExpandAll;
    private Action mCollapseAll;
    private Action mConfigureColumns;
    private Action mOptions;
    private static List<? extends IResource> sInitialResources;
    private static final int ACTION_REFRESH = 1;
    private static final int ACTION_FIX = 2;
    private static final int ACTION_IGNORE_THIS = 3;
    private static final int ACTION_IGNORE_FILE = 4;
    private static final int ACTION_IGNORE_TYPE = 5;
    private static final int ACTION_IGNORE_ALL = 6;
    private static final int ACTION_REMOVE = 7;
    private static final int ACTION_REMOVE_ALL = 8;
    private static final int ACTION_COLLAPSE = 9;
    private static final int ACTION_EXPAND = 10;
    private static final int ACTION_COLUMNS = 11;
    private static final int ACTION_OPTIONS = 12;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.mMemento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.mLintView.saveState(memento);
    }

    public void dispose() {
        if (this.mLintView != null) {
            this.mLintView.dispose();
            this.mLintView = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.mErrorLabel = new Label(parent, 0);
        this.mErrorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mSashForm = new SashForm(parent, 0);
        this.mSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.mLintView = new LintList(this.getSite(), (Composite)this.mSashForm, this.mMemento, false);
        this.mDetailsText = new Text((Composite)this.mSashForm, 2634);
        Display display = parent.getDisplay();
        this.mDetailsText.setBackground(display.getSystemColor(29));
        this.mDetailsText.setForeground(display.getSystemColor(28));
        this.mLintView.addSelectionListener(this);
        this.mSashForm.setWeights(new int[]{8, 2});
        this.createActions();
        this.initializeToolBar();
        this.refreshStopIcon();
        if (sInitialResources != null) {
            this.mLintView.setResources(sInitialResources);
            sInitialResources = null;
        } else {
            IJavaProject[] androidProjects = BaseProjectHelper.getAndroidProjects(null);
            if (androidProjects.length > 0) {
                ArrayList<IProject> projects = new ArrayList<IProject>();
                IJavaProject[] iJavaProjectArray = androidProjects;
                int n = androidProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject project = iJavaProjectArray[n2];
                    projects.add(project.getProject());
                    ++n2;
                }
                this.mLintView.setResources(projects);
            }
        }
        this.updateIssueCount();
    }

    private void createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        IconFactory iconFactory = IconFactory.getInstance();
        this.mFixAction = new LintViewAction("Fix", 2, iconFactory.getImageDescriptor(QUICKFIX_ICON), iconFactory.getImageDescriptor(QUICKFIX_DISABLED_ICON));
        this.mIgnoreAction = new LintViewAction("Suppress this error with an annotation/attribute", 3, iconFactory.getImageDescriptor(IGNORE_THIS_ICON), iconFactory.getImageDescriptor(IGNORE_THIS_DISABLED_ICON));
        this.mIgnoreFileAction = new LintViewAction("Ignore in this file", 4, iconFactory.getImageDescriptor(IGNORE_FILE_ICON), iconFactory.getImageDescriptor(IGNORE_FILE_DISABLED_ICON));
        this.mIgnoreProjectAction = new LintViewAction("Ignore in this project", 5, iconFactory.getImageDescriptor(IGNORE_PRJ_ICON), iconFactory.getImageDescriptor(IGNORE_PRJ_DISABLED_ICON));
        this.mAlwaysIgnoreAction = new LintViewAction("Always Ignore", 6, iconFactory.getImageDescriptor(IGNORE_ALL_ICON), iconFactory.getImageDescriptor(IGNORE_ALL_DISABLED_ICON));
        this.mRemoveAction = new LintViewAction("Remove", 7, sharedImages.getImageDescriptor("IMG_ELCL_REMOVE"), sharedImages.getImageDescriptor("IMG_ELCL_REMOVE_DISABLED"));
        this.mRemoveAllAction = new LintViewAction("Remove All", 8, sharedImages.getImageDescriptor("IMG_ELCL_REMOVEALL"), sharedImages.getImageDescriptor("IMG_ELCL_REMOVEALL_DISABLED"));
        this.mRefreshAction = new LintViewAction("Refresh (& Save Files)", 1, iconFactory.getImageDescriptor(REFRESH_ICON), null);
        this.mRemoveAllAction.setEnabled(true);
        this.mCollapseAll = new LintViewAction("Collapse All", 9, sharedImages.getImageDescriptor("IMG_ELCL_COLLAPSEALL"), sharedImages.getImageDescriptor("IMG_ELCL_COLLAPSEALL_DISABLED"));
        this.mCollapseAll.setEnabled(true);
        this.mExpandAll = new LintViewAction("Expand All", 10, iconFactory.getImageDescriptor(EXPAND_ICON), iconFactory.getImageDescriptor(EXPAND_DISABLED_ICON));
        this.mExpandAll.setEnabled(true);
        this.mConfigureColumns = new LintViewAction("Configure Columns...", 11, iconFactory.getImageDescriptor(COLUMNS_ICON), null);
        this.mOptions = new LintViewAction("Options...", 12, iconFactory.getImageDescriptor(OPTIONS_ICON), null);
        this.enableActions(Collections.<IMarker>emptyList(), false);
    }

    private void initializeToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.mRefreshAction);
        toolbarManager.add((IAction)this.mFixAction);
        toolbarManager.add((IAction)this.mIgnoreAction);
        toolbarManager.add((IAction)this.mIgnoreFileAction);
        toolbarManager.add((IAction)this.mIgnoreProjectAction);
        toolbarManager.add((IAction)this.mAlwaysIgnoreAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.mRemoveAction);
        toolbarManager.add((IAction)this.mRemoveAllAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.mExpandAll);
        toolbarManager.add((IAction)this.mCollapseAll);
        toolbarManager.add((IAction)this.mConfigureColumns);
        toolbarManager.add((IAction)this.mOptions);
    }

    public void setFocus() {
        this.mLintView.setFocus();
    }

    public void setResources(List<? extends IResource> resources) {
        this.mLintView.setResources(resources);
        this.refreshStopIcon();
    }

    private void refreshStopIcon() {
        Job[] currentJobs = LintJob.getCurrentJobs();
        if (currentJobs.length > 0) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.mRefreshAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ELCL_STOP"));
            Job[] jobArray = currentJobs;
            int n = currentJobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                job.addJobChangeListener((IJobChangeListener)this);
                ++n2;
            }
        } else {
            this.mRefreshAction.setImageDescriptor(IconFactory.getInstance().getImageDescriptor(REFRESH_ICON));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        List<IMarker> markers = this.mLintView.getSelectedMarkers();
        if (markers.size() != 1) {
            this.mDetailsText.setText("");
        } else {
            this.mDetailsText.setText(EclipseLintClient.describe(markers.get(0)));
        }
        IStatusLineManager status = this.getViewSite().getActionBars().getStatusLineManager();
        status.setMessage(this.mDetailsText.getText());
        this.updateIssueCount();
        this.enableActions(markers, true);
    }

    private void enableActions(List<IMarker> markers, boolean updateWidgets) {
        boolean hasSelection;
        boolean canFix = hasSelection = markers.size() > 0;
        for (IMarker marker : markers) {
            List<LintFix> fixes;
            if (!LintFix.hasFix(EclipseLintClient.getId(marker))) {
                canFix = false;
                break;
            }
            if (markers.size() <= 1 || (fixes = LintFix.getFixes(EclipseLintClient.getId(marker), marker)) != null && fixes.get(0).isBulkCapable()) continue;
            canFix = false;
            break;
        }
        boolean haveFile = false;
        boolean isJavaOrXml = true;
        for (IMarker marker : markers) {
            IResource resource = marker.getResource();
            if (!(resource instanceof IFile) && !(resource instanceof IFolder)) continue;
            haveFile = true;
            String name = resource.getName();
            if (LintUtils.endsWith((String)name, (String)".xml") || LintUtils.endsWith((String)name, (String)".java")) break;
            isJavaOrXml = false;
            break;
        }
        this.mFixAction.setEnabled(canFix);
        this.mIgnoreAction.setEnabled(hasSelection && haveFile && isJavaOrXml);
        this.mIgnoreFileAction.setEnabled(hasSelection && haveFile);
        this.mIgnoreProjectAction.setEnabled(hasSelection);
        this.mAlwaysIgnoreAction.setEnabled(hasSelection);
        this.mRemoveAction.setEnabled(hasSelection);
        if (updateWidgets) {
            this.getViewSite().getActionBars().getToolBarManager().update(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        List<IMarker> selection;
        Object source = e.getSource();
        if (source == this.mLintView.getTreeViewer().getControl() && (selection = this.mLintView.getSelectedMarkers()).size() > 0) {
            EclipseLintClient.showMarker(selection.get(0));
        }
    }

    public void done(IJobChangeEvent event) {
        this.mRefreshAction.setImageDescriptor(IconFactory.getInstance().getImageDescriptor(REFRESH_ICON));
        if (!this.mLintView.isDisposed()) {
            this.mLintView.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!LintViewPart.this.mLintView.isDisposed()) {
                        LintViewPart.this.updateIssueCount();
                    }
                }
            });
        }
    }

    private void updateIssueCount() {
        int errors = this.mLintView.getErrorCount();
        int warnings = this.mLintView.getWarningCount();
        this.mErrorLabel.setText(String.format("%1$d errors, %2$d warnings", errors, warnings));
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public static void show(List<? extends IResource> projects) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                try {
                    sInitialResources = projects;
                    IViewPart view = page.showView(ID, null, 1);
                    if (sInitialResources != null && view instanceof LintViewPart) {
                        LintViewPart lintView = (LintViewPart)view;
                        lintView.setResources(projects);
                    }
                }
                catch (PartInitException e) {
                    AndmoreAndroidPlugin.log(e, "Cannot open Lint View", new Object[0]);
                    sInitialResources = null;
                }
            }
            finally {
                sInitialResources = null;
            }
        }
    }

    private class LintViewAction
    extends Action {
        private final int mAction;

        private LintViewAction(String label, int action, ImageDescriptor imageDesc, ImageDescriptor disabledImageDesc) {
            super(label);
            this.mAction = action;
            this.setImageDescriptor(imageDesc);
            if (disabledImageDesc != null) {
                this.setDisabledImageDescriptor(disabledImageDesc);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            switch (this.mAction) {
                case 1: {
                    Job[] jobArray;
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench != null) {
                        workbench.saveAllEditors(false);
                    }
                    if ((jobArray = LintJob.getCurrentJobs()).length > 0) {
                        EclipseLintRunner.cancelCurrentJobs(false);
                        break;
                    }
                    List<? extends IResource> resources = LintViewPart.this.mLintView.getResources();
                    if (resources == null) {
                        return;
                    }
                    Job job = EclipseLintRunner.startLint(resources, null, null, false, false);
                    if (job == null || workbench == null) break;
                    job.addJobChangeListener((IJobChangeListener)LintViewPart.this);
                    ISharedImages sharedImages = workbench.getSharedImages();
                    this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ELCL_STOP"));
                    break;
                }
                case 2: {
                    List<IMarker> markers = LintViewPart.this.mLintView.getSelectedMarkers();
                    for (IMarker iMarker : markers) {
                        List<LintFix> fixes = LintFix.getFixes(EclipseLintClient.getId(iMarker), iMarker);
                        if (fixes == null) continue;
                        LintFix fix = fixes.get(0);
                        IResource resource = iMarker.getResource();
                        if (fix.needsFocus() && resource instanceof IFile) {
                            Object var7_34 = null;
                            try {
                                void var7_36;
                                int start = iMarker.getAttribute("charStart", -1);
                                int end = iMarker.getAttribute("charEnd", -1);
                                if (start != -1) {
                                    Region region = new Region(start, end - start);
                                }
                                AndmoreAndroidPlugin.openFile((IFile)resource, (IRegion)var7_36);
                            }
                            catch (PartInitException e) {
                                AndmoreAndroidPlugin.log(e, "Can't open file %1$s", resource);
                            }
                        }
                        TextFileDocumentProvider textFileDocumentProvider = new TextFileDocumentProvider();
                        try {
                            try {
                                textFileDocumentProvider.connect((Object)resource);
                                IDocument document = textFileDocumentProvider.getDocument((Object)resource);
                                if (document != null) {
                                    fix.apply(document);
                                    if (!fix.needsFocus()) {
                                        textFileDocumentProvider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)resource, document, true);
                                    }
                                }
                            }
                            catch (Exception e) {
                                AndmoreAndroidPlugin.log(e, "Did not find associated editor to apply fix: %1$s", resource.getName());
                                textFileDocumentProvider.disconnect((Object)resource);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            textFileDocumentProvider.disconnect((Object)resource);
                            throw throwable;
                        }
                        textFileDocumentProvider.disconnect((Object)resource);
                    }
                    break;
                }
                case 7: {
                    for (IMarker marker : LintViewPart.this.mLintView.getSelectedMarkers()) {
                        try {
                            marker.delete();
                        }
                        catch (CoreException e) {
                            AndmoreAndroidPlugin.log(e, null, new Object[0]);
                        }
                    }
                    break;
                }
                case 8: {
                    List<? extends IResource> resources = LintViewPart.this.mLintView.getResources();
                    if (resources == null) break;
                    for (IResource iResource : resources) {
                        EclipseLintClient.clearMarkers(iResource);
                    }
                    break;
                }
                case 6: {
                    assert (false);
                    break;
                }
                case 4: 
                case 5: {
                    boolean ignoreInFile = this.mAction == 4;
                    for (IMarker iMarker : LintViewPart.this.mLintView.getSelectedMarkers()) {
                        String id = EclipseLintClient.getId(iMarker);
                        if (id == null) continue;
                        IResource resource = iMarker.getResource();
                        LintFixGenerator.suppressDetector(id, true, (IResource)(ignoreInFile ? resource : resource.getProject()), ignoreInFile);
                    }
                    break;
                }
                case 3: {
                    for (IMarker marker : LintViewPart.this.mLintView.getSelectedMarkers()) {
                        LintFixGenerator.addSuppressAnnotation(marker);
                    }
                    break;
                }
                case 9: {
                    LintViewPart.this.mLintView.collapseAll();
                    break;
                }
                case 10: {
                    LintViewPart.this.mLintView.expandAll();
                    break;
                }
                case 11: {
                    LintViewPart.this.mLintView.configureColumns();
                    break;
                }
                case 12: {
                    PreferenceManager manager = new PreferenceManager();
                    LintPreferencePage lintPreferencePage = new LintPreferencePage();
                    String title = "Default/Global Settings";
                    lintPreferencePage.setTitle(title);
                    PreferenceNode node = new PreferenceNode(title, (IPreferencePage)lintPreferencePage);
                    manager.addToRoot((IPreferenceNode)node);
                    List<? extends IResource> resources = LintViewPart.this.mLintView.getResources();
                    if (resources != null) {
                        HashSet<IProject> projects = new HashSet<IProject>();
                        for (IResource iResource : resources) {
                            projects.add(iResource.getProject());
                        }
                        if (projects.size() > 0) {
                            for (IProject iProject : projects) {
                                LintPreferencePage lintPreferencePage2 = new LintPreferencePage();
                                lintPreferencePage2.setTitle(String.format("Settings for %1$s", iProject.getName()));
                                lintPreferencePage2.setElement((IAdaptable)iProject);
                                node = new PreferenceNode(iProject.getName(), (IPreferencePage)lintPreferencePage2);
                                manager.addToRoot((IPreferenceNode)node);
                            }
                        }
                    }
                    Shell shell = LintViewPart.this.getSite().getShell();
                    PreferenceDialog preferenceDialog = new PreferenceDialog(shell, manager);
                    preferenceDialog.create();
                    preferenceDialog.setSelectedNode(title);
                    preferenceDialog.open();
                    break;
                }
                default: {
                    assert (false) : this.mAction;
                    break;
                }
            }
            LintViewPart.this.updateIssueCount();
        }
    }
}

