/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.lint.AddSuppressAttribute;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.lint.LintFix;
import org.eclipse.andmore.internal.lint.LintFixGenerator;
import org.eclipse.andmore.internal.lint.LintList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

class LintListDialog
extends TitleAreaDialog
implements SelectionListener {
    private static final String PROJECT_LOGO_LARGE = "android-64";
    private final IFile mFile;
    private final IEditorPart mEditor;
    private Button mFixButton;
    private Button mIgnoreButton;
    private Button mIgnoreAllButton;
    private Button mShowButton;
    private Text mDetailsText;
    private Button mIgnoreTypeButton;
    private LintList mList;

    LintListDialog(Shell parentShell, IFile file, IEditorPart editor) {
        super(parentShell);
        this.mFile = file;
        this.mEditor = editor;
        this.setHelpAvailable(false);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x20 | 0x10);
    }

    public boolean close() {
        this.mList.dispose();
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Lint Warnings in Layout");
        this.setMessage("Lint Errors found for the current layout:");
        this.setTitleImage(IconFactory.getInstance().getIcon(PROJECT_LOGO_LARGE));
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPartSite site = null;
        if (page.getActivePart() != null) {
            site = page.getActivePart().getSite();
        }
        this.mList = new LintList(site, container, null, true);
        this.mList.setLayoutData(new GridData(4, 4, true, true, 1, 6));
        this.mShowButton = new Button(container, 0);
        this.mShowButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mShowButton.setText("Show");
        this.mShowButton.setToolTipText("Opens the editor to reveal the XML with the issue");
        this.mShowButton.addSelectionListener((SelectionListener)this);
        this.mFixButton = new Button(container, 0);
        this.mFixButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mFixButton.setText("Fix");
        this.mFixButton.setToolTipText("Automatically corrects the problem, if possible");
        this.mFixButton.setEnabled(false);
        this.mFixButton.addSelectionListener((SelectionListener)this);
        this.mIgnoreButton = new Button(container, 0);
        this.mIgnoreButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mIgnoreButton.setText("Suppress Issue");
        this.mIgnoreButton.setToolTipText("Adds a special attribute in the layout to suppress this specific warning");
        this.mIgnoreButton.addSelectionListener((SelectionListener)this);
        this.mIgnoreAllButton = new Button(container, 0);
        this.mIgnoreAllButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mIgnoreAllButton.setText("Suppress in Layout");
        this.mIgnoreAllButton.setEnabled(this.mEditor instanceof AndroidXmlEditor);
        this.mIgnoreAllButton.setToolTipText("Adds an attribute on the root element to suppress all issues of this type in this layout");
        this.mIgnoreAllButton.addSelectionListener((SelectionListener)this);
        this.mIgnoreTypeButton = new Button(container, 0);
        this.mIgnoreTypeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.mIgnoreTypeButton.setText("Disable Issue Type");
        this.mIgnoreTypeButton.setToolTipText("Turns off checking for this type of error everywhere");
        this.mIgnoreTypeButton.addSelectionListener((SelectionListener)this);
        new Label(container, 0);
        this.mDetailsText = new Text(container, 2634);
        Display display = parent.getDisplay();
        this.mDetailsText.setBackground(display.getSystemColor(29));
        this.mDetailsText.setForeground(display.getSystemColor(28));
        GridData gdText = new GridData(4, 0x1000000, true, false, 1, 1);
        gdText.heightHint = 80;
        this.mDetailsText.setLayoutData((Object)gdText);
        new Label(container, 0);
        this.mList.addSelectionListener(this);
        this.mList.setResources(Collections.singletonList(this.mFile));
        this.mList.selectFirst();
        if (this.mList.getSelectedMarkers().size() > 0) {
            this.updateSelectionState();
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(600, 400);
    }

    private void selectMarker(IMarker marker) {
        if (marker == null) {
            this.mDetailsText.setText("");
            return;
        }
        this.mDetailsText.setText(EclipseLintClient.describe(marker));
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.mList.getTreeViewer().getControl()) {
            this.updateSelectionState();
        } else if (source == this.mShowButton) {
            List<IMarker> selection = this.mList.getSelectedMarkers();
            if (selection.size() > 0) {
                EclipseLintClient.showMarker(selection.get(0));
            }
        } else if (source == this.mFixButton) {
            List<IMarker> selection = this.mList.getSelectedMarkers();
            for (IMarker marker : selection) {
                List<LintFix> fixes = LintFix.getFixes(EclipseLintClient.getId(marker), marker);
                if (fixes == null) continue;
                LintFix fix = fixes.get(0);
                IEditorPart editor = AdtUtils.getActiveEditor();
                if (editor instanceof AndroidXmlEditor) {
                    IStructuredDocument doc = ((AndroidXmlEditor)editor).getStructuredDocument();
                    fix.apply((IDocument)doc);
                    if (!fix.needsFocus()) continue;
                    this.close();
                    continue;
                }
                AndmoreAndroidPlugin.log(4, "Did not find associated editor to apply fix", new Object[0]);
            }
        } else if (source == this.mIgnoreTypeButton) {
            for (IMarker marker : this.mList.getSelectedMarkers()) {
                String id = EclipseLintClient.getId(marker);
                if (id == null) continue;
                LintFixGenerator.suppressDetector(id, true, (IResource)this.mFile, true);
            }
        } else if (source == this.mIgnoreButton) {
            for (IMarker marker : this.mList.getSelectedMarkers()) {
                LintFixGenerator.addSuppressAnnotation(marker);
            }
        } else if (source == this.mIgnoreAllButton) {
            HashSet<String> ids = new HashSet<String>();
            for (IMarker marker : this.mList.getSelectedMarkers()) {
                AndroidXmlEditor editor;
                AddSuppressAttribute fix;
                String id = EclipseLintClient.getId(marker);
                if (id == null || ids.contains(id)) continue;
                ids.add(id);
                if (!(this.mEditor instanceof AndroidXmlEditor) || (fix = AddSuppressAttribute.createFixForAll(editor = (AndroidXmlEditor)this.mEditor, marker, id)) == null) continue;
                IStructuredDocument document = editor.getStructuredDocument();
                fix.apply((IDocument)document);
            }
            this.mList.refresh();
        }
    }

    private void updateSelectionState() {
        List<IMarker> selection = this.mList.getSelectedMarkers();
        if (selection.size() == 1) {
            this.selectMarker(selection.get(0));
        } else {
            this.selectMarker(null);
        }
        boolean canFix = selection.size() > 0;
        for (IMarker marker : selection) {
            List<LintFix> fixes;
            if (!LintFix.hasFix(EclipseLintClient.getId(marker))) {
                canFix = false;
                break;
            }
            if (selection.size() <= 1 || (fixes = LintFix.getFixes(EclipseLintClient.getId(marker), marker)) != null && fixes.get(0).isBulkCapable()) continue;
            canFix = false;
            break;
        }
        this.mFixButton.setEnabled(canFix);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        List<IMarker> selection;
        Object source = e.getSource();
        if (source == this.mList.getTreeViewer().getControl() && (selection = this.mList.getSelectedMarkers()).size() > 0) {
            EclipseLintClient.showMarker(selection.get(0));
            this.close();
        }
    }
}

