/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.detector.api.Issue;
import java.io.File;
import java.util.Comparator;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtUtils;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.lint.LintFix;
import org.eclipse.andmore.internal.lint.LintList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

abstract class LintColumn
implements Comparator<IMarker> {
    protected final LintList mList;

    protected LintColumn(LintList list) {
        this.mList = list;
    }

    public boolean isVisibleByDefault() {
        return true;
    }

    public boolean isLeftAligned() {
        return true;
    }

    public int getPreferredWidth() {
        return this.getPreferredCharWidth() * SwtUtils.getAverageCharWidth(this.mList.getDisplay(), this.mList.getTree().getFont());
    }

    public int getPreferredCharWidth() {
        return 15;
    }

    public abstract String getColumnHeaderText();

    public Image getColumnHeaderImage() {
        return null;
    }

    public abstract String getValue(IMarker var1);

    public StyledString getStyledValue(IMarker marker) {
        return null;
    }

    public Image getImage(IMarker marker) {
        return null;
    }

    public Font getFont(IMarker marker) {
        return null;
    }

    public boolean isAscending() {
        return true;
    }

    public boolean visibleByDefault() {
        return true;
    }

    @Override
    public int compare(IMarker o1, IMarker o2) {
        return this.getValue(o1).compareTo(this.getValue(o2));
    }

    public String toString() {
        return this.getColumnHeaderText();
    }

    static class CategoryColumn
    extends LintColumn {
        public CategoryColumn(LintList list) {
            super(list);
        }

        @Override
        public String getColumnHeaderText() {
            return "Category";
        }

        @Override
        public int getPreferredCharWidth() {
            return 20;
        }

        @Override
        public String getValue(IMarker marker) {
            Issue issue = this.mList.getIssue(marker);
            if (issue != null) {
                return issue.getCategory().getFullName();
            }
            return "";
        }
    }

    static class FileColumn
    extends LintColumn {
        public FileColumn(LintList list) {
            super(list);
        }

        @Override
        public String getColumnHeaderText() {
            return "File";
        }

        @Override
        public boolean visibleByDefault() {
            return false;
        }

        @Override
        public int getPreferredCharWidth() {
            return 12;
        }

        @Override
        public String getValue(IMarker marker) {
            if (marker.getResource() instanceof IFile) {
                return marker.getResource().getName();
            }
            return "";
        }
    }

    static class LineColumn
    extends LintColumn {
        public LineColumn(LintList list) {
            super(list);
        }

        @Override
        public String getColumnHeaderText() {
            return "Line";
        }

        @Override
        public boolean visibleByDefault() {
            return false;
        }

        @Override
        public boolean isLeftAligned() {
            return false;
        }

        @Override
        public int getPreferredCharWidth() {
            return 4;
        }

        @Override
        public String getValue(IMarker marker) {
            int line = this.getLine(marker);
            if (line >= 1) {
                return Integer.toString(line);
            }
            return "";
        }

        private int getLine(IMarker marker) {
            if (marker.getResource() instanceof IFile) {
                int line = marker.getAttribute("lineNumber", -1);
                return line;
            }
            return -1;
        }

        @Override
        public int compare(IMarker marker1, IMarker marker2) {
            return this.getLine(marker1) - this.getLine(marker2);
        }
    }

    static class LocationColumn
    extends LintColumn {
        public LocationColumn(LintList list) {
            super(list);
        }

        @Override
        public String getColumnHeaderText() {
            return "Location";
        }

        @Override
        public int getPreferredCharWidth() {
            return 35;
        }

        @Override
        public String getValue(IMarker marker) {
            return this.getStyledValue(marker).toString();
        }

        @Override
        public StyledString getStyledValue(IMarker marker) {
            StyledString styledString = new StyledString();
            IResource resource = marker.getResource();
            if (resource instanceof IProject) {
                styledString.append(resource.getName());
            } else {
                styledString.append(resource.getName());
                if (resource instanceof IFile) {
                    int line = marker.getAttribute("lineNumber", -1);
                    if (line > 1) {
                        styledString.append(':').append(Integer.toString(line));
                    }
                } else if (resource instanceof IFolder) {
                    styledString.append(File.separatorChar);
                }
                if (!(resource.getParent() instanceof IProject)) {
                    styledString.append(" in ");
                    styledString.append(resource.getParent().getName(), StyledString.DECORATIONS_STYLER);
                }
                styledString.append(String.format(" (%1$s)", resource.getProject().getName()), StyledString.QUALIFIER_STYLER);
            }
            return styledString;
        }

        @Override
        public int compare(IMarker marker1, IMarker marker2) {
            IResource resource1 = marker1.getResource();
            IResource resource2 = marker2.getResource();
            IProject project1 = resource1.getProject();
            IProject project2 = resource2.getProject();
            int delta = project1.getName().compareTo(project2.getName());
            if (delta != 0) {
                return delta;
            }
            delta = resource1.getName().compareTo(resource2.getName());
            if (delta != 0) {
                return delta;
            }
            return marker1.getAttribute("lineNumber", 0) - marker2.getAttribute("lineNumber", 0);
        }
    }

    static class MessageColumn
    extends LintColumn {
        public MessageColumn(LintList list) {
            super(list);
        }

        @Override
        public String getColumnHeaderText() {
            return "Description";
        }

        @Override
        public int getPreferredCharWidth() {
            return 80;
        }

        @Override
        public String getValue(IMarker marker) {
            return this.getStyledValue(marker).toString();
        }

        @Override
        public StyledString getStyledValue(IMarker marker) {
            StyledString styledString = new StyledString();
            String message = marker.getAttribute("message", "");
            styledString.append(message);
            int count = this.mList.getCount(marker);
            if (count > 1) {
                styledString.append(String.format(" (%2$d items)", message, count), StyledString.COUNTER_STYLER);
            }
            return styledString;
        }

        @Override
        public Image getImage(IMarker marker) {
            int severity = marker.getAttribute("severity", 0);
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            switch (severity) {
                case 2: {
                    if (LintFix.hasFix(EclipseLintClient.getId(marker))) {
                        return IconFactory.getInstance().getIcon("quickfix_error");
                    }
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
                case 1: {
                    if (LintFix.hasFix(EclipseLintClient.getId(marker))) {
                        return IconFactory.getInstance().getIcon("quickfix_warning");
                    }
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                case 0: {
                    return sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return null;
        }

        @Override
        public Font getFont(IMarker marker) {
            int severity = marker.getAttribute("severity", 0);
            if (severity == 2) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
            return null;
        }

        @Override
        public boolean isAscending() {
            return false;
        }

        @Override
        public int compare(IMarker marker2, IMarker marker1) {
            String id1 = EclipseLintClient.getId(marker1);
            String id2 = EclipseLintClient.getId(marker2);
            if (id1 == null || id2 == null) {
                return marker1.getResource().getName().compareTo(marker2.getResource().getName());
            }
            Issue issue1 = this.mList.getIssue(id1);
            Issue issue2 = this.mList.getIssue(id2);
            if (issue1 == null || issue2 == null) {
                return id1.compareTo(id2);
            }
            int delta = this.mList.getSeverity(issue1).ordinal() - this.mList.getSeverity(issue2).ordinal();
            if (delta != 0) {
                return delta;
            }
            delta = issue2.getPriority() - issue1.getPriority();
            if (delta != 0) {
                return delta;
            }
            delta = issue1.getCategory().compareTo(issue2.getCategory());
            if (delta != 0) {
                return delta;
            }
            delta = id1.compareTo(id2);
            if (delta != 0) {
                return delta;
            }
            IResource resource1 = marker1.getResource();
            IResource resource2 = marker2.getResource();
            IProject project1 = resource1.getProject();
            IProject project2 = resource2.getProject();
            delta = project1.getName().compareTo(project2.getName());
            if (delta != 0) {
                return delta;
            }
            delta = resource1.getName().compareTo(resource2.getName());
            if (delta != 0) {
                return delta;
            }
            return marker1.getAttribute("lineNumber", 0) - marker2.getAttribute("lineNumber", 0);
        }
    }

    static class PathColumn
    extends LintColumn {
        public PathColumn(LintList list) {
            super(list);
        }

        @Override
        public String getColumnHeaderText() {
            return "Path";
        }

        @Override
        public boolean visibleByDefault() {
            return false;
        }

        @Override
        public int getPreferredCharWidth() {
            return 25;
        }

        @Override
        public String getValue(IMarker marker) {
            return marker.getResource().getFullPath().toOSString();
        }
    }

    static class PriorityColumn
    extends LintColumn {
        public PriorityColumn(LintList list) {
            super(list);
        }

        @Override
        public String getColumnHeaderText() {
            return "Priority";
        }

        @Override
        public boolean visibleByDefault() {
            return false;
        }

        @Override
        public boolean isLeftAligned() {
            return false;
        }

        @Override
        public int getPreferredCharWidth() {
            return 2;
        }

        @Override
        public String getValue(IMarker marker) {
            int priority = this.getPriority(marker);
            if (priority > 0) {
                return Integer.toString(priority);
            }
            return "";
        }

        private int getPriority(IMarker marker) {
            Issue issue = this.mList.getIssue(marker);
            if (issue != null) {
                return issue.getPriority();
            }
            return 0;
        }

        @Override
        public int compare(IMarker marker1, IMarker marker2) {
            return this.getPriority(marker1) - this.getPriority(marker2);
        }

        @Override
        public boolean isAscending() {
            return false;
        }
    }
}

