/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import org.eclipse.andmore.internal.lint.DocumentFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class LinearLayoutWeightFix
extends DocumentFix {
    private LinearLayoutWeightFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public boolean needsFocus() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        if (node instanceof Element && node.getParentNode() instanceof Element) {
            Element element = (Element)node;
            Element parent = (Element)node.getParentNode();
            String dimension = "vertical".equals(parent.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation")) ? "layout_height" : "layout_width";
            element.setAttributeNS("http://schemas.android.com/apk/res/android", dimension, "0dp");
        }
    }

    @Override
    public String getDisplayString() {
        return "Replace size attribute with 0dp";
    }

    @Override
    public Image getImage() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return sharedImages.getImage("IMG_OBJ_ELEMENTS");
    }
}

