/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch.junit;

import com.android.ddmlib.IDevice;
import com.google.common.base.Joiner;
import java.util.Collection;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.launch.DelayedLaunchInfo;
import org.eclipse.andmore.internal.launch.IAndroidLaunchAction;
import org.eclipse.andmore.internal.launch.LaunchMessages;
import org.eclipse.andmore.internal.launch.junit.runtime.AndroidJUnitLaunchInfo;
import org.eclipse.andmore.internal.launch.junit.runtime.RemoteAdtTestRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.swt.widgets.Display;

class AndroidJUnitLaunchAction
implements IAndroidLaunchAction {
    private static final Joiner JOINER = Joiner.on((char)',').skipNulls();
    private final AndroidJUnitLaunchInfo mLaunchInfo;

    public AndroidJUnitLaunchAction(AndroidJUnitLaunchInfo launchInfo) {
        this.mLaunchInfo = launchInfo;
    }

    @Override
    public boolean doLaunchAction(DelayedLaunchInfo info, Collection<IDevice> devices) {
        String msg = String.format(LaunchMessages.AndroidJUnitLaunchAction_LaunchInstr_2s, this.mLaunchInfo.getRunner(), JOINER.join(devices));
        AndmoreAndroidPlugin.printToConsole(info.getProject(), msg);
        try {
            this.mLaunchInfo.setDebugMode(info.isDebugMode());
            this.mLaunchInfo.setDevices(devices);
            JUnitLaunchDelegate junitDelegate = new JUnitLaunchDelegate(this.mLaunchInfo);
            String mode = info.isDebugMode() ? "debug" : "run";
            junitDelegate.launch(info.getLaunch().getLaunchConfiguration(), mode, (ILaunch)info.getLaunch(), info.getMonitor());
        }
        catch (CoreException coreException) {
            AndmoreAndroidPlugin.printErrorToConsole(info.getProject(), new Object[]{LaunchMessages.AndroidJUnitLaunchAction_LaunchFail});
        }
        return true;
    }

    @Override
    public String getLaunchDescription() {
        return String.format(LaunchMessages.AndroidJUnitLaunchAction_LaunchDesc_s, this.mLaunchInfo.getRunner());
    }

    private static class JUnitLaunchDelegate
    extends JUnitLaunchConfigurationDelegate {
        private AndroidJUnitLaunchInfo mLaunchInfo;

        public JUnitLaunchDelegate(AndroidJUnitLaunchInfo launchInfo) {
            this.mLaunchInfo = launchInfo;
        }

        public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            super.launch(configuration, mode, launch, monitor);
        }

        public String verifyMainTypeName(ILaunchConfiguration configuration) {
            return "org.eclipse.andmore.junit.internal.runner.RemoteAndroidTestRunner";
        }

        public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) {
            return new VMTestRunner(this.mLaunchInfo);
        }

        public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) {
            return this.mLaunchInfo.getLaunch();
        }
    }

    private static class TestRunnerProcess
    implements IProcess {
        private final VMRunnerConfiguration mRunConfig;
        private final AndroidJUnitLaunchInfo mJUnitInfo;
        private RemoteAdtTestRunner mTestRunner = null;
        private boolean mIsTerminated = false;

        TestRunnerProcess(VMRunnerConfiguration runConfig, AndroidJUnitLaunchInfo info) {
            this.mRunConfig = runConfig;
            this.mJUnitInfo = info;
        }

        public String getAttribute(String key) {
            return null;
        }

        public int getExitValue() {
            return 0;
        }

        public String getLabel() {
            return this.mJUnitInfo.getLaunch().getLaunchMode();
        }

        public ILaunch getLaunch() {
            return this.mJUnitInfo.getLaunch();
        }

        public IStreamsProxy getStreamsProxy() {
            return null;
        }

        public void setAttribute(String key, String value) {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean canTerminate() {
            return true;
        }

        public boolean isTerminated() {
            return this.mIsTerminated;
        }

        public void terminate() {
            if (this.mTestRunner != null) {
                this.mTestRunner.terminate();
            }
            this.mIsTerminated = true;
        }

        public void run() {
            if (Display.getCurrent() != null) {
                AndmoreAndroidPlugin.log(4, "Adt test runner executed on UI thread", new Object[0]);
                AndmoreAndroidPlugin.printErrorToConsole(this.mJUnitInfo.getProject(), new Object[]{"Test launch failed due to internal error: Running tests on UI thread"});
                this.terminate();
                return;
            }
            this.mTestRunner = new RemoteAdtTestRunner();
            this.mTestRunner.runTests(this.mRunConfig.getProgramArguments(), this.mJUnitInfo);
        }
    }

    private static class VMTestRunner
    implements IVMRunner {
        private final AndroidJUnitLaunchInfo mJUnitInfo;

        VMTestRunner(AndroidJUnitLaunchInfo info) {
            this.mJUnitInfo = info;
        }

        public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            TestRunnerProcess runnerProcess = new TestRunnerProcess(config, this.mJUnitInfo);
            launch.addProcess((IProcess)runnerProcess);
            runnerProcess.run();
        }
    }
}

