/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import java.io.IOException;
import java.net.URL;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.osgi.framework.Bundle;

public class JUnitLaunchConfigDelegate
extends JUnitLaunchConfigurationDelegate {
    private static final String JUNIT_JAR = "junit.jar";

    public String[][] getBootpathExt(ILaunchConfiguration configuration) throws CoreException {
        String[][] bootpath = super.getBootpathExt(configuration);
        return JUnitLaunchConfigDelegate.fixBootpathExt(bootpath);
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = super.getClasspath(configuration);
        return JUnitLaunchConfigDelegate.fixClasspath(classpath, this.getJavaProjectName(configuration));
    }

    public static String[][] fixBootpathExt(String[][] bootpath) {
        int i = 0;
        while (i < bootpath.length) {
            if (bootpath[i] != null && bootpath[i].length > 0 && bootpath[i][0].endsWith("android.jar")) {
                bootpath[i] = null;
            }
            ++i;
        }
        return bootpath;
    }

    public static String[] fixClasspath(String[] classpath, String projectName) {
        int i = 0;
        while (i < classpath.length) {
            if (classpath[i].endsWith(JUNIT_JAR)) {
                return classpath;
            }
            ++i;
        }
        try {
            String jarLocation = JUnitLaunchConfigDelegate.getJunitJarLocation();
            String[] newClasspath = new String[classpath.length + 1];
            System.arraycopy(classpath, 0, newClasspath, 0, classpath.length);
            newClasspath[newClasspath.length - 1] = jarLocation;
            classpath = newClasspath;
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.log(e, "Could not find a valid junit.jar", new Object[0]);
            AndmoreAndroidPlugin.printErrorToConsole(projectName, "Could not find a valid junit.jar");
        }
        return classpath;
    }

    public static String getJunitJarLocation() throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.junit");
        if (bundle == null) {
            throw new IOException("Cannot find org.junit bundle");
        }
        URL jarUrl = bundle.getEntry("/junit.jar");
        return FileLocator.resolve((URL)jarUrl).getFile();
    }
}

