/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.values;

import com.android.resources.ResourceFolderType;
import com.android.xml.AndroidXPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.common.CommonXmlDelegate;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.values.ValuesContentAssist;
import org.eclipse.andmore.internal.editors.values.ValuesTreePage;
import org.eclipse.andmore.internal.editors.values.descriptors.ValuesDescriptors;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ValuesEditorDelegate
extends CommonXmlDelegate {
    public static final String LEGACY_EDITOR_ID = "org.eclipse.andmore.editors.resources.ResourcesEditor";

    private ValuesEditorDelegate(CommonXmlEditor editor) {
        super(editor, new ValuesContentAssist());
        editor.addDefaultTargetListener();
    }

    @Override
    public void delegateCreateFormPages() {
        try {
            this.getEditor().addPage((IFormPage)new ValuesTreePage(this.getEditor()));
        }
        catch (PartInitException e) {
            AndmoreAndroidPlugin.log(4, "Error creating nested page", new Object[0]);
            AndmoreAndroidPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    @Override
    public void delegateXmlModelChanged(Document xml_doc) {
        this.delegateInitUiRootNode(false);
        this.getUiRootNode().setXmlDocument(xml_doc);
        if (xml_doc != null) {
            ElementDescriptor resources_desc = ValuesDescriptors.getInstance().getElementDescriptor();
            try {
                XPath xpath = AndroidXPathFactory.newXPath();
                Node node = (Node)xpath.evaluate("/" + resources_desc.getXmlName(), xml_doc, XPathConstants.NODE);
                assert (node == null || node.getNodeName().equals(resources_desc.getXmlName()));
                this.getUiRootNode().loadFromXmlNode(node);
            }
            catch (XPathExpressionException e) {
                AndmoreAndroidPlugin.log(e, "XPath error when trying to find '%s' element in XML.", resources_desc.getXmlName());
            }
        }
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.getUiRootNode() == null || force) {
            ElementDescriptor resources_desc = ValuesDescriptors.getInstance().getElementDescriptor();
            this.setUiRootNode(resources_desc.createUiNode());
            this.getUiRootNode().setEditor(this.getEditor());
            this.onDescriptorsChanged();
        }
    }

    private void onDescriptorsChanged() {
    }

    /* synthetic */ ValuesEditorDelegate(CommonXmlEditor commonXmlEditor, ValuesEditorDelegate valuesEditorDelegate) {
        this(commonXmlEditor);
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public ValuesEditorDelegate createForFile(CommonXmlEditor delegator, ResourceFolderType type) {
            if (ResourceFolderType.VALUES == type) {
                return new ValuesEditorDelegate(delegator, null);
            }
            return null;
        }
    }
}

