/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.uimodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.descriptors.FlagAttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.TextAttributeDescriptor;
import org.eclipse.andmore.internal.editors.ui.SectionHelper;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiTextAttributeNode;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiFlagAttributeNode
extends UiTextAttributeNode {
    public UiFlagAttributeNode(FlagAttributeDescriptor attributeDescriptor, UiElementNode uiParent) {
        super(attributeDescriptor, uiParent);
    }

    @Override
    public void createUiControl(Composite parent, IManagedForm managedForm) {
        this.setManagedForm(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        TextAttributeDescriptor desc = (TextAttributeDescriptor)this.getDescriptor();
        Label label = toolkit.createLabel(parent, desc.getUiName());
        label.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)label, DescriptorsUtils.formatTooltip(desc.getTooltip()));
        Composite composite = toolkit.createComposite(parent);
        composite.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        toolkit.paintBordersFor(composite);
        Text text = toolkit.createText(composite, this.getCurrentValue());
        GridData gd = new GridData(768);
        gd.horizontalIndent = 1;
        text.setLayoutData((Object)gd);
        final Button selectButton = toolkit.createButton(composite, "Select...", 8);
        this.setTextWidget(text);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String currentText = UiFlagAttributeNode.this.getTextWidgetValue();
                String result = UiFlagAttributeNode.this.showDialog(selectButton.getShell(), currentText);
                if (result != null) {
                    UiFlagAttributeNode.this.setTextWidgetValue(result);
                }
            }
        });
    }

    @Override
    public String[] getPossibleValues(String prefix) {
        UiElementNode uiNode;
        AndroidXmlEditor editor;
        AndroidTargetData data;
        String attr_name = this.getDescriptor().getXmlLocalName();
        String element_name = this.getUiParent().getDescriptor().getXmlName();
        String[] values = null;
        if (this.getDescriptor() instanceof FlagAttributeDescriptor && ((FlagAttributeDescriptor)this.getDescriptor()).getNames() != null) {
            values = ((FlagAttributeDescriptor)this.getDescriptor()).getNames();
        }
        if (values == null && (data = (editor = (uiNode = this.getUiParent()).getEditor()).getTargetData()) != null) {
            values = data.getAttributeValues(element_name, attr_name);
        }
        return values;
    }

    public String showDialog(Shell shell, String currentValue) {
        FlagSelectionDialog dlg = new FlagSelectionDialog(shell, currentValue.trim().split("\\s*\\|\\s*"));
        dlg.open();
        Object[] result = dlg.getResult();
        if (result != null) {
            StringBuilder buf = new StringBuilder();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                if (name instanceof String) {
                    if (buf.length() > 0) {
                        buf.append('|');
                    }
                    buf.append(name);
                }
                ++n2;
            }
            return buf.toString();
        }
        return null;
    }

    private class FlagSelectionDialog
    extends SelectionStatusDialog {
        private Set<String> mCurrentSet;
        private Table mTable;

        public FlagSelectionDialog(Shell parentShell, String[] currentNames) {
            super(parentShell);
            this.mCurrentSet = new HashSet<String>();
            String[] stringArray = currentNames;
            int n = currentNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.length() > 0) {
                    this.mCurrentSet.add(name);
                }
                ++n2;
            }
            int shellStyle = this.getShellStyle();
            this.setShellStyle(shellStyle | 0x400 | 0x10);
        }

        protected void computeResult() {
            if (this.mTable != null) {
                ArrayList<String> results = new ArrayList<String>();
                TableItem[] tableItemArray = this.mTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        results.add((String)item.getData());
                    }
                    ++n2;
                }
                this.setResult(results);
            }
        }

        protected Control createDialogArea(Composite parent) {
            TableItem item;
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
            label.setText(String.format("Select the flag values for attribute %1$s:", ((FlagAttributeDescriptor)UiFlagAttributeNode.this.getDescriptor()).getUiName()));
            this.mTable = new Table(composite, 2080);
            GridData data = new GridData();
            data.widthHint = this.convertWidthInCharsToPixels(60);
            data.heightHint = this.convertHeightInCharsToPixels(18);
            data.grabExcessVerticalSpace = true;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            this.mTable.setLayoutData((Object)data);
            this.mTable.setHeaderVisible(false);
            final TableColumn column = new TableColumn(this.mTable, 0);
            String[] names = UiFlagAttributeNode.this.getPossibleValues(null);
            if (names != null) {
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    item = new TableItem(this.mTable, 0);
                    item.setText(name);
                    item.setData((Object)name);
                    boolean hasName = this.mCurrentSet.contains(name);
                    item.setChecked(hasName);
                    if (hasName) {
                        this.mCurrentSet.remove(name);
                    }
                    ++n2;
                }
            }
            if (!this.mCurrentSet.isEmpty()) {
                FontDescriptor fontDesc = JFaceResources.getDialogFontDescriptor();
                fontDesc = fontDesc.withStyle(2);
                Font font = fontDesc.createFont(JFaceResources.getDialogFont().getDevice());
                for (String name : this.mCurrentSet) {
                    item = new TableItem(this.mTable, 0);
                    item.setText(String.format("%1$s (unknown flag)", name));
                    item.setData((Object)name);
                    item.setChecked(true);
                    item.setFont(font);
                }
            }
            ControlAdapter listener = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = FlagSelectionDialog.this.mTable.getClientArea();
                    column.setWidth(r.width);
                }
            };
            this.mTable.addControlListener((ControlListener)listener);
            listener.controlResized(null);
            this.mTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.item instanceof TableItem) {
                        TableItem i;
                        i.setChecked(!(i = (TableItem)e.item).getChecked());
                    }
                    super.widgetDefaultSelected(e);
                }
            });
            Dialog.applyDialogFont((Control)composite);
            this.setHelpAvailable(false);
            return composite;
        }
    }
}

