/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.ui;

import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.XmlnsAttributeDescriptor;
import org.eclipse.andmore.internal.editors.manifest.ManifestEditor;
import org.eclipse.andmore.internal.editors.ui.SectionHelper;
import org.eclipse.andmore.internal.editors.uimodel.UiAttributeNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class UiElementPart
extends SectionHelper.ManifestSectionPart {
    private ManifestEditor mEditor;
    private UiElementNode mUiElementNode;
    private Composite mTable;

    public UiElementPart(Composite body, FormToolkit toolkit, ManifestEditor editor, UiElementNode uiElementNode, String sectionTitle, String sectionDescription, int extra_style) {
        super(body, toolkit, extra_style, sectionDescription != null);
        this.mEditor = editor;
        this.mUiElementNode = uiElementNode;
        this.setupSection(sectionTitle, sectionDescription);
        if (uiElementNode == null) {
            AndmoreAndroidPlugin.log(4, "Missing node to edit!", new Object[0]);
            return;
        }
    }

    public ManifestEditor getEditor() {
        return this.mEditor;
    }

    public UiElementNode getUiElementNode() {
        return this.mUiElementNode;
    }

    public void setUiElementNode(UiElementNode uiElementNode) {
        this.mUiElementNode = uiElementNode;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.createFormControls(form);
    }

    protected void setupSection(String sectionTitle, String sectionDescription) {
        Section section = this.getSection();
        section.setText(sectionTitle);
        section.setDescription(sectionDescription);
    }

    protected void createFormControls(IManagedForm managedForm) {
        this.setTable(this.createTableLayout(managedForm.getToolkit(), 2));
        this.createUiAttributes(managedForm);
    }

    protected void setTable(Composite table) {
        this.mTable = table;
    }

    protected Composite getTable() {
        return this.mTable;
    }

    protected void createUiAttributes(IManagedForm managedForm) {
        Composite table = this.getTable();
        if (table == null || managedForm == null) {
            return;
        }
        Control[] controlArray = table.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.fillTable(table, managedForm);
        this.layoutChanged();
    }

    protected void fillTable(Composite table, IManagedForm managedForm) {
        int inserted = this.insertUiAttributes(this.mUiElementNode, table, managedForm);
        if (inserted == 0) {
            this.createLabel(table, managedForm.getToolkit(), "No attributes to display, waiting for SDK to finish loading...", null);
        }
    }

    protected int insertUiAttributes(UiElementNode uiNode, Composite table, IManagedForm managedForm) {
        AttributeDescriptor[] attr_desc_list;
        if (uiNode == null || table == null || managedForm == null) {
            return 0;
        }
        AttributeDescriptor[] attributeDescriptorArray = attr_desc_list = uiNode.getAttributeDescriptors();
        int n = attr_desc_list.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attr_desc = attributeDescriptorArray[n2];
            if (!(attr_desc instanceof XmlnsAttributeDescriptor)) {
                UiAttributeNode ui_attr = uiNode.findUiAttribute(attr_desc);
                if (ui_attr != null) {
                    ui_attr.createUiControl(table, managedForm);
                } else {
                    AndmoreAndroidPlugin.log(2, "Attribute %1$s not declared in node %2$s, ignored.", attr_desc.getXmlLocalName(), uiNode.getDescriptor().getXmlName());
                }
            }
            ++n2;
        }
        return attr_desc_list.length;
    }

    public boolean isDirty() {
        if (this.mUiElementNode != null && !super.isDirty()) {
            for (UiAttributeNode ui_attr : this.mUiElementNode.getAllUiAttributes()) {
                if (!ui_attr.isDirty()) continue;
                this.markDirty();
                break;
            }
        }
        return super.isDirty();
    }

    public void commit(boolean onSave) {
        if (this.mUiElementNode != null) {
            this.mEditor.wrapEditXmlModel(new Runnable(){

                @Override
                public void run() {
                    for (UiAttributeNode ui_attr : UiElementPart.this.mUiElementNode.getAllUiAttributes()) {
                        ui_attr.commit();
                    }
                }
            });
        }
        super.commit(onSave);
    }
}

