/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class ErrorImageComposite
extends CompositeImageDescriptor {
    private Image mBaseImage;
    private ImageDescriptor mErrorImageDescriptor;
    private Point mSize;

    public ErrorImageComposite(Image baseImage) {
        this(baseImage, false);
    }

    public ErrorImageComposite(Image baseImage, boolean warning) {
        this.mBaseImage = baseImage;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.mErrorImageDescriptor = sharedImages.getImageDescriptor(warning ? "IMG_DEC_FIELD_WARNING" : "IMG_DEC_FIELD_ERROR");
        if (this.mErrorImageDescriptor == null) {
            this.mErrorImageDescriptor = sharedImages.getImageDescriptor(warning ? "IMG_OBJS_WARN_TSK" : "IMG_OBJS_ERROR_TSK");
        }
        this.mSize = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData baseData = this.mBaseImage.getImageData();
        this.drawImage(baseData, 0, 0);
        ImageData overlayData = this.mErrorImageDescriptor.getImageData();
        if (overlayData.width == baseData.width && overlayData.height == baseData.height) {
            overlayData = overlayData.scaledTo(14, 14);
            this.drawImage(overlayData, -3, this.mSize.y - overlayData.height + 3);
        } else {
            this.drawImage(overlayData, 0, this.mSize.y - overlayData.height);
        }
    }

    protected Point getSize() {
        return this.mSize;
    }
}

