/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.pages;

import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.manifest.ManifestEditor;
import org.eclipse.andmore.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import org.eclipse.andmore.internal.editors.ui.SectionHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

final class OverviewLinksPart
extends SectionHelper.ManifestSectionPart {
    private final ManifestEditor mEditor;
    private FormText mFormText;

    public OverviewLinksPart(Composite body, FormToolkit toolkit, ManifestEditor editor) {
        super(body, toolkit, 66, true);
        this.mEditor = editor;
        Section section = this.getSection();
        section.setText("Links");
        section.setDescription("The content of the Android Manifest is made up of three sections. You can also edit the XML directly.");
        Composite table = this.createTableLayout(toolkit, 2);
        StringBuffer buf = new StringBuffer();
        buf.append(String.format("<form><li style=\"image\" value=\"app_img\"><a href=\"page:%1$s\">", "application_page"));
        buf.append("Application");
        buf.append("</a>");
        buf.append(": Activities, intent filters, providers, services and receivers.");
        buf.append("</li>");
        buf.append(String.format("<li style=\"image\" value=\"perm_img\"><a href=\"page:%1$s\">", "permission_page"));
        buf.append("Permission");
        buf.append("</a>");
        buf.append(": Permissions defined and permissions used.");
        buf.append("</li>");
        buf.append(String.format("<li style=\"image\" value=\"inst_img\"><a href=\"page:%1$s\">", "instrumentation_page"));
        buf.append("Instrumentation");
        buf.append("</a>");
        buf.append(": Instrumentation defined.");
        buf.append("</li>");
        buf.append(String.format("<li style=\"image\" value=\"srce_img\"><a href=\"page:%1$s\">", "editor_part"));
        buf.append("XML Source");
        buf.append("</a>");
        buf.append(": Directly edit the AndroidManifest.xml file.");
        buf.append("</li>");
        buf.append("<li style=\"image\" value=\"android_img\">");
        buf.append("<a href=\"http://code.google.com/android/devel/bblocks-manifest.html\">Documentation</a>: Documentation from the Android SDK for AndroidManifest.xml.");
        buf.append("</li>");
        buf.append("</form>");
        this.mFormText = this.createFormText(table, toolkit, true, buf.toString(), false);
        AndroidManifestDescriptors manifestDescriptor = editor.getManifestDescriptors();
        Image androidLogo = AndmoreAndroidPlugin.getAndroidLogo();
        this.mFormText.setImage("android_img", androidLogo);
        this.mFormText.setImage("srce_img", IconFactory.getInstance().getIcon("editor_page_source"));
        if (manifestDescriptor != null) {
            this.mFormText.setImage("app_img", this.getIcon(manifestDescriptor.getApplicationElement()));
            this.mFormText.setImage("perm_img", this.getIcon(manifestDescriptor.getPermissionElement()));
            this.mFormText.setImage("inst_img", this.getIcon(manifestDescriptor.getInstrumentationElement()));
        } else {
            this.mFormText.setImage("app_img", androidLogo);
            this.mFormText.setImage("perm_img", androidLogo);
            this.mFormText.setImage("inst_img", androidLogo);
        }
        this.mFormText.addHyperlinkListener(editor.createHyperlinkListener());
    }

    public void onSdkChanged() {
        AndroidManifestDescriptors manifestDescriptor = this.mEditor.getManifestDescriptors();
        if (manifestDescriptor != null) {
            this.mFormText.setImage("app_img", this.getIcon(manifestDescriptor.getApplicationElement()));
            this.mFormText.setImage("perm_img", this.getIcon(manifestDescriptor.getPermissionElement()));
            this.mFormText.setImage("inst_img", this.getIcon(manifestDescriptor.getInstrumentationElement()));
        }
    }

    private Image getIcon(ElementDescriptor desc) {
        return desc.getCustomizedIcon();
    }
}

