/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.pages;

import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.XmlnsAttributeDescriptor;
import org.eclipse.andmore.internal.editors.manifest.ManifestEditor;
import org.eclipse.andmore.internal.editors.ui.UiElementPart;
import org.eclipse.andmore.internal.editors.uimodel.IUiUpdateListener;
import org.eclipse.andmore.internal.editors.uimodel.UiAttributeNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

final class ApplicationAttributesPart
extends UiElementPart {
    private AppNodeUpdateListener mAppNodeUpdateListener;
    private IManagedForm mManagedForm;

    public ApplicationAttributesPart(Composite body, FormToolkit toolkit, ManifestEditor editor, UiElementNode applicationUiNode) {
        super(body, toolkit, editor, applicationUiNode, "Application Attributes", "Defines the attributes specific to the application.", 66);
    }

    @Override
    public void setUiElementNode(UiElementNode uiElementNode) {
        super.setUiElementNode(uiElementNode);
        this.createUiAttributes(this.mManagedForm);
    }

    @Override
    protected void createFormControls(IManagedForm managedForm) {
        this.mManagedForm = managedForm;
        this.setTable(this.createTableLayout(managedForm.getToolkit(), 4));
        this.mAppNodeUpdateListener = new AppNodeUpdateListener();
        this.getUiElementNode().addUpdateListener(this.mAppNodeUpdateListener);
        this.createUiAttributes(this.mManagedForm);
    }

    public void dispose() {
        super.dispose();
        if (this.getUiElementNode() != null && this.mAppNodeUpdateListener != null) {
            this.getUiElementNode().removeUpdateListener(this.mAppNodeUpdateListener);
            this.mAppNodeUpdateListener = null;
        }
    }

    @Override
    protected void createUiAttributes(IManagedForm managedForm) {
        Composite table = this.getTable();
        if (table == null || managedForm == null) {
            return;
        }
        Control[] controlArray = table.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        UiElementNode uiElementNode = this.getUiElementNode();
        AttributeDescriptor[] attr_desc_list = uiElementNode.getAttributeDescriptors();
        int n3 = attr_desc_list.length;
        int n22 = (int)Math.ceil((double)n3 / 2.0);
        int i = 0;
        while (i < n3) {
            AttributeDescriptor attr_desc = attr_desc_list[i / 2 + (i & 1) * n22];
            if (!(attr_desc instanceof XmlnsAttributeDescriptor)) {
                UiAttributeNode ui_attr = uiElementNode.findUiAttribute(attr_desc);
                if (ui_attr != null) {
                    ui_attr.createUiControl(table, managedForm);
                } else {
                    AndmoreAndroidPlugin.log(2, "Attribute %1$s not declared in node %2$s, ignored.", attr_desc.getXmlLocalName(), uiElementNode.getDescriptor().getXmlName());
                }
            }
            ++i;
        }
        if (n3 == 0) {
            this.createLabel(table, managedForm.getToolkit(), "No attributes to display, waiting for SDK to finish loading...", null);
        }
        if (this.mAppNodeUpdateListener != null) {
            this.mAppNodeUpdateListener.uiElementNodeUpdated(uiElementNode, null);
        }
        this.layoutChanged();
    }

    private class AppNodeUpdateListener
    implements IUiUpdateListener {
        private AppNodeUpdateListener() {
        }

        @Override
        public void uiElementNodeUpdated(UiElementNode ui_node, IUiUpdateListener.UiUpdateState state) {
            boolean exists;
            Composite table = ApplicationAttributesPart.this.getTable();
            boolean bl = exists = ui_node.getXmlNode() != null;
            if (table != null && table.getEnabled() != exists) {
                table.setEnabled(exists);
                Control[] controlArray = table.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.setEnabled(exists);
                    ++n2;
                }
            }
        }
    }
}

