/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.model;

import com.android.ide.common.xml.ManifestData;
import java.util.TreeSet;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.TextAttributeDescriptor;
import org.eclipse.andmore.internal.editors.ui.SectionHelper;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiTextAttributeNode;
import org.eclipse.andmore.internal.project.AndroidManifestHelper;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.wizards.actions.NewProjectAction;
import org.eclipse.andmore.internal.wizards.newproject.NewProjectWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.part.FileEditorInput;

public class UiManifestPkgAttrNode
extends UiTextAttributeNode {
    public UiManifestPkgAttrNode(AttributeDescriptor attributeDescriptor, UiElementNode uiParent) {
        super(attributeDescriptor, uiParent);
    }

    @Override
    public void createUiControl(Composite parent, IManagedForm managedForm) {
        this.setManagedForm(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        TextAttributeDescriptor desc = (TextAttributeDescriptor)this.getDescriptor();
        StringBuilder label = new StringBuilder();
        label.append("<form><p><a href='unused'>");
        label.append(desc.getUiName());
        label.append("</a></p></form>");
        FormText formText = SectionHelper.createFormText(parent, toolkit, true, label.toString(), true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                super.linkActivated(e);
                UiManifestPkgAttrNode.this.doLabelClick();
            }
        });
        formText.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)formText, desc.getTooltip());
        Composite composite = toolkit.createComposite(parent);
        composite.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        toolkit.paintBordersFor(composite);
        Text text = toolkit.createText(composite, this.getCurrentValue());
        GridData gd = new GridData(768);
        gd.horizontalIndent = 1;
        text.setLayoutData((Object)gd);
        this.setTextWidget(text);
        Button browseButton = toolkit.createButton(composite, "Browse...", 8);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiManifestPkgAttrNode.this.doBrowseClick();
            }
        });
    }

    @Override
    protected void onAddValidators(final Text text) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String package_name = text.getText();
                if (package_name.indexOf(46) < 1) {
                    UiManifestPkgAttrNode.this.getManagedForm().getMessageManager().addMessage((Object)text, "Package name should contain at least two identifiers.", null, 3, (Control)text);
                } else {
                    UiManifestPkgAttrNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
                }
            }
        };
        text.addModifyListener(listener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UiManifestPkgAttrNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        listener.modifyText(null);
    }

    private void doBrowseClick() {
        String result;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getTextWidget().getShell(), new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        dialog.setTitle("Android Manifest Package Selection");
        dialog.setMessage("Select the Android Manifest package to target.");
        dialog.setElements((Object[])this.getPossibleValues(null));
        if (dialog.open() == 0 && (result = (String)dialog.getFirstResult()) != null && result.length() > 0) {
            this.getTextWidget().setText(result);
        }
    }

    private void doLabelClick() {
        String package_name = this.getTextWidget().getText().trim();
        if (package_name.length() == 0) {
            this.createNewProject();
        } else {
            this.displayExistingManifest(package_name);
        }
    }

    private void displayExistingManifest(String package_name) {
        IJavaProject[] iJavaProjectArray = BaseProjectHelper.getAndroidProjects(null);
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestData manifestData;
            IJavaProject project = iJavaProjectArray[n2];
            IFile manifestFile = ProjectHelper.getManifest(project.getProject());
            if (manifestFile != null && (manifestData = AndroidManifestHelper.parseForData(manifestFile)) != null && package_name.equals(manifestData.getPackage())) {
                IWorkbenchPage page;
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win != null && (page = win.getActivePage()) != null) {
                    try {
                        page.openEditor((IEditorInput)new FileEditorInput(manifestFile), "org.eclipse.andmore.editors.manifest.ManifestEditor", true, 1);
                    }
                    catch (PartInitException e) {
                        AndmoreAndroidPlugin.log(e, "Opening editor failed for %s", manifestFile.getFullPath());
                    }
                }
                return;
            }
            ++n2;
        }
    }

    private void createNewProject() {
        NewProjectWizard npw;
        String name;
        NewProjectAction npwAction = new NewProjectAction();
        npwAction.run(null);
        if (npwAction.getDialogResult() == 0 && (name = (npw = (NewProjectWizard)npwAction.getWizard()).getPackageName()) != null && name.length() > 0) {
            this.getTextWidget().setText(name);
        }
    }

    @Override
    public String[] getPossibleValues(String prefix) {
        TreeSet<String> packages = new TreeSet<String>();
        IJavaProject[] iJavaProjectArray = BaseProjectHelper.getAndroidProjects(null);
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            ManifestData manifestData = AndroidManifestHelper.parseForData(project.getProject());
            if (manifestData != null) {
                packages.add(manifestData.getPackage());
            }
            ++n2;
        }
        return packages.toArray(new String[packages.size()]);
    }
}

