/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest;

import java.util.Collection;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import org.eclipse.andmore.internal.editors.manifest.pages.ApplicationPage;
import org.eclipse.andmore.internal.editors.manifest.pages.InstrumentationPage;
import org.eclipse.andmore.internal.editors.manifest.pages.OverviewPage;
import org.eclipse.andmore.internal.editors.manifest.pages.PermissionPage;
import org.eclipse.andmore.internal.editors.uimodel.UiAttributeNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.resources.manager.GlobalProjectMonitor;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ManifestEditor
extends AndroidXmlEditor {
    public static final String ID = "org.eclipse.andmore.editors.manifest.ManifestEditor";
    private static final String EMPTY = "";
    private UiElementNode mUiManifestNode;
    private ApplicationPage mAppPage;
    private OverviewPage mOverviewPage;
    private PermissionPage mPermissionPage;
    private InstrumentationPage mInstrumentationPage;
    private GlobalProjectMonitor.IFileListener mMarkerMonitor;

    public ManifestEditor() {
        this.addDefaultTargetListener();
    }

    @Override
    public void dispose() {
        super.dispose();
        GlobalProjectMonitor.getMonitor().removeFileListener(this.mMarkerMonitor);
    }

    @Override
    public void activated() {
        super.activated();
        this.clearActionBindings(false);
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.updateActionBindings();
    }

    @Override
    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == this.mTextPageIndex) {
            this.updateActionBindings();
        } else {
            this.clearActionBindings(false);
        }
    }

    @Override
    protected int getPersistenceCategory() {
        return 2;
    }

    @Override
    public UiElementNode getUiRootNode() {
        return this.mUiManifestNode;
    }

    public AndroidManifestDescriptors getManifestDescriptors() {
        AndroidTargetData data = this.getTargetData();
        if (data != null) {
            return data.getManifestDescriptors();
        }
        return null;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        int prevMinSdkVersion = -1;
        int prevTargetSdkVersion = -1;
        IProject project = null;
        ManifestInfo info = null;
        try {
            project = this.getProject();
            if (project != null) {
                info = ManifestInfo.get(project);
                prevMinSdkVersion = info.getMinSdkVersion();
                prevTargetSdkVersion = info.getTargetSdkVersion();
                info.clear();
            }
        }
        catch (Throwable t) {
            AndmoreAndroidPlugin.log(t, null, new Object[0]);
        }
        super.doSave(monitor);
        try {
            if (info != null) {
                int newMinSdkVersion = info.getMinSdkVersion();
                int newTargetSdkVersion = info.getTargetSdkVersion();
                if (newMinSdkVersion != prevMinSdkVersion || newTargetSdkVersion != prevTargetSdkVersion) {
                    assert (project != null);
                    EclipseLintClient.clearMarkers((IResource)project);
                }
            }
        }
        catch (Throwable t) {
            AndmoreAndroidPlugin.log(t, null, new Object[0]);
        }
    }

    @Override
    protected void createFormPages() {
        try {
            this.mOverviewPage = new OverviewPage(this);
            this.addPage((IFormPage)this.mOverviewPage);
            this.mAppPage = new ApplicationPage(this);
            this.addPage((IFormPage)this.mAppPage);
            this.mPermissionPage = new PermissionPage(this);
            this.addPage((IFormPage)this.mPermissionPage);
            this.mInstrumentationPage = new InstrumentationPage(this);
            this.addPage((IFormPage)this.mInstrumentationPage);
        }
        catch (PartInitException e) {
            AndmoreAndroidPlugin.log(e, "Error creating nested page", new Object[0]);
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile inputFile = this.getInputFile();
        if (inputFile != null) {
            this.startMonitoringMarkers();
            this.setPartName(String.format("%1$s Manifest", inputFile.getProject().getName()));
        }
    }

    @Override
    protected void xmlModelChanged(Document xml_doc) {
        this.initUiRootNode(false);
        this.loadFromXml(xml_doc);
    }

    private void loadFromXml(Document xmlDoc) {
        this.mUiManifestNode.setXmlDocument(xmlDoc);
        Node node = this.getManifestXmlNode(xmlDoc);
        if (node != null) {
            this.mUiManifestNode.loadFromXmlNode(node);
        }
    }

    private Node getManifestXmlNode(Document xmlDoc) {
        if (xmlDoc != null) {
            String manifestXmlName;
            ElementDescriptor manifestDesc = this.mUiManifestNode.getDescriptor();
            String string = manifestXmlName = manifestDesc == null ? null : manifestDesc.getXmlName();
            assert (manifestXmlName != null);
            if (manifestXmlName != null) {
                Node node = xmlDoc.getDocumentElement();
                if (node != null && manifestXmlName.equals(node.getNodeName())) {
                    return node;
                }
                node = xmlDoc.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 1 && manifestXmlName.equals(node.getNodeName())) {
                        return node;
                    }
                    node = node.getNextSibling();
                }
            }
        }
        return null;
    }

    private void onDescriptorsChanged() {
        IStructuredModel model = this.getModelForRead();
        if (model != null) {
            try {
                Node node = this.getManifestXmlNode(this.getXmlDocument(model));
                this.mUiManifestNode.reloadFromXmlNode(node);
            }
            finally {
                model.releaseFromRead();
            }
        }
        if (this.mOverviewPage != null) {
            this.mOverviewPage.refreshUiApplicationNode();
        }
        if (this.mAppPage != null) {
            this.mAppPage.refreshUiApplicationNode();
        }
        if (this.mPermissionPage != null) {
            this.mPermissionPage.refreshUiNode();
        }
        if (this.mInstrumentationPage != null) {
            this.mInstrumentationPage.refreshUiNode();
        }
    }

    private void startMonitoringMarkers() {
        final IFile inputFile = this.getInputFile();
        if (inputFile != null) {
            this.updateFromExistingMarkers(inputFile);
            this.mMarkerMonitor = new GlobalProjectMonitor.IFileListener(){

                @Override
                public void fileChanged(IFile file, IMarkerDelta[] markerDeltas, int kind, String extension, int flags, boolean isAndroidProject) {
                    if (isAndroidProject && file.equals((Object)inputFile)) {
                        ManifestEditor.this.processMarkerChanges(markerDeltas);
                    }
                }
            };
            GlobalProjectMonitor.getMonitor().addFileListener(this.mMarkerMonitor, 4);
        }
    }

    private void updateFromExistingMarkers(IFile inputFile) {
        try {
            ElementDescriptor appElement;
            IMarker[] markers = inputFile.findMarkers("org.eclipse.andmore.common.androidProblem", true, 0);
            AndroidManifestDescriptors desc = this.getManifestDescriptors();
            if (desc != null && (appElement = desc.getApplicationElement()) != null && this.mUiManifestNode != null) {
                UiElementNode appUiNode = this.mUiManifestNode.findUiChildNode(appElement.getXmlName());
                List<UiElementNode> children = appUiNode.getUiChildren();
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    this.processMarker(marker, children, 1);
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void processMarkerChanges(IMarkerDelta[] markerDeltas) {
        AndroidManifestDescriptors descriptors = this.getManifestDescriptors();
        if (descriptors != null && descriptors.getApplicationElement() != null) {
            UiElementNode app_ui_node = this.mUiManifestNode.findUiChildNode(descriptors.getApplicationElement().getXmlName());
            List<UiElementNode> children = app_ui_node.getUiChildren();
            IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
            int n = markerDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                this.processMarker(markerDelta.getMarker(), children, markerDelta.getKind());
                ++n2;
            }
        }
    }

    private void processMarker(IMarker marker, List<UiElementNode> nodeList, int kind) {
        String nodeType = marker.getAttribute("android.type", EMPTY);
        if (nodeType == EMPTY) {
            return;
        }
        String className = marker.getAttribute("android.class", EMPTY);
        if (className == EMPTY) {
            return;
        }
        for (UiElementNode ui_node : nodeList) {
            if (!ui_node.getDescriptor().getXmlName().equals(nodeType)) continue;
            for (UiAttributeNode attr : ui_node.getAllUiAttributes()) {
                if (!attr.getDescriptor().getXmlLocalName().equals("name") || !attr.getCurrentValue().equals(className)) continue;
                if (kind == 2) {
                    attr.setHasError(false);
                } else {
                    attr.setHasError(true);
                }
                return;
            }
        }
    }

    @Override
    protected void initUiRootNode(boolean force) {
        if (this.mUiManifestNode != null && !force) {
            return;
        }
        AndroidManifestDescriptors manifestDescriptor = this.getManifestDescriptors();
        if (manifestDescriptor != null) {
            ElementDescriptor manifestElement = manifestDescriptor.getManifestElement();
            this.mUiManifestNode = manifestElement.createUiNode();
            this.mUiManifestNode.setEditor(this);
            ElementDescriptor element = manifestDescriptor.getUsesSdkElement();
            boolean present = false;
            for (UiElementNode ui_node : this.mUiManifestNode.getUiChildren()) {
                if (ui_node.getDescriptor() != element) continue;
                present = true;
                break;
            }
            if (!present) {
                this.mUiManifestNode.appendNewUiChild(element);
            }
            element = manifestDescriptor.getApplicationElement();
            present = false;
            for (UiElementNode ui_node : this.mUiManifestNode.getUiChildren()) {
                if (ui_node.getDescriptor() != element) continue;
                present = true;
                break;
            }
            if (!present) {
                this.mUiManifestNode.appendNewUiChild(element);
            }
            this.onDescriptorsChanged();
        } else {
            ElementDescriptor desc = new ElementDescriptor("manifest", "temporary descriptors due to missing decriptors", null, null, null, null, false);
            this.mUiManifestNode = desc.createUiNode();
            this.mUiManifestNode.setEditor(this);
        }
    }

    public void addPermissions(final List<String> permissions, final boolean show) {
        this.wrapUndoEditXmlModel("Add permissions", new Runnable(){

            @Override
            public void run() {
                ManifestEditor.this.initUiRootNode(true);
                UiElementNode root = ManifestEditor.this.getUiRootNode();
                ElementDescriptor descriptor = ManifestEditor.this.getManifestDescriptors().getUsesPermissionElement();
                boolean shown = false;
                for (String permission : permissions) {
                    int lastPermissionIndex = -1;
                    int nextPermissionIndex = -1;
                    int index = 0;
                    for (UiElementNode sibling : root.getUiChildren()) {
                        Node node = sibling.getXmlNode();
                        if (node.getNodeName().equals("uses-permission")) {
                            lastPermissionIndex = index;
                            String name = ((Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                            if (permission.compareTo(name) < 0) {
                                nextPermissionIndex = index;
                                break;
                            }
                        } else if (node.getNodeName().equals("application")) {
                            nextPermissionIndex = index;
                            break;
                        }
                        ++index;
                    }
                    index = nextPermissionIndex != -1 ? nextPermissionIndex : (lastPermissionIndex != -1 ? lastPermissionIndex + 1 : root.getUiChildren().size());
                    UiElementNode usesPermission = root.insertNewUiChild(index, descriptor);
                    usesPermission.setAttributeValue("name", "http://schemas.android.com/apk/res/android", permission, true);
                    Node node = usesPermission.createXmlNode();
                    if (!show || shown) continue;
                    shown = true;
                    if (node instanceof IndexedRegion && ManifestEditor.this.getInputFile() != null) {
                        IndexedRegion indexedRegion = (IndexedRegion)node;
                        Region region = new Region(indexedRegion.getStartOffset(), indexedRegion.getEndOffset() - indexedRegion.getStartOffset());
                        try {
                            AndmoreAndroidPlugin.openFile(ManifestEditor.this.getInputFile(), (IRegion)region, true);
                        }
                        catch (PartInitException e) {
                            AndmoreAndroidPlugin.log(e, null, new Object[0]);
                        }
                        continue;
                    }
                    ManifestEditor.this.show(node);
                }
            }
        });
    }

    public void removePermissions(final Collection<String> permissions) {
        this.wrapUndoEditXmlModel("Remove permissions", new Runnable(){

            @Override
            public void run() {
                ManifestEditor.this.initUiRootNode(true);
                UiElementNode root = ManifestEditor.this.getUiRootNode();
                block0: for (String permission : permissions) {
                    for (UiElementNode sibling : root.getUiChildren()) {
                        String name;
                        Node node = sibling.getXmlNode();
                        if (!node.getNodeName().equals("uses-permission") || !(name = ((Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "name")).equals(permission)) continue;
                        sibling.deleteXmlNode();
                        continue block0;
                    }
                }
            }
        });
    }
}

