/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.uimodel;

import com.android.sdklib.IAndroidTarget;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.XmlnsAttributeDescriptor;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.descriptors.LayoutDescriptors;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.uimodel.UiDocumentNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UiViewElementNode
extends UiElementNode {
    private AttributeDescriptor[] mCachedAttributeDescriptors;

    public UiViewElementNode(ViewElementDescriptor elementDescriptor) {
        super(elementDescriptor);
    }

    @Override
    public AttributeDescriptor[] getAttributeDescriptors() {
        if (!this.getDescriptor().syncAttributes()) {
            this.mCachedAttributeDescriptors = null;
        }
        if (this.mCachedAttributeDescriptors != null) {
            return this.mCachedAttributeDescriptors;
        }
        UiElementNode ui_parent = this.getUiParent();
        AttributeDescriptor[] direct_attrs = super.getAttributeDescriptors();
        this.mCachedAttributeDescriptors = direct_attrs;
        AttributeDescriptor[] layout_attrs = null;
        boolean need_xmlns = false;
        if (ui_parent instanceof UiDocumentNode) {
            LayoutDescriptors descriptors;
            ViewElementDescriptor desc;
            AndroidTargetData data;
            IAndroidTarget target;
            Sdk currentSdk;
            IProject project = this.getEditor().getProject();
            if (project != null && (currentSdk = Sdk.getCurrent()) != null && (target = currentSdk.getTarget(project)) != null && (data = currentSdk.getTargetData(target)) != null && (desc = (descriptors = data.getLayoutDescriptors()).findDescriptorByClass("android.widget.FrameLayout")) != null) {
                layout_attrs = desc.getLayoutAttributes();
                need_xmlns = true;
            }
        } else if (ui_parent instanceof UiViewElementNode) {
            layout_attrs = ((ViewElementDescriptor)ui_parent.getDescriptor()).getLayoutAttributes();
        }
        if (layout_attrs == null || layout_attrs.length == 0) {
            return this.mCachedAttributeDescriptors;
        }
        this.mCachedAttributeDescriptors = new AttributeDescriptor[direct_attrs.length + layout_attrs.length + (need_xmlns ? 1 : 0)];
        System.arraycopy(direct_attrs, 0, this.mCachedAttributeDescriptors, 0, direct_attrs.length);
        System.arraycopy(layout_attrs, 0, this.mCachedAttributeDescriptors, direct_attrs.length, layout_attrs.length);
        if (need_xmlns) {
            XmlnsAttributeDescriptor desc = new XmlnsAttributeDescriptor("android", "http://schemas.android.com/apk/res/android");
            this.mCachedAttributeDescriptors[direct_attrs.length + layout_attrs.length] = desc;
        }
        return this.mCachedAttributeDescriptors;
    }

    public Image getIcon() {
        ElementDescriptor desc = this.getDescriptor();
        if (desc != null) {
            Image img = null;
            String uiName = desc.getUiName();
            IconFactory icons = IconFactory.getInstance();
            if (uiName.equals("LinearLayout")) {
                Element e = (Element)this.getXmlNode();
                if ("vertical".equals(e.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation"))) {
                    IconFactory factory = icons;
                    img = factory.getIcon("VerticalLinearLayout");
                }
            } else if (uiName.equals("view")) {
                String className;
                Node xmlNode = this.getXmlNode();
                if (xmlNode instanceof Element && (className = ((Element)xmlNode).getAttribute("class")) != null && className.length() > 0) {
                    int index = className.lastIndexOf(46);
                    if (index != -1) {
                        className = "customView";
                    }
                    img = icons.getIcon(className);
                }
                if (img == null) {
                    img = icons.getIcon("View");
                }
            }
            if (img == null) {
                img = desc.getGenericIcon();
            }
            if (img != null) {
                IMarker marker;
                LayoutEditorDelegate delegate;
                AndroidXmlEditor editor = this.getEditor();
                if (editor != null && (delegate = LayoutEditorDelegate.fromEditor((IEditorPart)editor)) != null && (marker = delegate.getIssueForNode(this)) != null) {
                    int severity = marker.getAttribute("severity", 0);
                    if (severity == 2) {
                        return icons.addErrorIcon(img);
                    }
                    return icons.addWarningIcon(img);
                }
                return img;
            }
            return img;
        }
        return AndmoreAndroidPlugin.getAndroidLogo();
    }

    @Override
    protected void setUiParent(UiElementNode parent) {
        super.setUiParent(parent);
        this.mCachedAttributeDescriptors = null;
    }
}

