/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import com.android.utils.Pair;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.layout.GravityHelper;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.editors.layout.refactoring.ChangeLayoutRefactoring;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoring;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.text.edits.MultiTextEdit;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class RelativeLayoutConversionHelper {
    private final MultiTextEdit mRootEdit;
    private final boolean mFlatten;
    private final Element mLayout;
    private final ChangeLayoutRefactoring mRefactoring;
    private final CanvasViewInfo mRootView;
    private List<Element> mDeletedElements;

    RelativeLayoutConversionHelper(ChangeLayoutRefactoring refactoring, Element layout, boolean flatten, MultiTextEdit rootEdit, CanvasViewInfo rootView) {
        this.mRefactoring = refactoring;
        this.mLayout = layout;
        this.mFlatten = flatten;
        this.mRootEdit = rootEdit;
        this.mRootView = rootView;
    }

    public void convertToRelative() {
        if (this.mRootView == null) {
            return;
        }
        CanvasViewInfo layoutView = this.findViewForElement(this.mRootView, this.mLayout);
        if (layoutView == null || layoutView.getChildren().size() == 0) {
            return;
        }
        List<View> views = this.analyzeLayout(layoutView);
        this.createAttachments(views);
    }

    List<Element> getDeletedElements() {
        return this.mDeletedElements;
    }

    private List<View> analyzeLayout(CanvasViewInfo layoutView) {
        EdgeList edgeList = new EdgeList(layoutView);
        this.mDeletedElements = edgeList.getDeletedElements();
        this.deleteRemovedElements(this.mDeletedElements);
        List<Integer> columnOffsets = edgeList.getColumnOffsets();
        List<Integer> rowOffsets = edgeList.getRowOffsets();
        int[] left = new int[columnOffsets.size()];
        int[] top = new int[rowOffsets.size()];
        HashMap<Integer, Integer> xToCol = new HashMap<Integer, Integer>();
        int columnIndex = 0;
        for (Integer offset : columnOffsets) {
            left[columnIndex] = offset;
            xToCol.put(offset, columnIndex++);
        }
        HashMap<Integer, Integer> yToRow = new HashMap<Integer, Integer>();
        int rowIndex = 0;
        for (Integer offset : rowOffsets) {
            top[rowIndex] = offset;
            yToRow.put(offset, rowIndex++);
        }
        List<View> views = this.createViews(edgeList, columnOffsets);
        this.initializeSpans(edgeList, columnOffsets, rowOffsets, xToCol, yToRow);
        for (View view : views) {
            assert (view.getLeftEdge() == left[view.mCol]);
            assert (view.getTopEdge() == top[view.mRow]);
            assert (view.getRightEdge() == left[view.mCol + view.mColSpan]);
            assert (view.getBottomEdge() == top[view.mRow + view.mRowSpan]);
        }
        this.initializeIds(edgeList, views);
        Grid grid = new Grid(views, left, top);
        this.computeKnownConstraints(views, edgeList);
        this.computeHorizontalConstraints(grid);
        this.computeVerticalConstraints(grid);
        return views;
    }

    private List<View> createViews(EdgeList edgeList, List<Integer> columnOffsets) {
        ArrayList<View> views = new ArrayList<View>();
        for (Integer offset : columnOffsets) {
            List<View> leftEdgeViews = edgeList.getLeftEdgeViews(offset);
            if (leftEdgeViews == null) continue;
            for (View view : leftEdgeViews) {
                views.add(view);
            }
        }
        return views;
    }

    private void deleteRemovedElements(List<Element> delete) {
        if (this.mFlatten && delete.size() > 0) {
            for (Element element : delete) {
                this.mRefactoring.removeElementTags(this.mRootEdit, element, delete, !AdtPrefs.getPrefs().getFormatGuiXml());
            }
        }
    }

    private void initializeIds(EdgeList edgeList, List<View> views) {
        for (View view : views) {
            String id = this.mRefactoring.ensureHasId(this.mRootEdit, view.mElement, null);
            edgeList.setIdAttributeValue(view, id);
        }
    }

    private void initializeSpans(EdgeList edgeList, List<Integer> columnOffsets, List<Integer> rowOffsets, Map<Integer, Integer> xToCol, Map<Integer, Integer> yToRow) {
        Integer end;
        for (Integer offset : columnOffsets) {
            List<View> leftEdgeViews = edgeList.getLeftEdgeViews(offset);
            if (leftEdgeViews == null) continue;
            for (View view : leftEdgeViews) {
                Integer col = xToCol.get(view.getLeftEdge());
                assert (col != null);
                end = xToCol.get(view.getRightEdge());
                assert (end != null);
                view.mCol = col;
                view.mColSpan = end - col;
            }
        }
        for (Integer offset : rowOffsets) {
            List<View> topEdgeViews = edgeList.getTopEdgeViews(offset);
            if (topEdgeViews == null) continue;
            for (View view : topEdgeViews) {
                Integer row = yToRow.get(view.getTopEdge());
                assert (row != null);
                end = yToRow.get(view.getBottomEdge());
                assert (end != null);
                view.mRow = row;
                view.mRowSpan = end - row;
            }
        }
    }

    private void createAttachments(List<View> views) {
        String namespace = this.mRefactoring.getAndroidNamespacePrefix();
        for (View view : views) {
            for (Pair<String, String> constraint : view.getHorizConstraints()) {
                this.mRefactoring.setAttribute(this.mRootEdit, view.mElement, "http://schemas.android.com/apk/res/android", namespace, (String)constraint.getFirst(), (String)constraint.getSecond());
            }
            for (Pair<String, String> constraint : view.getVerticalConstraints()) {
                this.mRefactoring.setAttribute(this.mRootEdit, view.mElement, "http://schemas.android.com/apk/res/android", namespace, (String)constraint.getFirst(), (String)constraint.getSecond());
            }
        }
    }

    private void computeKnownConstraints(List<View> views, EdgeList edgeList) {
        HashSet<Node> seen = new HashSet<Node>();
        for (View view : views) {
            Element element = view.getElement();
            Node parent = element.getParentNode();
            if (seen.contains(parent)) continue;
            seen.add(parent);
            if (parent.getNodeType() != 1) continue;
            Element layout = (Element)parent;
            String layoutName = layout.getTagName();
            if ("LinearLayout".equals(layoutName)) {
                this.analyzeLinearLayout(edgeList, layout);
                continue;
            }
            if (!"RelativeLayout".equals(layoutName)) continue;
            this.analyzeRelativeLayout(edgeList, layout);
        }
    }

    private float getWeight(Element linearLayoutChild) {
        String weight = linearLayoutChild.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight");
        if (weight != null && weight.length() > 0) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException nfe) {
                AndmoreAndroidPlugin.log(nfe, "Invalid weight %1$s", weight);
            }
        }
        return 0.0f;
    }

    private float getWeightSum(Element linearLayout) {
        float sum = 0.0f;
        for (Element child : DomUtilities.getChildren(linearLayout)) {
            sum += this.getWeight(child);
        }
        return sum;
    }

    private void analyzeLinearLayout(EdgeList edgeList, Element layout) {
        boolean isVertical = "vertical".equals(layout.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation"));
        View baselineRef = null;
        if (!isVertical && !"false".equals(layout.getAttributeNS("http://schemas.android.com/apk/res/android", "baselineAligned"))) {
            int tallestHeight = 0;
            View tallest = null;
            for (Element child : DomUtilities.getChildren(layout)) {
                View view = edgeList.getView(child);
                if (view == null || view.getHeight() <= tallestHeight) continue;
                tallestHeight = view.getHeight();
                tallest = view;
            }
            if (tallest != null) {
                baselineRef = tallest;
            }
        }
        float weightSum = this.getWeightSum(layout);
        float cumulativeWeight = 0.0f;
        List<Element> children = DomUtilities.getChildren(layout);
        String prevId = null;
        boolean isFirstChild = true;
        boolean linkBackwards = true;
        boolean linkForwards = false;
        int index = 0;
        int childCount = children.size();
        while (index < childCount) {
            Element child = children.get(index);
            View childView = edgeList.getView(child);
            if (childView == null) {
                prevId = null;
                isFirstChild = false;
            } else {
                if (weightSum > 0.0f) {
                    float weight = this.getWeight(child);
                    if (cumulativeWeight == 0.0f && weight > 0.0f) {
                        View referenced = isVertical ? edgeList.getSharedBottomEdge(layout) : edgeList.getSharedRightEdge(layout);
                        if (referenced != null) {
                            linkForwards = true;
                        }
                    } else if (cumulativeWeight > 0.0f) {
                        linkBackwards = false;
                    }
                    cumulativeWeight += weight;
                }
                this.analyzeGravity(edgeList, layout, isVertical, child, childView);
                this.convert0dipToWrapContent(child);
                if (prevId != null) {
                    if (linkBackwards) {
                        if (isVertical) {
                            childView.addVerticalConstraint("layout_below", prevId);
                        } else {
                            childView.addHorizConstraint("layout_toRightOf", prevId);
                        }
                    }
                } else if (isFirstChild) {
                    assert (linkBackwards);
                    if (isVertical) {
                        View referenced = edgeList.getSharedTopEdge(layout);
                        if (referenced != null) {
                            if (RelativeLayoutConversionHelper.isAncestor(referenced.getElement(), child)) {
                                childView.addVerticalConstraint("layout_alignParentTop", "true");
                            } else {
                                childView.addVerticalConstraint("layout_alignTop", referenced.getId());
                            }
                        }
                    } else {
                        View referenced = edgeList.getSharedLeftEdge(layout);
                        if (referenced != null) {
                            if (RelativeLayoutConversionHelper.isAncestor(referenced.getElement(), child)) {
                                childView.addHorizConstraint("layout_alignParentLeft", "true");
                            } else {
                                childView.addHorizConstraint("layout_alignLeft", referenced.getId());
                            }
                        }
                    }
                }
                if (linkForwards) {
                    if (index < childCount - 1) {
                        Element nextChild = children.get(index + 1);
                        String nextId = this.mRefactoring.ensureHasId(this.mRootEdit, nextChild, null);
                        if (nextId != null) {
                            if (isVertical) {
                                childView.addVerticalConstraint("layout_above", nextId);
                            } else {
                                childView.addHorizConstraint("layout_toLeftOf", nextId);
                            }
                        }
                    } else if (isVertical) {
                        View referenced = edgeList.getSharedBottomEdge(layout);
                        if (referenced != null) {
                            if (RelativeLayoutConversionHelper.isAncestor(referenced.getElement(), child)) {
                                childView.addVerticalConstraint("layout_alignParentBottom", "true");
                            } else {
                                childView.addVerticalConstraint("layout_alignBottom", referenced.getId());
                            }
                        }
                    } else {
                        View referenced = edgeList.getSharedRightEdge(layout);
                        if (referenced != null) {
                            if (RelativeLayoutConversionHelper.isAncestor(referenced.getElement(), child)) {
                                childView.addHorizConstraint("layout_alignParentRight", "true");
                            } else {
                                childView.addHorizConstraint("layout_alignRight", referenced.getId());
                            }
                        }
                    }
                }
                if (baselineRef != null && baselineRef.getId() != null && !baselineRef.getId().equals(childView.getId())) {
                    assert (!isVertical);
                    if ((childView.getGravity() & 0xF0) == (baselineRef.getGravity() & 0xF0)) {
                        childView.addHorizConstraint("layout_alignBaseline", baselineRef.getId());
                    }
                }
                prevId = this.mRefactoring.ensureHasId(this.mRootEdit, child, null);
                isFirstChild = false;
            }
            ++index;
        }
    }

    private int analyzeGravity(EdgeList edgeList, Element layout, boolean isVertical, Element child, View childView) {
        View referenced;
        int gravity = childView.getGravity();
        if (isVertical) {
            View referenced2;
            if ((gravity & 2) != 0) {
                View referenced3 = edgeList.getSharedRightEdge(layout);
                if (referenced3 != null) {
                    if (RelativeLayoutConversionHelper.isAncestor(referenced3.getElement(), child)) {
                        childView.addHorizConstraint("layout_alignParentRight", "true");
                    } else {
                        childView.addHorizConstraint("layout_alignRight", referenced3.getId());
                    }
                }
            } else if ((gravity & 4) != 0) {
                View referenced1 = edgeList.getSharedLeftEdge(layout);
                View referenced22 = edgeList.getSharedRightEdge(layout);
                if (referenced1 != null && referenced22 == referenced1 && RelativeLayoutConversionHelper.isAncestor(referenced1.getElement(), child)) {
                    childView.addHorizConstraint("layout_centerHorizontal", "true");
                }
            } else if ((gravity & 8) != 0) {
                View referenced1 = edgeList.getSharedLeftEdge(layout);
                View referenced23 = edgeList.getSharedRightEdge(layout);
                if (referenced1 != null && referenced23 == referenced1) {
                    if (RelativeLayoutConversionHelper.isAncestor(referenced1.getElement(), child)) {
                        childView.addHorizConstraint("layout_alignParentLeft", "true");
                        childView.addHorizConstraint("layout_alignParentRight", "true");
                    } else {
                        childView.addHorizConstraint("layout_alignLeft", referenced1.getId());
                        childView.addHorizConstraint("layout_alignRight", referenced23.getId());
                    }
                }
            } else if ((gravity & 1) != 0 && (referenced2 = edgeList.getSharedLeftEdge(layout)) != null) {
                if (RelativeLayoutConversionHelper.isAncestor(referenced2.getElement(), child)) {
                    childView.addHorizConstraint("layout_alignParentLeft", "true");
                } else {
                    childView.addHorizConstraint("layout_alignLeft", referenced2.getId());
                }
            }
        } else if ((gravity & 0x80) != 0) {
            View referenced4 = edgeList.getSharedBottomEdge(layout);
            if (referenced4 != null) {
                if (RelativeLayoutConversionHelper.isAncestor(referenced4.getElement(), child)) {
                    childView.addVerticalConstraint("layout_alignParentBottom", "true");
                } else {
                    childView.addVerticalConstraint("layout_alignBottom", referenced4.getId());
                }
            }
        } else if ((gravity & 0x10) != 0) {
            View referenced1 = edgeList.getSharedTopEdge(layout);
            View referenced2 = edgeList.getSharedBottomEdge(layout);
            if (referenced1 != null && referenced2 == referenced1 && RelativeLayoutConversionHelper.isAncestor(referenced1.getElement(), child)) {
                childView.addVerticalConstraint("layout_centerVertical", "true");
            }
        } else if ((gravity & 0x20) != 0) {
            View referenced1 = edgeList.getSharedTopEdge(layout);
            View referenced2 = edgeList.getSharedBottomEdge(layout);
            if (referenced1 != null && referenced2 == referenced1) {
                if (RelativeLayoutConversionHelper.isAncestor(referenced1.getElement(), child)) {
                    childView.addVerticalConstraint("layout_alignParentTop", "true");
                    childView.addVerticalConstraint("layout_alignParentBottom", "true");
                } else {
                    childView.addVerticalConstraint("layout_alignTop", referenced1.getId());
                    childView.addVerticalConstraint("layout_alignBottom", referenced2.getId());
                }
            }
        } else if ((gravity & 0x40) != 0 && (referenced = edgeList.getSharedTopEdge(layout)) != null) {
            if (RelativeLayoutConversionHelper.isAncestor(referenced.getElement(), child)) {
                childView.addVerticalConstraint("layout_alignParentTop", "true");
            } else {
                childView.addVerticalConstraint("layout_alignTop", referenced.getId());
            }
        }
        return gravity;
    }

    private void convert0dipToWrapContent(Element child) {
        String width;
        String height = child.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_height");
        if (height != null && height.startsWith("0")) {
            this.mRefactoring.setAttribute(this.mRootEdit, child, "http://schemas.android.com/apk/res/android", this.mRefactoring.getAndroidNamespacePrefix(), "layout_height", "wrap_content");
        }
        if ((width = child.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_width")) != null && width.startsWith("0")) {
            this.mRefactoring.setAttribute(this.mRootEdit, child, "http://schemas.android.com/apk/res/android", this.mRefactoring.getAndroidNamespacePrefix(), "layout_width", "wrap_content");
        }
    }

    private void analyzeRelativeLayout(EdgeList edgeList, Element layout) {
        NodeList children = layout.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Element child;
            View childView;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (childView = edgeList.getView(child = (Element)node)) != null) {
                NamedNodeMap attributes = child.getAttributes();
                int j = 0;
                int m = attributes.getLength();
                while (j < m) {
                    Attr attribute = (Attr)attributes.item(j);
                    String name = attribute.getLocalName();
                    String value = attribute.getValue();
                    if (!name.equals("layout_width") && !name.equals("layout_height") && name.startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
                        String id = RelativeLayoutConversionHelper.getIdBasename(value);
                        if (id != null) {
                            View referenced = edgeList.getView(id);
                            if (referenced != null) {
                                if (name.equals("layout_below") || name.equals("layout_above") || name.equals("layout_alignTop") || name.equals("layout_alignBottom") || name.equals("layout_alignBaseline")) {
                                    childView.addVerticalConstraint(name, value);
                                } else if (name.equals("layout_alignLeft") || name.equals("layout_toLeftOf") || name.equals("layout_toRightOf") || name.equals("layout_alignRight")) {
                                    childView.addHorizConstraint(name, value);
                                } else assert (false) : name;
                            }
                        } else {
                            View referenced;
                            boolean remove = true;
                            if (name.equals("layout_alignParentLeft")) {
                                View referenced2 = edgeList.getSharedLeftEdge(layout);
                                if (referenced2 != null) {
                                    if (RelativeLayoutConversionHelper.isAncestor(referenced2.getElement(), child)) {
                                        childView.addHorizConstraint(name, "true");
                                    } else {
                                        childView.addHorizConstraint("layout_alignLeft", referenced2.getId());
                                    }
                                    remove = false;
                                }
                            } else if (name.equals("layout_alignParentRight")) {
                                View referenced3 = edgeList.getSharedRightEdge(layout);
                                if (referenced3 != null) {
                                    if (RelativeLayoutConversionHelper.isAncestor(referenced3.getElement(), child)) {
                                        childView.addHorizConstraint(name, "true");
                                    } else {
                                        childView.addHorizConstraint("layout_alignRight", referenced3.getId());
                                    }
                                    remove = false;
                                }
                            } else if (name.equals("layout_alignParentTop")) {
                                View referenced4 = edgeList.getSharedTopEdge(layout);
                                if (referenced4 != null) {
                                    if (RelativeLayoutConversionHelper.isAncestor(referenced4.getElement(), child)) {
                                        childView.addVerticalConstraint(name, "true");
                                    } else {
                                        childView.addVerticalConstraint("layout_alignTop", referenced4.getId());
                                    }
                                    remove = false;
                                }
                            } else if (name.equals("layout_alignParentBottom") && (referenced = edgeList.getSharedBottomEdge(layout)) != null) {
                                if (RelativeLayoutConversionHelper.isAncestor(referenced.getElement(), child)) {
                                    childView.addVerticalConstraint(name, "true");
                                } else {
                                    childView.addVerticalConstraint("layout_alignBottom", referenced.getId());
                                }
                                remove = false;
                            }
                            boolean alignWithParent = name.equals("layout_alignWithParentIfMissing");
                            if (remove) {
                                // empty if block
                            }
                            if (!remove || name.startsWith("layout_margin")) {
                                // empty if block
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static String getIdBasename(String id) {
        if (id.startsWith("@+id/")) {
            return id.substring("@+id/".length());
        }
        if (id.startsWith("@id/")) {
            return id.substring("@id/".length());
        }
        return null;
    }

    private static boolean isAncestor(Node ancestor, Node node) {
        while (node != null) {
            if (node == ancestor) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private void computeHorizontalConstraints(Grid grid) {
        int columns = grid.getColumns();
        String attachLeftProperty = "layout_alignParentLeft";
        String attachLeftValue = "true";
        int marginLeft = 0;
        int col = 0;
        while (col < columns) {
            if (!grid.colContainsTopLeftCorner(col)) {
                marginLeft += grid.getColumnWidth(col);
            } else {
                String firstId = null;
                for (View view : grid.viewsStartingInCol(col, true)) {
                    assert (view.getId() != null);
                    if (firstId == null) {
                        firstId = view.getId();
                        if (view.isConstrainedHorizontally()) continue;
                        if (attachLeftProperty != null) {
                            view.addHorizConstraint(attachLeftProperty, attachLeftValue);
                            if (marginLeft <= 0) continue;
                            view.addHorizConstraint("layout_marginLeft", String.format("%ddp", marginLeft));
                            marginLeft = 0;
                            continue;
                        }
                        assert (false);
                        continue;
                    }
                    if (view.isConstrainedHorizontally()) continue;
                    view.addHorizConstraint("layout_alignLeft", firstId);
                }
            }
            View view = grid.findRightEdgeView(col);
            if (view != null) {
                assert (view.getId() != null);
                attachLeftProperty = "layout_toRightOf";
                attachLeftValue = view.getId();
                marginLeft = 0;
            } else if (marginLeft == 0) {
                marginLeft = grid.getColumnWidth(col);
            }
            ++col;
        }
    }

    private void computeVerticalConstraints(Grid grid) {
        int rows = grid.getRows();
        String attachTopProperty = "layout_alignParentTop";
        String attachTopValue = "true";
        int marginTop = 0;
        int row = 0;
        while (row < rows) {
            if (!grid.rowContainsTopLeftCorner(row)) {
                marginTop += grid.getRowHeight(row);
            } else {
                String firstId = null;
                for (View view : grid.viewsStartingInRow(row, true)) {
                    assert (view.getId() != null);
                    if (firstId == null) {
                        firstId = view.getId();
                        if (view.isConstrainedVertically()) continue;
                        if (attachTopProperty != null) {
                            view.addVerticalConstraint(attachTopProperty, attachTopValue);
                            if (marginTop <= 0) continue;
                            view.addVerticalConstraint("layout_marginTop", String.format("%ddp", marginTop));
                            marginTop = 0;
                            continue;
                        }
                        assert (false);
                        continue;
                    }
                    if (view.isConstrainedVertically()) continue;
                    view.addVerticalConstraint("layout_alignTop", firstId);
                }
            }
            View view = grid.findBottomEdgeView(row);
            if (view != null) {
                assert (view.getId() != null);
                attachTopProperty = "layout_below";
                attachTopValue = view.getId();
                marginTop = 0;
            } else if (marginTop == 0) {
                marginTop = grid.getRowHeight(row);
            }
            ++row;
        }
    }

    private CanvasViewInfo findViewForElement(CanvasViewInfo info, Element element) {
        if (RelativeLayoutConversionHelper.getElement(info) == element) {
            return info;
        }
        for (CanvasViewInfo child : info.getChildren()) {
            CanvasViewInfo result = this.findViewForElement(child, element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Element getElement(CanvasViewInfo info) {
        Node node = info.getUiViewNode().getXmlNode();
        if (node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    private class EdgeList {
        private final Map<Element, View> mElementToViewMap = new HashMap<Element, View>(100);
        private final Map<String, View> mIdToViewMap = new HashMap<String, View>(100);
        private final Map<Integer, List<View>> mLeft = new HashMap<Integer, List<View>>();
        private final Map<Integer, List<View>> mTop = new HashMap<Integer, List<View>>();
        private final Map<Integer, List<View>> mRight = new HashMap<Integer, List<View>>();
        private final Map<Integer, List<View>> mBottom = new HashMap<Integer, List<View>>();
        private final Map<Element, Element> mSharedLeftEdge = new HashMap<Element, Element>();
        private final Map<Element, Element> mSharedTopEdge = new HashMap<Element, Element>();
        private final Map<Element, Element> mSharedRightEdge = new HashMap<Element, Element>();
        private final Map<Element, Element> mSharedBottomEdge = new HashMap<Element, Element>();
        private final List<Element> mDelete = new ArrayList<Element>();

        EdgeList(CanvasViewInfo view) {
            this.analyze(view, true);
            this.mDelete.remove(RelativeLayoutConversionHelper.getElement(view));
        }

        public void setIdAttributeValue(View view, String id) {
            assert (id.startsWith("@+id/") || id.startsWith("@id/"));
            view.mId = id;
            this.mIdToViewMap.put(RelativeLayoutConversionHelper.getIdBasename(id), view);
        }

        public View getView(Element element) {
            return this.mElementToViewMap.get(element);
        }

        public View getView(String id) {
            return this.mIdToViewMap.get(id);
        }

        public List<View> getTopEdgeViews(Integer topOffset) {
            return this.mTop.get(topOffset);
        }

        public List<View> getLeftEdgeViews(Integer leftOffset) {
            return this.mLeft.get(leftOffset);
        }

        void record(Map<Integer, List<View>> map, Integer edge, View info) {
            List<View> list = map.get(edge);
            if (list == null) {
                list = new ArrayList<View>();
                map.put(edge, list);
            }
            list.add(info);
        }

        private List<Integer> getOffsets(Set<Integer> first, Set<Integer> second) {
            HashSet<Integer> joined = new HashSet<Integer>(first.size() + second.size());
            joined.addAll(first);
            joined.addAll(second);
            ArrayList<Integer> unique = new ArrayList<Integer>(joined);
            Collections.sort(unique);
            return unique;
        }

        public List<Element> getDeletedElements() {
            return this.mDelete;
        }

        public List<Integer> getColumnOffsets() {
            return this.getOffsets(this.mLeft.keySet(), this.mRight.keySet());
        }

        public List<Integer> getRowOffsets() {
            return this.getOffsets(this.mTop.keySet(), this.mBottom.keySet());
        }

        private View analyze(CanvasViewInfo view, boolean isRoot) {
            View added = null;
            if (!RelativeLayoutConversionHelper.this.mFlatten || !this.isRemovableLayout(view)) {
                added = this.add(view);
                if (!isRoot) {
                    return added;
                }
            } else {
                this.mDelete.add(RelativeLayoutConversionHelper.getElement(view));
            }
            Element parentElement = RelativeLayoutConversionHelper.getElement(view);
            Rectangle parentBounds = view.getAbsRect();
            for (CanvasViewInfo child : view.getChildren()) {
                Rectangle childBounds = child.getAbsRect();
                Element childElement = RelativeLayoutConversionHelper.getElement(child);
                if (parentBounds.x == childBounds.x) {
                    this.mSharedLeftEdge.put(childElement, parentElement);
                }
                if (parentBounds.y == childBounds.y) {
                    this.mSharedTopEdge.put(childElement, parentElement);
                }
                if (parentBounds.x + parentBounds.width == childBounds.x + childBounds.width) {
                    this.mSharedRightEdge.put(childElement, parentElement);
                }
                if (parentBounds.y + parentBounds.height == childBounds.y + childBounds.height) {
                    this.mSharedBottomEdge.put(childElement, parentElement);
                }
                if (RelativeLayoutConversionHelper.this.mFlatten && this.isRemovableLayout(child)) {
                    for (CanvasViewInfo childView : child.getChildren()) {
                        this.analyze(childView, false);
                        Element childViewElement = RelativeLayoutConversionHelper.getElement(childView);
                        Rectangle childViewBounds = childView.getAbsRect();
                        if (parentBounds.x == childViewBounds.x) {
                            this.mSharedLeftEdge.put(childViewElement, parentElement);
                        }
                        if (parentBounds.y == childViewBounds.y) {
                            this.mSharedTopEdge.put(childViewElement, parentElement);
                        }
                        if (parentBounds.x + parentBounds.width == childViewBounds.x + childViewBounds.width) {
                            this.mSharedRightEdge.put(childViewElement, parentElement);
                        }
                        if (parentBounds.y + parentBounds.height != childViewBounds.y + childViewBounds.height) continue;
                        this.mSharedBottomEdge.put(childViewElement, parentElement);
                    }
                    this.mDelete.add(childElement);
                    continue;
                }
                this.analyze(child, false);
            }
            return added;
        }

        public View getSharedLeftEdge(Element element) {
            return this.getSharedEdge(element, this.mSharedLeftEdge);
        }

        public View getSharedRightEdge(Element element) {
            return this.getSharedEdge(element, this.mSharedRightEdge);
        }

        public View getSharedTopEdge(Element element) {
            return this.getSharedEdge(element, this.mSharedTopEdge);
        }

        public View getSharedBottomEdge(Element element) {
            return this.getSharedEdge(element, this.mSharedBottomEdge);
        }

        private View getSharedEdge(Element element, Map<Element, Element> sharedEdgeMap) {
            Element original = element;
            while (element != null) {
                View view = this.getView(element);
                if (view != null) {
                    assert (RelativeLayoutConversionHelper.isAncestor(element, original));
                    return view;
                }
                element = sharedEdgeMap.get(element);
            }
            return null;
        }

        private View add(CanvasViewInfo info) {
            Rectangle bounds = info.getAbsRect();
            Element element = RelativeLayoutConversionHelper.getElement(info);
            View view = new View(info, element);
            this.mElementToViewMap.put(element, view);
            this.record(this.mLeft, bounds.x, view);
            this.record(this.mTop, bounds.y, view);
            this.record(this.mRight, view.getRightEdge(), view);
            this.record(this.mBottom, view.getBottomEdge(), view);
            return view;
        }

        private boolean isRemovableLayout(CanvasViewInfo child) {
            Element element = RelativeLayoutConversionHelper.getElement(child);
            if (element == RelativeLayoutConversionHelper.this.mLayout) {
                return false;
            }
            ElementDescriptor descriptor = child.getUiViewNode().getDescriptor();
            String name = descriptor.getXmlLocalName();
            if (name.equals("LinearLayout") || name.equals("RelativeLayout")) {
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background")) {
                    AndmoreAndroidPlugin.log(2, "Did not flatten layout %1$s because it defines a '%2$s' attribute", VisualRefactoring.getId(element), "background");
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class Grid {
        private final int[] mLeft;
        private final int[] mTop;
        private final List<List<List<View>>> mRowList;
        private int mRowCount;
        private int mColCount;

        Grid(List<View> views, int[] left, int[] top) {
            this.mLeft = left;
            this.mTop = top;
            this.mColCount = left.length - 1;
            this.mRowCount = top.length - 1;
            this.mRowList = new ArrayList<List<List<View>>>(top.length);
            int row = 0;
            while (row < top.length) {
                ArrayList columnList = new ArrayList(left.length);
                int col = 0;
                while (col < left.length) {
                    columnList.add(new ArrayList(4));
                    ++col;
                }
                this.mRowList.add(columnList);
                ++row;
            }
            for (View view : views) {
                if (view.mElement == RelativeLayoutConversionHelper.this.mLayout) continue;
                int i = 0;
                while (i < view.mRowSpan) {
                    int j = 0;
                    while (j < view.mColSpan) {
                        this.mRowList.get(view.mRow + i).get(view.mCol + j).add(view);
                        ++j;
                    }
                    ++i;
                }
            }
        }

        public int getRows() {
            return this.mRowCount;
        }

        public int getColumns() {
            return this.mColCount;
        }

        public List<View> get(int row, int col) {
            return this.mRowList.get(row).get(col);
        }

        public boolean colContainsTopLeftCorner(int column) {
            int row = 0;
            while (row < this.mRowCount) {
                View view = this.getTopLeftCorner(row, column);
                if (view != null) {
                    return true;
                }
                ++row;
            }
            return false;
        }

        public boolean rowContainsTopLeftCorner(int row) {
            int col = 0;
            while (col < this.mColCount) {
                View view = this.getTopLeftCorner(row, col);
                if (view != null) {
                    return true;
                }
                ++col;
            }
            return false;
        }

        public List<View> viewsStartingInCol(int col, boolean sort) {
            ArrayList<View> views = new ArrayList<View>();
            int row = 0;
            while (row < this.mRowCount) {
                View view = this.getTopLeftCorner(row, col);
                if (view != null) {
                    views.add(view);
                }
                ++row;
            }
            if (sort) {
                View.sortByRow(views);
            }
            return views;
        }

        public List<View> viewsStartingInRow(int row, boolean sort) {
            ArrayList<View> views = new ArrayList<View>();
            int col = 0;
            while (col < this.mColCount) {
                View view = this.getTopLeftCorner(row, col);
                if (view != null) {
                    views.add(view);
                }
                ++col;
            }
            if (sort) {
                View.sortByColumn(views);
            }
            return views;
        }

        public int getColumnWidth(int col) {
            return this.mLeft[col + 1] - this.mLeft[col];
        }

        public int getRowHeight(int row) {
            return this.mTop[row + 1] - this.mTop[row];
        }

        View getTopLeftCorner(int row, int col) {
            List<View> views = this.get(row, col);
            if (views.size() > 0) {
                for (View view : views) {
                    if (view.mRow != row || view.mCol != col) continue;
                    return view;
                }
            }
            return null;
        }

        public View findRightEdgeView(int col) {
            int row = 0;
            while (row < this.mRowCount) {
                List<View> views = this.get(row, col);
                if (views.size() > 0) {
                    ArrayList<View> result = new ArrayList<View>();
                    for (View view : views) {
                        if (view.mCol + view.mColSpan != col + 1) continue;
                        result.add(view);
                    }
                    if (result.size() > 1) {
                        View.sortByColumn(result);
                    }
                    if (result.size() > 0) {
                        return (View)result.get(0);
                    }
                }
                ++row;
            }
            return null;
        }

        public View findBottomEdgeView(int row) {
            int col = 0;
            while (col < this.mColCount) {
                List<View> views = this.get(row, col);
                if (views.size() > 0) {
                    ArrayList<View> result = new ArrayList<View>();
                    for (View view : views) {
                        if (view.mRow + view.mRowSpan != row + 1) continue;
                        result.add(view);
                    }
                    if (result.size() > 1) {
                        View.sortByRow(result);
                    }
                    if (result.size() > 0) {
                        return (View)result.get(0);
                    }
                }
                ++col;
            }
            return null;
        }

        public String toString() {
            int cellWidth = 20;
            StringWriter stringWriter = new StringWriter();
            PrintWriter out = new PrintWriter(stringWriter);
            out.printf("%" + cellWidth + "s", "");
            int col = 0;
            while (col < this.mColCount + 1) {
                out.printf("|%-" + (cellWidth - 1) + "d", this.mLeft[col]);
                ++col;
            }
            out.printf("\n", new Object[0]);
            int row = 0;
            while (row < this.mRowCount + 1) {
                out.printf("%" + cellWidth + "d", this.mTop[row]);
                if (row == this.mRowCount) break;
                int col2 = 0;
                while (col2 < this.mColCount) {
                    List<View> views = this.get(row, col2);
                    StringBuilder sb = new StringBuilder();
                    for (View view : views) {
                        String id;
                        String string = id = view != null ? view.getId() : "";
                        if (id.startsWith("@+id/")) {
                            id = id.substring("@+id/".length());
                        }
                        if (id.length() > cellWidth - 2) {
                            id = id.substring(0, cellWidth - 2);
                        }
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(id);
                    }
                    String cellString = sb.toString();
                    if (cellString.contains(",") && cellString.length() > cellWidth - 2) {
                        cellString = String.valueOf(cellString.substring(0, cellWidth - 6)) + "...,";
                    }
                    out.printf("|%-" + (cellWidth - 2) + "s ", cellString);
                    ++col2;
                }
                out.printf("\n", new Object[0]);
                ++row;
            }
            out.flush();
            return stringWriter.toString();
        }
    }

    private static class View {
        private final Element mElement;
        private int mRow = -1;
        private int mCol = -1;
        private int mRowSpan = -1;
        private int mColSpan = -1;
        private CanvasViewInfo mInfo;
        private String mId;
        private List<Pair<String, String>> mHorizConstraints = new ArrayList<Pair<String, String>>(4);
        private List<Pair<String, String>> mVerticalConstraints = new ArrayList<Pair<String, String>>(4);
        private int mGravity;

        public View(CanvasViewInfo view, Element element) {
            this.mInfo = view;
            this.mElement = element;
            this.mGravity = GravityHelper.getGravity(element);
        }

        public int getHeight() {
            return this.mInfo.getAbsRect().height;
        }

        public int getGravity() {
            return this.mGravity;
        }

        public String getId() {
            return this.mId;
        }

        public Element getElement() {
            return this.mElement;
        }

        public List<Pair<String, String>> getHorizConstraints() {
            return this.mHorizConstraints;
        }

        public List<Pair<String, String>> getVerticalConstraints() {
            return this.mVerticalConstraints;
        }

        public boolean isConstrainedHorizontally() {
            return this.mHorizConstraints.size() > 0;
        }

        public boolean isConstrainedVertically() {
            return this.mVerticalConstraints.size() > 0;
        }

        public void addHorizConstraint(String property, String value) {
            assert (property != null && value != null);
            this.mHorizConstraints.add((Pair<String, String>)Pair.of((Object)property, (Object)value));
        }

        public void addVerticalConstraint(String property, String value) {
            assert (property != null && value != null);
            this.mVerticalConstraints.add((Pair<String, String>)Pair.of((Object)property, (Object)value));
        }

        public int getLeftEdge() {
            return this.mInfo.getAbsRect().x;
        }

        public int getTopEdge() {
            return this.mInfo.getAbsRect().y;
        }

        public int getRightEdge() {
            Rectangle bounds = this.mInfo.getAbsRect();
            return bounds.x + bounds.width + 1;
        }

        public int getBottomEdge() {
            Rectangle bounds = this.mInfo.getAbsRect();
            return bounds.y + bounds.height + 1;
        }

        public String toString() {
            return "View [mId=" + this.mId + "]";
        }

        public static void sortByRow(List<View> views) {
            Collections.sort(views, new ViewComparator(true));
        }

        public static void sortByColumn(List<View> views) {
            Collections.sort(views, new ViewComparator(false));
        }

        private static class ViewComparator
        implements Comparator<View> {
            boolean mRowSort;

            public ViewComparator(boolean rowSort) {
                this.mRowSort = rowSort;
            }

            @Override
            public int compare(View view1, View view2) {
                if (this.mRowSort) {
                    return view1.mRow - view2.mRow;
                }
                return view1.mCol - view2.mCol;
            }
        }
    }
}

