/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.CustomViewFinder;
import org.eclipse.andmore.internal.editors.layout.gre.ViewMetadataRepository;
import org.eclipse.andmore.internal.editors.layout.refactoring.ChangeViewRefactoring;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoringWizard;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class ChangeViewWizard
extends VisualRefactoringWizard {
    private static final String SEPARATOR_LABEL = "----------------------------------------";

    public ChangeViewWizard(ChangeViewRefactoring ref, LayoutEditorDelegate editor) {
        super(ref, editor);
        this.setDefaultPageTitle("Change Widget Type");
    }

    protected void addUserInputPages() {
        ChangeViewRefactoring ref = (ChangeViewRefactoring)this.getRefactoring();
        List<String> oldTypes = ref.getOldTypes();
        String oldType = null;
        for (String type : oldTypes) {
            if (oldType == null) {
                oldType = type;
                continue;
            }
            if (oldType.equals(type)) continue;
            oldType = null;
            break;
        }
        this.addPage((IWizardPage)new InputPage(this.mDelegate.getEditor().getProject(), oldType));
    }

    private static class InputPage
    extends VisualRefactoringWizard.VisualRefactoringInputPage {
        private final IProject mProject;
        private Combo mTypeCombo;
        private final String mOldType;
        private List<String> mClassNames;

        public InputPage(IProject project, String oldType) {
            super("ChangeViewInputPage");
            this.mProject = project;
            this.mOldType = oldType;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label typeLabel = new Label(composite, 0);
            typeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            typeLabel.setText("New Widget Type:");
            this.mTypeCombo = new Combo(composite, 8);
            this.mTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.mTypeCombo.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            this.mClassNames = this.getWidgetTypes(this.mOldType, this.mTypeCombo);
            this.mTypeCombo.select(0);
            this.setControl((Control)composite);
            this.validatePage();
            this.mTypeCombo.setFocus();
        }

        private List<String> getWidgetTypes(String oldType, Combo combo) {
            ArrayList<String> classNames = new ArrayList<String>();
            Sdk currentSdk = Sdk.getCurrent();
            if (currentSdk != null) {
                IAndroidTarget target = currentSdk.getTarget(this.mProject);
                if (target != null) {
                    AndroidTargetData targetData;
                    ViewMetadataRepository repository;
                    List<String> relatedTo;
                    if (oldType != null && (relatedTo = (repository = ViewMetadataRepository.get()).getRelatedTo(oldType)).size() > 0) {
                        for (String className : relatedTo) {
                            String base = className.substring(className.lastIndexOf(46) + 1);
                            combo.add(base);
                            classNames.add(className);
                        }
                        combo.add(ChangeViewWizard.SEPARATOR_LABEL);
                        classNames.add(null);
                    }
                    Pair<List<String>, List<String>> result = CustomViewFinder.findViews(this.mProject, false);
                    List customViews = (List)result.getFirst();
                    List thirdPartyViews = (List)result.getSecond();
                    if (customViews.size() > 0) {
                        for (String view : customViews) {
                            combo.add(view);
                            classNames.add(view);
                        }
                        combo.add(ChangeViewWizard.SEPARATOR_LABEL);
                        classNames.add(null);
                    }
                    if (thirdPartyViews.size() > 0) {
                        for (String view : thirdPartyViews) {
                            combo.add(view);
                            classNames.add(view);
                        }
                        combo.add(ChangeViewWizard.SEPARATOR_LABEL);
                        classNames.add(null);
                    }
                    if ((targetData = currentSdk.getTargetData(target)) != null) {
                        List<ViewElementDescriptor> descriptors = targetData.getLayoutDescriptors().getViewDescriptors();
                        for (ViewElementDescriptor d : descriptors) {
                            String className = d.getFullClassName();
                            if (className.equals("include") || className.equals("fragment") || className.equals("requestFocus")) continue;
                            combo.add(d.getUiName());
                            classNames.add(className);
                        }
                    }
                }
            } else {
                combo.add("SDK not initialized");
                classNames.add(null);
            }
            return classNames;
        }

        @Override
        protected boolean validatePage() {
            String type;
            boolean ok = true;
            int selectionIndex = this.mTypeCombo.getSelectionIndex();
            String string = type = selectionIndex != -1 ? this.mClassNames.get(selectionIndex) : null;
            if (type == null) {
                this.setErrorMessage("Select a widget type to convert to");
                ok = false;
            } else {
                this.setErrorMessage(null);
            }
            ChangeViewRefactoring refactoring = (ChangeViewRefactoring)this.getRefactoring();
            refactoring.setType(type);
            this.setPageComplete(ok);
            return ok;
        }
    }
}

