/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import com.android.utils.Pair;
import java.util.HashSet;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gre.PaletteMetadataDescriptor;
import org.eclipse.andmore.internal.editors.layout.refactoring.ChangeLayoutRefactoring;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoringWizard;
import org.eclipse.andmore.internal.editors.layout.refactoring.WrapInWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class ChangeLayoutWizard
extends VisualRefactoringWizard {
    public ChangeLayoutWizard(ChangeLayoutRefactoring ref, LayoutEditorDelegate editor) {
        super(ref, editor);
        this.setDefaultPageTitle("Change Layout");
    }

    protected void addUserInputPages() {
        ChangeLayoutRefactoring ref = (ChangeLayoutRefactoring)this.getRefactoring();
        String oldType = ref.getOldType();
        this.addPage((IWizardPage)new InputPage(this.mDelegate.getEditor().getProject(), oldType));
    }

    private static class InputPage
    extends VisualRefactoringWizard.VisualRefactoringInputPage {
        private final IProject mProject;
        private final String mOldType;
        private Combo mTypeCombo;
        private Button mFlatten;
        private List<Pair<String, ViewElementDescriptor>> mClassNames;

        public InputPage(IProject project, String oldType) {
            super("ChangeLayoutInputPage");
            this.mProject = project;
            this.mOldType = oldType;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label fromLabel = new Label(composite, 0);
            fromLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            String oldTypeBase = this.mOldType.substring(this.mOldType.lastIndexOf(46) + 1);
            fromLabel.setText(String.format("Change from %1$s", oldTypeBase));
            Label typeLabel = new Label(composite, 0);
            typeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            typeLabel.setText("New Layout Type:");
            this.mTypeCombo = new Combo(composite, 8);
            this.mTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputPage.this.validatePage();
                    String text = InputPage.this.mTypeCombo.getText();
                    InputPage.this.mFlatten.setVisible(text.equals("RelativeLayout") || text.equals("GridLayout"));
                }
            };
            this.mTypeCombo.addSelectionListener((SelectionListener)selectionListener);
            this.mTypeCombo.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            this.mFlatten = new Button(composite, 32);
            this.mFlatten.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.mFlatten.setText("Flatten hierarchy");
            this.mFlatten.addSelectionListener((SelectionListener)selectionListener);
            this.mFlatten.setSelection(true);
            this.mFlatten.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            HashSet<String> exclude = new HashSet<String>();
            exclude.add("include");
            exclude.add("merge");
            exclude.add("fragment");
            boolean oldIsRelativeLayout = this.mOldType.equals("android.widget.RelativeLayout");
            boolean oldIsGridLayout = this.mOldType.equals("android.widget.GridLayout");
            if (oldIsRelativeLayout || oldIsGridLayout) {
                exclude.add(this.mOldType);
            }
            this.mClassNames = WrapInWizard.addLayouts(this.mProject, this.mOldType, this.mTypeCombo, exclude, false);
            boolean gridLayoutAvailable = false;
            int i = 0;
            while (i < this.mTypeCombo.getItemCount()) {
                if (this.mTypeCombo.getItem(i).equals("GridLayout")) {
                    gridLayoutAvailable = true;
                    break;
                }
                ++i;
            }
            this.mTypeCombo.select(0);
            if (gridLayoutAvailable && !oldIsGridLayout) {
                i = 0;
                while (i < this.mTypeCombo.getItemCount()) {
                    if (this.mTypeCombo.getItem(i).equals("GridLayout")) {
                        this.mTypeCombo.select(i);
                        break;
                    }
                    ++i;
                }
            } else if (!oldIsRelativeLayout) {
                i = 0;
                while (i < this.mTypeCombo.getItemCount()) {
                    if (this.mTypeCombo.getItem(i).equals("RelativeLayout")) {
                        this.mTypeCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.mFlatten.setVisible(this.mTypeCombo.getText().equals("RelativeLayout") || this.mTypeCombo.getText().equals("GridLayout"));
            this.setControl((Control)composite);
            this.validatePage();
        }

        @Override
        protected boolean validatePage() {
            String type;
            boolean ok = true;
            int selectionIndex = this.mTypeCombo.getSelectionIndex();
            String string = type = selectionIndex != -1 ? (String)this.mClassNames.get(selectionIndex).getFirst() : null;
            if (type == null) {
                this.setErrorMessage("Select a layout type");
                ok = false;
            } else {
                this.setErrorMessage(null);
                ChangeLayoutRefactoring refactoring = (ChangeLayoutRefactoring)this.getRefactoring();
                refactoring.setType(type);
                refactoring.setFlatten(this.mFlatten.getSelection());
                ViewElementDescriptor descriptor = (ViewElementDescriptor)this.mClassNames.get(selectionIndex).getSecond();
                if (descriptor instanceof PaletteMetadataDescriptor) {
                    PaletteMetadataDescriptor paletteDescriptor = (PaletteMetadataDescriptor)descriptor;
                    String initializedAttributes = paletteDescriptor.getInitializedAttributes();
                    if (initializedAttributes != null && initializedAttributes.length() > 0) {
                        refactoring.setInitializedAttributes(initializedAttributes);
                    }
                } else {
                    refactoring.setInitializedAttributes(null);
                }
            }
            this.setPageComplete(ok);
            return ok;
        }
    }
}

