/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.properties;

import com.android.ide.common.api.IAttributeInfo;
import com.android.utils.SdkUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.layout.properties.ResourceValueCompleter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

abstract class ValueCompleter
implements IContentProposalProvider {
    ValueCompleter() {
    }

    protected abstract CommonXmlEditor getEditor();

    protected abstract AttributeDescriptor getDescriptor();

    public IContentProposal[] getProposals(String contents, int position) {
        String[] values;
        CommonXmlEditor editor;
        int c;
        AttributeDescriptor descriptor = this.getDescriptor();
        IAttributeInfo info = descriptor.getAttributeInfo();
        EnumSet formats = info.getFormats();
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        String prefix = contents;
        if (formats.contains(IAttributeInfo.Format.STRING) && !contents.isEmpty() && (formats.size() > 1 && formats.contains(IAttributeInfo.Format.REFERENCE) || formats.size() > 2) && !contents.startsWith("@") && !contents.startsWith("?")) {
            proposals.add(new ContentProposal(contents));
        }
        if (!contents.isEmpty() && Character.isDigit(contents.charAt(0)) && (formats.contains(IAttributeInfo.Format.DIMENSION) || formats.contains(IAttributeInfo.Format.INTEGER) || formats.contains(IAttributeInfo.Format.FLOAT))) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            int n = contents.length();
            while (i < n) {
                c = contents.charAt(i);
                if (!Character.isDigit((char)c)) break;
                sb.append((char)c);
                ++i;
            }
            String number = sb.toString();
            if (formats.contains(IAttributeInfo.Format.DIMENSION)) {
                if (descriptor.getXmlLocalName().equals("textSize")) {
                    proposals.add(new ContentProposal(String.valueOf(number) + "sp"));
                }
                proposals.add(new ContentProposal(String.valueOf(number) + "dp"));
            } else if (formats.contains(IAttributeInfo.Format.INTEGER)) {
                proposals.add(new ContentProposal(number));
            }
        }
        if ((formats.contains(IAttributeInfo.Format.REFERENCE) || contents.startsWith("@") || contents.startsWith("?")) && (editor = this.getEditor()) != null) {
            String[] matches;
            String[] stringArray = matches = ResourceValueCompleter.computeResourceStringMatches(editor, descriptor, contents.substring(0, position));
            int n = matches.length;
            c = 0;
            while (c < n) {
                String match = stringArray[c];
                proposals.add(new ContentProposal(match));
                ++c;
            }
        }
        if (formats.contains(IAttributeInfo.Format.FLAG)) {
            values = info.getFlagValues();
            if (values != null) {
                int flagStart = prefix.lastIndexOf(124);
                String prepend = null;
                if (flagStart != -1) {
                    prepend = prefix.substring(0, flagStart + 1);
                    prefix = prefix.substring(flagStart + 1).trim();
                }
                boolean exactMatch = false;
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (prefix.equals(value)) {
                        exactMatch = true;
                        proposals.add(new ContentProposal(contents));
                        break;
                    }
                    ++n2;
                }
                if (exactMatch) {
                    prepend = String.valueOf(contents) + '|';
                    prefix = "";
                }
                stringArray = values;
                n = values.length;
                n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (SdkUtils.startsWithIgnoreCase((String)value, (String)prefix) && (prepend == null || !prepend.contains(value))) {
                        String match = prepend != null ? String.valueOf(prepend) + value : value;
                        proposals.add(new ContentProposal(match));
                    }
                    ++n2;
                }
            }
        } else if (formats.contains(IAttributeInfo.Format.ENUM)) {
            values = info.getEnumValues();
            if (values != null) {
                String value;
                String[] stringArray = values;
                int n = values.length;
                int n3 = 0;
                while (n3 < n) {
                    value = stringArray[n3];
                    if (SdkUtils.startsWithIgnoreCase((String)value, (String)prefix)) {
                        proposals.add(new ContentProposal(value));
                    }
                    ++n3;
                }
                stringArray = values;
                n = values.length;
                n3 = 0;
                while (n3 < n) {
                    value = stringArray[n3];
                    if (!SdkUtils.startsWithIgnoreCase((String)value, (String)prefix)) {
                        proposals.add(new ContentProposal(value));
                    }
                    ++n3;
                }
            }
        } else if (formats.contains(IAttributeInfo.Format.BOOLEAN)) {
            proposals.add(new ContentProposal("true"));
            proposals.add(new ContentProposal("false"));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }
}

