/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.properties;

import org.eclipse.andmore.internal.editors.layout.properties.XmlPropertyEditor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public class BooleanXmlPropertyEditor
extends XmlPropertyEditor {
    public static final BooleanXmlPropertyEditor INSTANCE = new BooleanXmlPropertyEditor();
    private static final Image mTrueImage = DesignerPlugin.getImage((String)"properties/true.png");
    private static final Image mFalseImage = DesignerPlugin.getImage((String)"properties/false.png");
    private static final Image mNullImage = DesignerPlugin.getImage((String)"properties/BooleanNull.png");
    private static final Image mUnknownImage = DesignerPlugin.getImage((String)"properties/BooleanUnknown.png");

    private BooleanXmlPropertyEditor() {
    }

    @Override
    public void paint(Property property, GC gc, int x, int y, int width, int height) throws Exception {
        Object value = property.getValue();
        assert (value == null || value instanceof String);
        if (value == null || value instanceof String) {
            String text = (String)value;
            Image image = "true".equals(text) ? mTrueImage : ("false".equals(text) ? mFalseImage : (text == null ? mNullImage : mUnknownImage));
            DrawUtils.drawImageCV((GC)gc, (Image)image, (int)x, (int)y, (int)height);
            int imageWidth = image.getBounds().width + 2;
            width -= imageWidth;
            if (text != null) {
                DrawUtils.drawStringCV((GC)gc, (String)text, (int)(x += imageWidth), (int)y, (int)width, (int)height);
            }
        }
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null || location.x < BooleanXmlPropertyEditor.mTrueImage.getBounds().width + 2) {
            this.cycleValue(property);
        }
        return false;
    }

    public void doubleClick(Property property, Point location) throws Exception {
        this.cycleValue(property);
    }

    private void cycleValue(Property property) throws Exception {
        Object value = property.getValue();
        if (value == null || value instanceof String) {
            String text = (String)value;
            if ("true".equals(text)) {
                property.setValue((Object)"false");
            } else if ("false".equals(text)) {
                property.setValue(null);
            } else {
                property.setValue((Object)"true");
            }
        } else assert (false);
    }
}

