/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gre;

import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.ResizePolicy;
import com.android.resources.Density;
import com.android.utils.Pair;
import com.google.common.base.Splitter;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.descriptors.LayoutDescriptors;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gre.PaletteMetadataDescriptor;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ViewMetadataRepository {
    private static final String PREVIEW_CONFIG_FILENAME = "rendering-configs.xml";
    private static final String METADATA_FILENAME = "extra-view-metadata.xml";
    private static ViewMetadataRepository sInstance = new ViewMetadataRepository();
    private static int sNextOrdinal = 0;
    private List<CategoryData> mCategories;
    private Map<String, ViewData> mClassToView;
    public static final boolean INSETS_SUPPORTED = false;
    private static final String HOLO_PREFIX = "Theme.Holo";

    public static ViewMetadataRepository get() {
        return sInstance;
    }

    private ViewMetadataRepository() {
    }

    private Map<String, ViewData> getClassToView() {
        if (this.mClassToView == null) {
            int initialSize = 75;
            this.mClassToView = new HashMap<String, ViewData>(initialSize);
            List<CategoryData> categories = this.getCategories();
            for (CategoryData category : categories) {
                for (ViewData view : category) {
                    this.mClassToView.put(view.getFcqn(), view);
                }
            }
            assert (this.mClassToView.size() <= initialSize);
        }
        return this.mClassToView;
    }

    public Document getRenderingConfigDoc() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Class<ViewMetadataRepository> clz = ViewMetadataRepository.class;
        InputStream paletteStream = clz.getResourceAsStream(PREVIEW_CONFIG_FILENAME);
        InputSource is = new InputSource(paletteStream);
        try {
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            return document;
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.log(e, "Parsing palette file failed", new Object[0]);
            return null;
        }
        finally {
            Closeables.closeQuietly((InputStream)paletteStream);
        }
    }

    public String getFullClassName(Element element) {
        String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
        if ("@android:id/tabhost".equals(id)) {
            Element child;
            String childId;
            NodeList children = element.getChildNodes();
            if (children.getLength() > 1 && children.item(1) instanceof Element && "@+id/android_widget_TabWidget".equals(childId = (child = (Element)children.item(1)).getAttributeNS("http://schemas.android.com/apk/res/android", "id"))) {
                return "android.widget.TabWidget";
            }
            return "android.widget.TabHost";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (id.startsWith("@+id/")) {
            i = "@+id/".length();
        } else if (id.startsWith("@id/")) {
            i = "@id/".length();
        }
        while (i < id.length()) {
            char c = id.charAt(i);
            if (c == '_') {
                sb.append('.');
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private List<CategoryData> getCategories() {
        if (this.mCategories == null) {
            this.mCategories = new ArrayList<CategoryData>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Class<ViewMetadataRepository> clz = ViewMetadataRepository.class;
            InputStream inputStream = clz.getResourceAsStream(METADATA_FILENAME);
            InputSource is = new InputSource(new BufferedInputStream(inputStream));
            try {
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(is);
                HashMap<String, IViewMetadata.FillPreference> fillTypes = new HashMap<String, IViewMetadata.FillPreference>();
                IViewMetadata.FillPreference[] fillPreferenceArray = IViewMetadata.FillPreference.values();
                int n = fillPreferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewMetadata.FillPreference pref = fillPreferenceArray[n2];
                    fillTypes.put(pref.toString().toLowerCase(Locale.US), pref);
                    ++n2;
                }
                NodeList categoryNodes = document.getDocumentElement().getChildNodes();
                int i = 0;
                int n3 = categoryNodes.getLength();
                while (i < n3) {
                    Element element;
                    Node node = categoryNodes.item(i);
                    if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equals("category")) {
                        String name = element.getAttribute("name");
                        CategoryData category = new CategoryData(name);
                        NodeList children = element.getChildNodes();
                        int j = 0;
                        int m = children.getLength();
                        while (j < m) {
                            Node childNode = children.item(j);
                            if (childNode.getNodeType() == 1) {
                                Element child = (Element)childNode;
                                ViewData view = this.createViewData(fillTypes, child, null, IViewMetadata.FillPreference.NONE, RenderMode.NORMAL, null);
                                category.addView(view);
                            }
                            ++j;
                        }
                        this.mCategories.add(category);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "Invalid palette metadata", new Object[0]);
            }
        }
        return this.mCategories;
    }

    private ViewData createViewData(Map<String, IViewMetadata.FillPreference> fillTypes, Element child, String defaultFqcn, IViewMetadata.FillPreference defaultFill, RenderMode defaultRender, String defaultSize) {
        String displayName;
        String fqcn = child.getAttribute("class");
        if (fqcn.length() == 0) {
            fqcn = defaultFqcn;
        }
        String fill = child.getAttribute("fill");
        IViewMetadata.FillPreference fillPreference = null;
        if (fill.length() > 0) {
            fillPreference = fillTypes.get(fill);
        }
        if (fillPreference == null) {
            fillPreference = defaultFill;
        }
        String skip = child.getAttribute("skip");
        RenderMode renderMode = defaultRender;
        String render = child.getAttribute("render");
        if (render.length() > 0) {
            renderMode = RenderMode.get(render);
        }
        if ((displayName = child.getAttribute("name")).length() == 0) {
            displayName = null;
        }
        String relatedTo = child.getAttribute("relatedTo");
        String topAttrs = child.getAttribute("topAttrs");
        String resize = child.getAttribute("resize");
        ViewData view = new ViewData(fqcn, displayName, fillPreference, skip.length() == 0 ? false : Boolean.valueOf(skip), renderMode, relatedTo, resize, topAttrs);
        String init = child.getAttribute("init");
        String icon = child.getAttribute("icon");
        view.setInitString(init);
        if (icon.length() > 0) {
            view.setIconName(icon);
        }
        if (child.hasChildNodes()) {
            NodeList childNodes = child.getChildNodes();
            int k = 0;
            int kl = childNodes.getLength();
            while (k < kl) {
                Node variationNode = childNodes.item(k);
                if (variationNode.getNodeType() == 1) {
                    Element variation = (Element)variationNode;
                    ViewData variationView = this.createViewData(fillTypes, variation, fqcn, fillPreference, renderMode, resize);
                    view.addVariation(variationView);
                }
                ++k;
            }
        }
        return view;
    }

    public List<Pair<String, List<ViewElementDescriptor>>> getPaletteEntries(AndroidTargetData targetData, boolean alphabetical, boolean createCategories) {
        ArrayList<Pair<String, List<ViewElementDescriptor>>> result = new ArrayList<Pair<String, List<ViewElementDescriptor>>>();
        ArrayList<List<ViewElementDescriptor>> lists = new ArrayList<List<ViewElementDescriptor>>(2);
        LayoutDescriptors layoutDescriptors = targetData.getLayoutDescriptors();
        lists.add(layoutDescriptors.getViewDescriptors());
        lists.add(layoutDescriptors.getLayoutDescriptors());
        HashMap<String, ViewElementDescriptor> fqcnToDescriptor = new HashMap<String, ViewElementDescriptor>();
        for (List list : lists) {
            for (ViewElementDescriptor view : list) {
                String fqcn = view.getFullClassName();
                if (fqcn == null) {
                    fqcn = view.getUiName();
                }
                fqcnToDescriptor.put(fqcn, view);
            }
        }
        HashSet<ViewElementDescriptor> hashSet = new HashSet<ViewElementDescriptor>(layoutDescriptors.getViewDescriptors().size() + layoutDescriptors.getLayoutDescriptors().size());
        hashSet.addAll(layoutDescriptors.getViewDescriptors());
        hashSet.addAll(layoutDescriptors.getLayoutDescriptors());
        ArrayList<ViewElementDescriptor> categoryItems = new ArrayList<ViewElementDescriptor>();
        for (CategoryData category : this.getCategories()) {
            if (createCategories) {
                categoryItems = new ArrayList();
            }
            for (ViewData view : category) {
                String fqcn = view.getFcqn();
                ViewElementDescriptor descriptor = (ViewElementDescriptor)fqcnToDescriptor.get(fqcn);
                if (descriptor == null) continue;
                hashSet.remove(descriptor);
                if (view.getSkip()) continue;
                if (view.getDisplayName() != null || view.getInitString().length() > 0) {
                    categoryItems.add(new PaletteMetadataDescriptor(descriptor, view.getDisplayName(), view.getInitString(), view.getIconName()));
                } else {
                    categoryItems.add(descriptor);
                }
                if (!view.hasVariations()) continue;
                for (ViewData variation : view.getVariations()) {
                    String init = variation.getInitString();
                    String icon = variation.getIconName();
                    PaletteMetadataDescriptor desc = new PaletteMetadataDescriptor(descriptor, variation.getDisplayName(), init, icon);
                    categoryItems.add(desc);
                }
            }
            if (!createCategories || categoryItems.size() <= 0) continue;
            if (alphabetical) {
                Collections.sort(categoryItems);
            }
            result.add((Pair<String, List<ViewElementDescriptor>>)Pair.of((Object)category.getName(), categoryItems));
        }
        if (hashSet.size() > 0) {
            ArrayList otherItems = new ArrayList(hashSet);
            Collections.sort(otherItems);
            if (createCategories) {
                result.add((Pair<String, List<ViewElementDescriptor>>)Pair.of((Object)"Other", otherItems));
            } else {
                categoryItems.addAll(otherItems);
            }
        }
        if (!createCategories) {
            if (alphabetical) {
                Collections.sort(categoryItems);
            }
            result.add((Pair<String, List<ViewElementDescriptor>>)Pair.of((Object)"Views", categoryItems));
        }
        return result;
    }

    Collection<String> getAllFqcns() {
        return this.getClassToView().keySet();
    }

    public IViewMetadata.FillPreference getFillPreference(String fqcn) {
        ViewData view = this.getClassToView().get(fqcn);
        if (view != null) {
            return view.getFillPreference();
        }
        return IViewMetadata.FillPreference.NONE;
    }

    public RenderMode getRenderMode(String fqcn) {
        ViewData view = this.getClassToView().get(fqcn);
        if (view != null) {
            return view.getRenderMode();
        }
        return RenderMode.NORMAL;
    }

    public ResizePolicy getResizePolicy(String fqcn) {
        String resize;
        ViewData view = this.getClassToView().get(fqcn);
        if (view != null && (resize = view.getResize()) != null && resize.length() > 0) {
            if ("full".equals(resize)) {
                return ResizePolicy.full();
            }
            if ("none".equals(resize)) {
                return ResizePolicy.none();
            }
            if ("horizontal".equals(resize)) {
                return ResizePolicy.horizontal();
            }
            if ("vertical".equals(resize)) {
                return ResizePolicy.vertical();
            }
            if ("scaled".equals(resize)) {
                return ResizePolicy.scaled();
            }
            assert (false) : resize;
        }
        return ResizePolicy.full();
    }

    public boolean getSkip(String fqcn) {
        ViewData view = this.getClassToView().get(fqcn);
        if (view != null) {
            return view.getSkip();
        }
        return false;
    }

    public List<String> getTopAttributes(String fqcn) {
        ViewData view = this.getClassToView().get(fqcn);
        if (view != null) {
            return view.getTopAttributes();
        }
        return Collections.singletonList("id");
    }

    public List<String> getRelatedTo(String fqcn) {
        ViewData view = this.getClassToView().get(fqcn);
        if (view != null) {
            return view.getRelatedTo();
        }
        return Collections.emptyList();
    }

    public static Margins getInsets(String fqcn, Density density, String theme) {
        return null;
    }

    private static class CategoryData
    implements Iterable<ViewData>,
    Comparable<CategoryData> {
        private final String mName;
        private final List<ViewData> mViews = new ArrayList<ViewData>();
        private final int mOrdinal;

        private CategoryData(String name) {
            int n = sNextOrdinal;
            sNextOrdinal = n + 1;
            this.mOrdinal = n;
            this.mName = name;
        }

        private void addView(ViewData view) {
            this.mViews.add(view);
        }

        private String getName() {
            return this.mName;
        }

        @Override
        public Iterator<ViewData> iterator() {
            return this.mViews.iterator();
        }

        @Override
        public int compareTo(CategoryData other) {
            return this.mOrdinal - other.mOrdinal;
        }
    }

    public static enum RenderMode {
        NORMAL,
        ALONE,
        SKIP;


        public static RenderMode get(String render) {
            if ("alone".equals(render)) {
                return ALONE;
            }
            if ("skip".equals(render)) {
                return SKIP;
            }
            return NORMAL;
        }
    }

    private static class ViewData
    implements Comparable<ViewData> {
        private final String mFqcn;
        private final IViewMetadata.FillPreference mFillPreference;
        private final boolean mSkip;
        private final RenderMode mRenderMode;
        private final String mRelatedTo;
        private final int mOrdinal;
        private List<ViewData> mVariations;
        private String mDisplayName;
        private String mInitString;
        private String mIconName;
        private String mResize;
        private String mTopAttrs;

        private ViewData(String fqcn, String displayName, IViewMetadata.FillPreference fillPreference, boolean skip, RenderMode renderMode, String relatedTo, String resize, String topAttrs) {
            int n = sNextOrdinal;
            sNextOrdinal = n + 1;
            this.mOrdinal = n;
            this.mFqcn = fqcn;
            this.mDisplayName = displayName;
            this.mFillPreference = fillPreference;
            this.mSkip = skip;
            this.mRenderMode = renderMode;
            this.mRelatedTo = relatedTo;
            this.mResize = resize;
            this.mTopAttrs = topAttrs;
        }

        private IViewMetadata.FillPreference getFillPreference() {
            return this.mFillPreference;
        }

        private String getFcqn() {
            return this.mFqcn;
        }

        private String getDisplayName() {
            return this.mDisplayName;
        }

        private String getResize() {
            return this.mResize;
        }

        @Override
        public int compareTo(ViewData other) {
            return this.mOrdinal - other.mOrdinal;
        }

        public RenderMode getRenderMode() {
            return this.mRenderMode;
        }

        public boolean getSkip() {
            return this.mSkip;
        }

        public List<String> getRelatedTo() {
            if (this.mRelatedTo == null || this.mRelatedTo.length() == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            ViewMetadataRepository repository = ViewMetadataRepository.get();
            Map classToView = repository.getClassToView();
            ArrayList fqns = new ArrayList(classToView.keySet());
            for (String basename : Splitter.on((char)',').split((CharSequence)this.mRelatedTo)) {
                boolean found = false;
                for (String fqcn : fqns) {
                    String suffix;
                    if (!fqcn.endsWith(suffix = String.valueOf('.') + basename)) continue;
                    result.add(fqcn);
                    found = true;
                    break;
                }
                if (basename.equals("fragment") || basename.equals("include")) {
                    result.add(basename);
                    continue;
                }
                assert (found) : basename;
            }
            return result;
        }

        public List<String> getTopAttributes() {
            if (this.mTopAttrs == null || this.mTopAttrs.length() == 0) {
                return Collections.singletonList("id");
            }
            String[] split = this.mTopAttrs.split(",");
            ArrayList<String> topAttributes = new ArrayList<String>(split.length + 1);
            topAttributes.add("id");
            int i = 0;
            int n = split.length;
            while (i < n) {
                topAttributes.add(split[i]);
                ++i;
            }
            return Collections.unmodifiableList(topAttributes);
        }

        void addVariation(ViewData variation) {
            if (this.mVariations == null) {
                this.mVariations = new ArrayList<ViewData>(4);
            }
            this.mVariations.add(variation);
        }

        List<ViewData> getVariations() {
            return this.mVariations;
        }

        boolean hasVariations() {
            return this.mVariations != null && this.mVariations.size() > 0;
        }

        private void setInitString(String initString) {
            this.mInitString = initString;
        }

        private String getInitString() {
            return this.mInitString;
        }

        private void setIconName(String iconName) {
            this.mIconName = iconName;
        }

        private String getIconName() {
            return this.mIconName;
        }
    }
}

