/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.INode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleAttribute
implements INode.IAttribute {
    private final String mName;
    private final String mValue;
    private final String mUri;
    private static final Pattern REGEXP = Pattern.compile("[^@]*@([^:]+):([^=]*)=([^\n]*)\n*");

    public SimpleAttribute(String uri, String name, String value) {
        this.mUri = uri == null ? "" : uri;
        this.mName = name == null ? "" : name;
        this.mValue = value == null ? "" : value;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getName() {
        return this.mName;
    }

    public String getValue() {
        return this.mValue;
    }

    public String toString() {
        return String.format("@%s:%s=%s\n", this.mName, this.mUri, this.mValue);
    }

    static SimpleAttribute parseString(String value) {
        Matcher m = REGEXP.matcher(value);
        if (m.matches()) {
            return new SimpleAttribute(m.group(2), m.group(1), m.group(3));
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleAttribute) {
            SimpleAttribute sa = (SimpleAttribute)obj;
            return this.mName.equals(sa.mName) && this.mUri.equals(sa.mUri) && this.mValue.equals(sa.mValue);
        }
        return false;
    }

    public int hashCode() {
        long c = this.mName.hashCode();
        c = 31L * c + (long)this.mUri.hashCode();
        if ((c = 31L * c + (long)this.mValue.hashCode()) > 0xFFFFFFFFL) {
            c ^= c >> 32;
        }
        return (int)(c & 0xFFFFFFFFL);
    }
}

